/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.db.servicelearning;

import com.hs.atic.collector.biz.event.process.ServiceLearningTaskWrapper;
import com.hs.atic.collector.db.condition.Condition;
import com.hs.atic.collector.db.condition.ConditionClause;
import com.hs.atic.collector.db.event.RepositoryAdaptor;
import com.hs.atic.collector.util.TimeTransformer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ServiceLearningTaskRepository
extends RepositoryAdaptor<ServiceLearningTaskWrapper> {
    private static final String TABLE_NAME = "ATIC_SERVICE_LEARNING_TASK";
    private static final String QUERY_SQL = "SELECT ZONE_ID,DEVICE_IP,START_TIME,END_TIME FROM ATIC_SERVICE_LEARNING_TASK";
    private static final String INSERT_SQL = "INSERT INTO ATIC_SERVICE_LEARNING_TASK(ZONE_ID,DEVICE_IP,START_TIME,END_TIME) VALUES (?,?,?,?)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createObject(ServiceLearningTaskWrapper wrapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("now service learning task to db,task is :" + wrapper.getZoneId()));
        }
        PreparedStatement insert = null;
        Connection con = null;
        try {
            con = this.getConnection();
            insert = con.prepareStatement(INSERT_SQL);
            insert.setLong(1, wrapper.getZoneId());
            insert.setString(2, wrapper.getDeviceIp());
            insert.setLong(3, TimeTransformer.convertTimeString(wrapper.getStartTime()));
            insert.setLong(4, TimeTransformer.convertTimeString(wrapper.getStopTime()));
            insert.execute();
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"create capture task file  to DB error", (Throwable)e);
            }
            catch (Throwable throwable) {
                ServiceLearningTaskRepository.freeDbResource(con, insert);
                throw throwable;
            }
            ServiceLearningTaskRepository.freeDbResource(con, insert);
        }
        ServiceLearningTaskRepository.freeDbResource(con, insert);
    }

    @Override
    public void deleteObject(Condition condition) {
        this.deleteObjectByJdbc(condition, TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServiceLearningTaskWrapper> queryObject(Condition condition) {
        PreparedStatement query = null;
        Connection con = null;
        ResultSet result = null;
        ArrayList<ServiceLearningTaskWrapper> wrapperList = new ArrayList<ServiceLearningTaskWrapper>();
        try {
            con = this.getConnection();
            query = con.prepareStatement("SELECT ZONE_ID,DEVICE_IP,START_TIME,END_TIME FROM ATIC_SERVICE_LEARNING_TASK WHERE " + condition.toSql());
            if (condition instanceof ConditionClause) {
                ConditionClause conditionClause = (ConditionClause)condition;
                List<Object> list = conditionClause.getValueList();
                for (int i = 0; i < list.size(); ++i) {
                    query.setObject(i + 1, list.get(i));
                }
            }
            result = query.executeQuery();
            while (result.next()) {
                ServiceLearningTaskWrapper wrapper = new ServiceLearningTaskWrapper(result.getLong(1), result.getString(2), TimeTransformer.transferlong2String(result.getLong(3) * 1000L), TimeTransformer.transferlong2String(result.getLong(4) * 1000L));
                wrapperList.add(wrapper);
            }
            ServiceLearningTaskRepository.freeDbResource(con, query, result);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"query serviceLearningTaskWrapper error", (Throwable)e);
        }
        finally {
            ServiceLearningTaskRepository.freeDbResource(con, query, result);
        }
        return wrapperList;
    }
}

