/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.alarm;

import com.hs.atic.collector.entity.alarm.AbnormalAlarmEntity;
import com.hs.atic.collector.entity.alarm.IpInfoKey;
import com.hs.atic.collector.entity.event.ToSysLog;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.ZoneUitl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IpAlarmEntity
implements Serializable,
ToSysLog {
    private static final long serialVersionUID = 5066771044267325791L;
    private static final String[] DEVICE_TYPE = new String[]{"CLEAN", "DETECT"};
    private static final int MAX_ABNORMAL = 20;
    private String zoneIp;
    private int direction = 1;
    private String deviceIp;
    private int deviceType;
    private boolean isAlarm = false;
    private long beginTime = 0L;
    private long endTime = 0L;
    private long zoneId;
    private long locationId = 0L;
    private int severity = 0;
    private int maxSeverity = 0;
    private int diversionAction = 0;
    private boolean diverted = false;
    private long currInPps = 0L;
    private long currInKbps = 0L;
    private long currDropPps = 0L;
    private long currDropKbps = 0L;
    private long maxInPps = 0L;
    private long maxInKbps = 0L;
    private long maxDropPps = 0L;
    private long maxDropKbps = 0L;
    private long currConn = 0L;
    private long newConn = 0L;
    private String ports;
    private List<AbnormalAlarmEntity> abnolmalList = new ArrayList<AbnormalAlarmEntity>();

    public IpAlarmEntity() {
    }

    public IpAlarmEntity(IpInfoKey ipInfoKey) {
        this.setZoneIp(ipInfoKey.getZoneIp());
        this.setDeviceIp(ipInfoKey.getDeviceIp());
        this.setDeviceType(ipInfoKey.getDeviceType());
        this.setDirection(ipInfoKey.getDirection());
        this.setZoneId(ipInfoKey.getZoneId());
    }

    public synchronized void addAbnolmal(AbnormalAlarmEntity abnolmal) {
        if (abnolmal.isAlarm()) {
            if (!this.isIsAlarm()) {
                this.isAlarm = true;
                this.setEndTime(0L);
                this.setBeginTime(abnolmal.getStartTime());
                this.abnolmalList.clear();
            }
            if (this.abnolmalList.size() < 20) {
                this.abnolmalList.add(abnolmal);
            }
        } else {
            boolean isAlarmInList = false;
            long pkId = abnolmal.getPkId();
            int abnormalAlarmNumber = 0;
            for (AbnormalAlarmEntity alarm : this.abnolmalList) {
                if (alarm.getPkId() == pkId) {
                    alarm.setAlarm(false);
                    alarm.setDropPacket(abnolmal.getDropPacket());
                    alarm.setDropKbits(abnolmal.getDropKbits());
                    alarm.setEndTime(abnolmal.getEndTime());
                    isAlarmInList = true;
                }
                if (!alarm.isAlarm()) continue;
                ++abnormalAlarmNumber;
            }
            if (!isAlarmInList) {
                this.abnolmalList.add(abnolmal);
            }
            if (abnormalAlarmNumber == 0) {
                this.isAlarm = false;
                this.endTime = abnolmal.getEndTime();
            } else {
                this.endTime = 0L;
            }
        }
    }

    public synchronized void clearEndAbnolmal() {
        Iterator<AbnormalAlarmEntity> iterator = this.abnolmalList.iterator();
        while (iterator.hasNext()) {
            AbnormalAlarmEntity abnormal = iterator.next();
            if (abnormal.isAlarm()) continue;
            iterator.remove();
        }
    }

    public void refreshAbnolmal(AbnormalAlarmEntity abnolmal) {
        long pkId = abnolmal.getPkId();
        for (AbnormalAlarmEntity alarm : this.abnolmalList) {
            if (alarm.getPkId() != pkId) continue;
            alarm.setAlertTypeValue(abnolmal.getAlertTypeValue());
            alarm.setAttacker(abnolmal.getAttacker());
            alarm.setAttackerPpsFlow(abnolmal.getAttackerPpsFlow());
            alarm.setAttackerKbpsFlow(abnolmal.getAttackerKbpsFlow());
            alarm.setCurrentValue(abnolmal.getCurrentValue());
            alarm.setCurrentValue1(abnolmal.getCurrentValue1());
            alarm.setDropPacket(abnolmal.getDropPacket());
            alarm.setDropKbits(abnolmal.getDropKbits());
            alarm.setLimitValue(abnolmal.getLimitValue());
            alarm.setLimitValue1(abnolmal.getLimitValue1());
            alarm.setMultiCurrent(abnolmal.isMultiCurrent());
            alarm.setPpsOrKbps(abnolmal.getPpsOrKbps());
            alarm.setPpsOrKbps1(abnolmal.getPpsOrKbps1());
            alarm.setEndTime(abnolmal.getEndTime());
            alarm.setDropKbps(abnolmal.getDropKbps());
            alarm.setDropPps(abnolmal.getDropPps());
            alarm.setCurrMaxDropKbps(abnolmal.getCurrMaxDropKbps());
            alarm.setCurrMaxDropPps(abnolmal.getCurrMaxDropPps());
        }
    }

    public boolean isContainAttackType(int attackType) {
        for (AbnormalAlarmEntity alarm : this.abnolmalList) {
            if (attackType != alarm.getAlertTypeValue() || !alarm.isAlarm()) continue;
            return true;
        }
        return false;
    }

    public List<AbnormalAlarmEntity> getAbnolmalList() {
        return this.abnolmalList;
    }

    public String getZoneIp() {
        return this.zoneIp;
    }

    public void setZoneIp(String zoneIp) {
        this.zoneIp = zoneIp;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public synchronized boolean isIsAlarm() {
        return this.isAlarm;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(long zoneId) {
        this.zoneId = zoneId;
    }

    public int getSeverity() {
        return this.severity;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
        if (severity > this.maxSeverity) {
            this.maxSeverity = severity;
        }
    }

    public int getDiversionAction() {
        return this.diversionAction;
    }

    public void setDiversionAction(int diversionAction) {
        this.diversionAction = diversionAction;
    }

    public long getCurrInPps() {
        return this.currInPps;
    }

    public void setCurrInPps(long currInPps) {
        this.currInPps = currInPps;
    }

    public long getCurrInKbps() {
        return this.currInKbps;
    }

    public void setCurrInKbps(long currInKbps) {
        this.currInKbps = currInKbps;
    }

    public long getMaxInPps() {
        return this.maxInPps;
    }

    public void setMaxInPps(long maxInPps) {
        this.maxInPps = maxInPps;
    }

    public long getMaxInKbps() {
        return this.maxInKbps;
    }

    public void setMaxInKbps(long maxInKbps) {
        this.maxInKbps = maxInKbps;
    }

    public long getCurrConn() {
        return this.currConn;
    }

    public void setCurrConn(long currConn) {
        this.currConn = currConn;
    }

    public long getNewConn() {
        return this.newConn;
    }

    public void setNewConn(long newConn) {
        this.newConn = newConn;
    }

    public void setDiverted(boolean diverted) {
        this.diverted = diverted;
    }

    public boolean isDiverted() {
        return this.diverted;
    }

    @Override
    public String getHostName() {
        return this.deviceIp;
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("log_type=ip_attack_sum");
        info.add("device_ip=" + this.deviceIp);
        info.add("device_type=" + DEVICE_TYPE[this.deviceType]);
        info.add("direction=" + CommonUtil.getDirectionStr(this.getDirection()));
        info.add("zone_id=" + this.zoneId);
        info.add("zone_name=" + ZoneUitl.getInstance().getZoneNameById(this.zoneId));
        info.add("zone_ip=" + this.zoneIp);
        info.add("start_time=\"" + EventUtil.getTimeStamp(this.beginTime) + "\"");
        if (0L == this.endTime) {
            info.add("end_time=\"\"");
        } else {
            info.add("end_time=\"" + EventUtil.getTimeStamp(this.endTime) + "\"");
        }
        info.add("severity=" + this.severity);
        info.add("max_severity=" + this.maxSeverity);
        info.add("in_pps=" + this.currInPps);
        info.add("in_kbps=" + this.currInKbps);
        info.add("drop_pps=" + this.currDropPps);
        info.add("drop_kbps=" + this.currDropKbps);
        info.add("max_in_pps=" + this.maxInPps);
        info.add("max_in_kbps=" + this.maxInKbps);
        info.add("curr_conn=" + this.currConn);
        info.add("new_conn=" + this.newConn);
        StringBuffer attackType = new StringBuffer();
        for (AbnormalAlarmEntity alarm : this.abnolmalList) {
            if (!this.isIsAlarm()) {
                attackType.append(alarm.getAlertTypeValue() + ",");
                continue;
            }
            if (!alarm.isAlarm()) continue;
            attackType.append(alarm.getAlertTypeValue() + ",");
        }
        if (!CommonUtil.isNull(attackType.toString())) {
            attackType = new StringBuffer(attackType.substring(0, attackType.length() - 1));
        }
        info.add("attack_type=\"" + attackType + "\"");
        info.add("max_drop_kbps=\"" + this.maxDropKbps + "\"");
        info.add("max_drop_pps=\"" + this.maxDropPps + "\"");
        return info;
    }

    @Override
    public long getTime() {
        return this.beginTime;
    }

    public int getMaxSeverity() {
        return this.maxSeverity;
    }

    public void setCurrDropPps(long currDropPps) {
        this.currDropPps = currDropPps;
    }

    public long getCurrDropPps() {
        return this.currDropPps;
    }

    public void setCurrDropKbps(long currDropKbps) {
        this.currDropKbps = currDropKbps;
    }

    public long getCurrDropKbps() {
        return this.currDropKbps;
    }

    public long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(long locationId) {
        this.locationId = locationId;
    }

    public long getMaxDropPps() {
        return this.maxDropPps;
    }

    public void setMaxDropPps(long maxDropPps) {
        this.maxDropPps = maxDropPps;
    }

    public long getMaxDropKbps() {
        return this.maxDropKbps;
    }

    public void setMaxDropKbps(long maxDropKbps) {
        this.maxDropKbps = maxDropKbps;
    }

    public String toString() {
        return "IpAlarmEntity [zoneIp=" + this.zoneIp + ", direction=" + this.direction + ", deviceIp=" + this.deviceIp + ", deviceType=" + this.deviceType + ", isAlarm=" + this.isAlarm + ", beginTime=" + this.beginTime + ", endTime=" + this.endTime + ", zoneId=" + this.zoneId + ", locationId=" + this.locationId + ", severity=" + this.severity + ", maxSeverity=" + this.maxSeverity + ", diversionAction=" + this.diversionAction + ", diverted=" + this.diverted + ", currInPps=" + this.currInPps + ", currInKbps=" + this.currInKbps + ", currDropPps=" + this.currDropPps + ", currDropKbps=" + this.currDropKbps + ", maxInPps=" + this.maxInPps + ", maxInKbps=" + this.maxInKbps + ", maxDropPps=" + this.maxDropPps + ", maxDropKbps=" + this.maxDropKbps + ", currConn=" + this.currConn + ", newConn=" + this.newConn + ", ports=" + this.ports + ", abnolmalList=" + this.abnolmalList + "]";
    }

    public String getPorts() {
        return this.ports;
    }

    public void setPorts(String ports) {
        this.ports = ports;
    }
}

