/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class AppFlowEvent
extends Event {
    private static final int CUSTOM = 0;
    private int appType;
    private long dropKbps;
    private long dropPps;
    private long inKbps;
    private long inPps;
    private boolean isAttack;
    private int port;
    private int protocol;
    private int reserve;
    private AppFlowType type = new AppFlowType();

    public AppFlowEvent(EventIdentifier identifer) {
        super(identifer);
    }

    @Override
    public void average(int number) {
        this.inKbps = this.devideUp(this.inKbps, number);
        this.inPps = this.devideUp(this.inPps, number);
        this.dropKbps = this.devideUp(this.dropKbps, number);
        this.dropPps = this.devideUp(this.dropPps, number);
    }

    @Override
    public AppFlowEvent getCopyEvent() {
        AppFlowEvent copy = new AppFlowEvent(this.getIdentifierCopy());
        copy.setSubType(this.getSubType());
        copy.setPort(this.getPort());
        copy.setProtocal(this.getProtocal());
        return copy;
    }

    public long getDropKbps() {
        return this.dropKbps;
    }

    public long getDropPps() {
        return this.dropPps;
    }

    public long getInKbps() {
        return this.inKbps;
    }

    public long getInPps() {
        return this.inPps;
    }

    public int getPort() {
        return this.port;
    }

    public int getProtocal() {
        return this.protocol;
    }

    public int getReserve() {
        return this.reserve;
    }

    public int getSubType() {
        return this.appType;
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("log_type=ip_app");
        info.addAll(super.getSysLogInfo());
        info.add("app_type=" + this.getSubType());
        info.add("protocol=" + this.getProtocal());
        info.add("port=" + this.getPort());
        info.add("in_pps=" + this.getInPps());
        info.add("in_kbps=" + this.getInKbps());
        info.add("drop_pps=" + this.getDropPps());
        info.add("drop_kbps=" + this.getDropKbps());
        return info;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public boolean isIsAttack() {
        return this.isAttack;
    }

    public boolean isCustomFlowEvent() {
        return this.appType == 0;
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            AppFlowEvent target = (AppFlowEvent)event;
            if (target.isIsAttack()) {
                this.setAttack(true);
            }
            this.inKbps += target.getInKbps();
            this.inPps += target.getInPps();
            this.dropKbps += target.getDropKbps();
            this.dropPps += target.getDropPps();
        }
    }

    public void setAttack(boolean isAttacks) {
        this.isAttack = isAttacks;
    }

    public void setDropKbps(long dropKbps) {
        this.dropKbps = dropKbps;
    }

    public void setDropPps(long dropPps) {
        this.dropPps = dropPps;
    }

    public void setInKbps(long inKbps) {
        this.inKbps = inKbps;
    }

    public void setInPps(long inPps) {
        this.inPps = inPps;
    }

    public void setPort(int port) {
        this.port = port;
        this.type.setPortInner(port);
    }

    public void setProtocal(int protocal) {
        this.protocol = protocal;
        this.type.setProtocolInner(protocal);
    }

    public void setReserve(int reserve) {
        this.reserve = reserve;
    }

    public void setSubType(int subType) {
        this.appType = subType;
        this.type.setSubTypeInner(subType);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("isAttack", this.isAttack).append("isCustom", this.isCustomFlowEvent()).append("drop_pps", this.dropPps).append("drop_kbps", this.dropKbps).append("in_pps", this.inPps).append("in_Kbps", this.inKbps).append("ucExt", this.appType).append("protocol", this.protocol).append("port", this.port).toString();
    }

    @Override
    public void max(Event e) {
        if (null != e && e instanceof AppFlowEvent) {
            AppFlowEvent event = (AppFlowEvent)e;
            if (event.isIsAttack()) {
                this.setAttack(true);
            }
            this.setInPps(this.inPps > event.getInPps() ? this.inPps : event.getInPps());
            this.setInKbps(this.inKbps > event.getInKbps() ? this.inKbps : event.getInKbps());
            this.setDropPps(this.dropPps > event.getDropPps() ? this.dropPps : event.getDropPps());
            this.setDropKbps(this.dropKbps > event.getDropPps() ? this.dropKbps : event.getDropKbps());
        }
    }

    private static class AppFlowType
    implements Type {
        int appTypeInner;
        int portInner;
        int protocolInner;
        int result;

        private AppFlowType() {
        }

        public boolean equals(Object o) {
            if (o instanceof AppFlowType) {
                AppFlowType type = (AppFlowType)o;
                return this.portInner == type.getPortInner() && this.protocolInner == type.getProtocolInner() && this.appTypeInner == type.getUcExtflagInner();
            }
            return false;
        }

        public int getPortInner() {
            return this.portInner;
        }

        public int getProtocolInner() {
            return this.protocolInner;
        }

        public int getUcExtflagInner() {
            return this.appTypeInner;
        }

        public int hashCode() {
            if (this.result == 0) {
                this.result = 17;
                this.result += 19 * this.protocolInner;
                this.result += 19 * this.appTypeInner;
                this.result += 19 * this.portInner;
            }
            return this.result;
        }

        public void setPortInner(int portInner) {
            this.portInner = portInner;
        }

        public void setProtocolInner(int protocolInner) {
            this.protocolInner = protocolInner;
        }

        public void setSubTypeInner(int ucExtflagInner) {
            this.appTypeInner = ucExtflagInner;
        }

        public String toString() {
            return "subType : " + this.appTypeInner + LogManager.NEXT_LINE + "protocol  :" + this.protocolInner + LogManager.NEXT_LINE + "port :" + this.portInner;
        }
    }
}

