/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.Type;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class AttackType
implements Type {
    private String description;
    private boolean isDdosDrop;
    private int attackTypeValue;
    private final int port;
    private final int protocol;
    private int dropRate;

    public AttackType(int typeValue, int protocol, int port) {
        this.attackTypeValue = typeValue;
        this.protocol = protocol;
        this.port = port;
    }

    public boolean equals(Object o) {
        if (o instanceof AttackType) {
            AttackType type = (AttackType)o;
            return this.port == type.getPort() && this.protocol == type.getProtocol() && this.attackTypeValue == type.getTypeValue();
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDropRate() {
        return this.dropRate;
    }

    public int getPort() {
        return this.port;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int getTypeValue() {
        return this.attackTypeValue;
    }

    public int hashCode() {
        int result = 17;
        result += 19 * this.attackTypeValue;
        result += 19 * this.port;
        return result += 19 * this.protocol;
    }

    public boolean isCustomServiceAttack() {
        return this.attackTypeValue < 10 && this.attackTypeValue >= 0;
    }

    public boolean isIsDdosDrop() {
        return this.isDdosDrop;
    }

    public void setDdosDrop(boolean ddosDrop) {
        this.isDdosDrop = ddosDrop;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDropRate(int dropRate) {
        this.dropRate = dropRate;
    }

    public void setTypeValue(int attackType) {
        this.attackTypeValue = attackType;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("type", this.attackTypeValue).append("protocol", this.protocol).append("port", this.port).append("description", (Object)this.description).toString();
    }
}

