/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public final class AttackTypeFactory {
    public static final int HOST_TRAFFIC_OVER_FLOW = 73;
    private static final int OTHER_ABNORMAL = 39;
    private static final int ICMP_ABNORMAL = 38;
    private static final int UDP_ABNORMAL = 37;
    private static final int TCP_ABNORMAL = 35;
    private static final int UDP_FRAGEMENT_ABNORMAL = 36;
    private static final int TCP_FRAGEMENT_ABNORMAL = 34;
    private static int exactDropRate = 20;
    private static int normalDropRate = 5;
    private static AttackTypeFactory factory = new AttackTypeFactory();
    private static final Logger LOGGER = LogManager.getInstance().getAttackLog();
    private Set<AttackType> types = new HashSet<AttackType>();

    private AttackTypeFactory() {
        this.initDropRate();
    }

    public static AttackTypeFactory getInstance() {
        return factory;
    }

    private void initDropRate() {
        try {
            AttackTypeFactory.setExactDropRate(Integer.parseInt(EventUtil.getEventConfigProperty("ExactDropRate")));
            AttackTypeFactory.setNormalDropRate(Integer.parseInt(EventUtil.getEventConfigProperty("NormalDropRate")));
        }
        catch (Exception e) {
            LOGGER.error((Object)"read config error content error", (Throwable)e);
        }
    }

    public synchronized AttackType getAttackType(int subType, int protocol, int port) {
        AttackType result = null;
        for (AttackType type : this.types) {
            if (type.getTypeValue() != subType || type.getPort() != port || type.getProtocol() != protocol) continue;
            result = type;
        }
        if (result == null) {
            result = new AttackType(subType, protocol, port);
            if (subType == 35 || subType == 37 || subType == 38 || subType == 39 || subType == 34 || subType == 36) {
                result.setDdosDrop(false);
                result.setDropRate(normalDropRate);
            } else {
                result.setDdosDrop(true);
                result.setDropRate(exactDropRate);
            }
            if (!result.isCustomServiceAttack()) {
                this.types.add(result);
            }
        }
        switch (subType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                String description = "CustomService_";
                description = description + "_" + this.getProtocol(protocol);
                description = description + "_PORT_" + port;
                result.setDescription(description);
                break;
            }
            case 10: {
                result.setDescription("SYNFlood");
                break;
            }
            case 11: {
                result.setDescription("ACKFlood");
                break;
            }
            case 12: {
                result.setDescription("SYN-ACKFlood");
                break;
            }
            case 13: {
                result.setDescription("FIN/RSTFlood");
                break;
            }
            case 14: {
                result.setDescription("ConcurrentConnectionsFlood");
                break;
            }
            case 15: {
                result.setDescription("NewConnectionsFlood");
                break;
            }
            case 16: {
                result.setDescription("TCPFragmentFlood");
                break;
            }
            case 17: {
                result.setDescription("TCPFragmentBandwidthOverflow");
                break;
            }
            case 18: {
                result.setDescription("TCPBandwidthOverflow");
                break;
            }
            case 19: {
                result.setDescription("UDPFlood");
                break;
            }
            case 20: {
                result.setDescription("UDPFragmentFlood");
                break;
            }
            case 21: {
                result.setDescription("UDPFragmentBandwidthOverflow");
                break;
            }
            case 22: {
                result.setDescription("UDPBandwidthOverflow");
                break;
            }
            case 23: {
                result.setDescription("ICMPFlood");
                break;
            }
            case 24: {
                result.setDescription("OtherBandwidthOverflow");
                break;
            }
            case 25: {
                result.setDescription("SingleIPBandwidthOverflow");
                break;
            }
            case 26: {
                result.setDescription("HTTPSFlood");
                break;
            }
            case 27: {
                result.setDescription("HTTPFlood");
                break;
            }
            case 29: {
                result.setDescription("DNSQueryFlood");
                break;
            }
            case 30: {
                result.setDescription("DNSReplyFlood");
                break;
            }
            case 31: {
                result.setDescription("SIPFlood");
                break;
            }
            case 32: {
                result.setDescription("Blacklist");
                break;
            }
            case 33: {
                result.setDescription("URIMonitor");
                break;
            }
            case 34: {
                result.setDescription("GlobalTCPFragmentAbnormal");
                break;
            }
            case 35: {
                result.setDescription("GlobalTCPAbnormal");
                break;
            }
            case 36: {
                result.setDescription("GlobalUDPFragmentAbnormal");
                break;
            }
            case 37: {
                result.setDescription("GlobalUDPAbnormal");
                break;
            }
            case 38: {
                result.setDescription("GlobalICMPAbnormal");
                break;
            }
            case 39: {
                result.setDescription("GlobalOtherAbnormal");
                break;
            }
            case 40: {
                result.setDescription("TCPConnectionFlood");
                break;
            }
            case 41: {
                result.setDescription("DomainHijacking");
                break;
            }
            case 42: {
                result.setDescription("DNSCachePoisoning");
                break;
            }
            case 43: {
                result.setDescription("DNSReflection");
                break;
            }
            case 44: {
                result.setDescription("DNSSizeAbnormal");
                break;
            }
            case 45: {
                result.setDescription("SourceDNSRequestFlowAbnormal");
                break;
            }
            case 46: {
                result.setDescription("SourceDNSReplyFlowAbnormal");
                break;
            }
            case 47: {
                result.setDescription("DNSRequestDomainFlowAbnormal");
                break;
            }
            case 48: {
                result.setDescription("DNSReplyDomainFlowAbnormal");
                break;
            }
            case 49: {
                result.setDescription("DNSIPTTLCheckFail");
                break;
            }
            case 50: {
                result.setDescription("DNSFormatError");
                break;
            }
            case 51: {
                result.setDescription("DNSCacheMatch");
                break;
            }
            case 52: {
                result.setDescription("PortScanningAttack");
                break;
            }
            case 53: {
                result.setDescription("TCPMalformed");
                break;
            }
            case 54: {
                result.setDescription("BGPFloodAttack");
                break;
            }
            case 55: {
                result.setDescription("TCP-authenticatedUDPAttack");
                break;
            }
            case 56: {
                result.setDescription("DNSNoSuchName");
                break;
            }
            case 57: {
                result.setDescription("OtherFlood");
                break;
            }
            case 58: {
                result.setDescription("ZoneBandwidthOverflow");
                break;
            }
            case 59: {
                result.setDescription("HTTPSlowAttack");
                break;
            }
            case 60: {
                result.setDescription("Botnets/Trojanhorses/WormsAttack");
                break;
            }
            case 61: {
                result.setDescription("MaliciousDomainsAttack");
                break;
            }
            case 62: {
                result.setDescription("FilterAttack");
                break;
            }
            case 63: {
                result.setDescription("WebAttack");
                break;
            }
            case 64: {
                result.setDescription("SIPSourceRateAbnormity");
                break;
            }
            case 65: {
                result.setDescription("Anti-Malware");
                break;
            }
            case 66: {
                result.setDescription("IPReputation");
                break;
            }
            case 67: {
                result.setDescription("LocationAttack");
                break;
            }
            case 68: {
                result.setDescription("DestinationIPnewsessionratelimiting");
                break;
            }
            case 69: {
                result.setDescription("TCPProtocolBlock");
                break;
            }
            case 70: {
                result.setDescription("UDPProtocolBlock");
                break;
            }
            case 71: {
                result.setDescription("ICMPProtocolBlock");
                break;
            }
            case 72: {
                result.setDescription("OtherProtocolBlock");
                break;
            }
            case 73: {
                result.setDescription("HostTrafficOverFlow");
                break;
            }
            case 74: {
                result.setDescription("UDPMalformed");
                break;
            }
            case 75: {
                result.setDescription("TCPDportTrafficLimit");
                break;
            }
            case 76: {
                result.setDescription("TCPDportRelationDefense");
                break;
            }
            case 77: {
                result.setDescription("FilterNGAttack");
                break;
            }
            case 99: {
                result.setDescription("DarkIP");
                break;
            }
            default: {
                result.setDescription("Other");
            }
        }
        return result;
    }

    public boolean isConnectionFlood(AttackType type) {
        return type.getTypeValue() == 40 || type.getTypeValue() == 14 || type.getTypeValue() == 15;
    }

    private String getProtocol(int protocol) {
        switch (protocol) {
            case 1: {
                return "TCP";
            }
            case 2: {
                return "UDP";
            }
            case 3: {
                return "HTTP";
            }
        }
        return protocol + "";
    }

    public static int getExactDropRate() {
        return exactDropRate;
    }

    public static void setExactDropRate(int exactDropRate) {
        AttackTypeFactory.exactDropRate = exactDropRate;
    }

    public static int getNormalDropRate() {
        return normalDropRate;
    }

    public static void setNormalDropRate(int normalDropRate) {
        AttackTypeFactory.normalDropRate = normalDropRate;
    }
}

