/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ForwardFlowEvent;
import com.hs.atic.collector.entity.event.HttpBizFlowEvent;
import com.hs.atic.collector.entity.event.HttpsBizFlowEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.OtherBizFlowEvent;
import com.hs.atic.collector.entity.event.SipBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpDnsBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpDnsBizFlowEvent;
import com.hs.atic.collector.util.LogManager;
import java.util.List;
import org.apache.log4j.Logger;

public class BaseLineEvent
extends Event {
    private boolean isChanged;
    private long baseLinePkid;
    private boolean saved;
    private boolean alert = false;
    private long synPps;
    private long synAckPps;
    private long ackPps;
    private long tcpFragPps;
    private long finstPps;
    private long tcpIncreaseCon;
    private long tcpCurCon;
    private long udpKbps;
    private long udpFragKbps;
    private long httpPps;
    private long httpsPps;
    private long dnsRequestPps;
    private long icmpPps;
    private long otherKbps;
    private long httpGetPps;
    private long dnsReplyPps;
    private long sipInvitePps;
    private long tcpSrcIncreaseCon;
    private long tcpSrcCurCon;
    private long tcpRatio;
    private long tcpL500Ratio;
    private long synPktNum;

    public BaseLineEvent(EventIdentifier identifer) {
        super(identifer);
    }

    public long getTcpFragPps() {
        return this.tcpFragPps;
    }

    public void setTcpFragPps(long tcpFragPps) {
        this.tcpFragPps = tcpFragPps;
    }

    public long getOtherKbps() {
        return this.otherKbps;
    }

    public void setOtherKbps(long otherKbps) {
        this.otherKbps = otherKbps;
    }

    public long getIcmpPps() {
        return this.icmpPps;
    }

    public void setIcmpPps(long icmpPps) {
        this.icmpPps = icmpPps;
    }

    public long getDnsRequestPps() {
        return this.dnsRequestPps;
    }

    public void setDnsRequestPps(long dnsRequestPps) {
        this.dnsRequestPps = dnsRequestPps;
    }

    public long getDnsReplyPps() {
        return this.dnsReplyPps;
    }

    public void setDnsReplyPps(long dnsReplyPps) {
        this.dnsReplyPps = dnsReplyPps;
    }

    public boolean isIsChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChange) {
        this.isChanged = isChange;
    }

    public long getSynPps() {
        return this.synPps;
    }

    public void setSynPps(long synPps) {
        this.synPps = synPps;
    }

    public long getSynAckPps() {
        return this.synAckPps;
    }

    public void setSynAckPps(long synAckPps) {
        this.synAckPps = synAckPps;
    }

    public long getAckPps() {
        return this.ackPps;
    }

    public void setAckPps(long ackPps) {
        this.ackPps = ackPps;
    }

    public long getFinstPps() {
        return this.finstPps;
    }

    public void setFinstPps(long finstPps) {
        this.finstPps = finstPps;
    }

    public long getBaseLinePkid() {
        return this.baseLinePkid;
    }

    public void setBaseLinePkid(long pkid) {
        this.baseLinePkid = pkid;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public long getTcpIncreaseCon() {
        return this.tcpIncreaseCon;
    }

    public void setTcpIncreaseCon(long tcpIncreaseCon) {
        this.tcpIncreaseCon = tcpIncreaseCon;
    }

    public long getTcpCurCon() {
        return this.tcpCurCon;
    }

    public void setTcpCurCon(long tcpCurCon) {
        this.tcpCurCon = tcpCurCon;
    }

    public long getUdpKbps() {
        return this.udpKbps;
    }

    public void setUdpKbps(long udpKbps) {
        this.udpKbps = udpKbps;
    }

    public long getUdpFragKbps() {
        return this.udpFragKbps;
    }

    public void setUdpFragKbps(long udpFragKbps) {
        this.udpFragKbps = udpFragKbps;
    }

    public long getHttpPps() {
        return this.httpPps;
    }

    public void setHttpPps(long httpPps) {
        this.httpPps = httpPps;
    }

    public long getHttpGetPps() {
        return this.httpGetPps;
    }

    public void setHttpGetPps(long httpGetPps) {
        this.httpGetPps = httpGetPps;
    }

    public long getHttpsPps() {
        return this.httpsPps;
    }

    public void setHttpsPps(long httpsPps) {
        this.httpsPps = httpsPps;
    }

    public long getSipInvitePps() {
        return this.sipInvitePps;
    }

    public void setSipInvitePps(long sipInvitePps) {
        this.sipInvitePps = sipInvitePps;
    }

    public long getTcpSrcIncreaseCon() {
        return this.tcpSrcIncreaseCon;
    }

    public void setTcpSrcIncreaseCon(long tcpSrcIncreaseCon) {
        this.tcpSrcIncreaseCon = tcpSrcIncreaseCon;
    }

    public long getTcpSrcCurCon() {
        return this.tcpSrcCurCon;
    }

    public void setTcpSrcCurCon(long tcpSrcCurCon) {
        this.tcpSrcCurCon = tcpSrcCurCon;
    }

    public long getTcpRatio() {
        return this.tcpRatio;
    }

    public void setTcpRatio(long tcpRatio) {
        this.tcpRatio = tcpRatio;
    }

    public long getTcpL500Ratio() {
        return this.tcpL500Ratio;
    }

    public void setTcpL500Ratio(long tcpL500Ratio) {
        this.tcpL500Ratio = tcpL500Ratio;
    }

    public long getSynPktNum() {
        return this.synPktNum;
    }

    public void setSynPktNum(long synPktNum) {
        this.synPktNum = synPktNum;
    }

    public boolean isHasPkId() {
        return this.baseLinePkid > 0L;
    }

    public boolean isAlert() {
        return this.alert;
    }

    public void setAlert(boolean isAlert) {
        if (this.alert != isAlert) {
            this.alert = isAlert;
            this.isChanged = true;
        }
    }

    @Override
    public void average(int number) {
    }

    public void maxWithOtherEvent(List<? extends Event> events) {
        for (Event event : events) {
            if (event instanceof InFlowEvent) {
                this.maxInflowEvent((InFlowEvent)event);
            }
            if (event instanceof ForwardFlowEvent) {
                this.maxForwardflowEvent((ForwardFlowEvent)event);
            }
            if (event instanceof TcpBizFlowEvent) {
                this.maxTcpBizEvent((TcpBizFlowEvent)event);
            }
            if (event instanceof TcpDnsBizFlowEvent) {
                this.maxTcpDnsBizEvent((TcpDnsBizFlowEvent)event);
            }
            if (event instanceof HttpBizFlowEvent) {
                this.maxHttpBizEvent((HttpBizFlowEvent)event);
            }
            if (event instanceof HttpsBizFlowEvent) {
                this.maxHttpsBizEvent((HttpsBizFlowEvent)event);
            }
            if (event instanceof UdpBizFlowEvent) {
                this.maxUdpBizEvent((UdpBizFlowEvent)event);
            }
            if (event instanceof UdpDnsBizFlowEvent) {
                this.maxUdpDnsBizEvent((UdpDnsBizFlowEvent)event);
            }
            if (event instanceof SipBizFlowEvent) {
                this.maxSipBizEvent((SipBizFlowEvent)event);
            }
            if (!(event instanceof OtherBizFlowEvent)) continue;
            this.maxOtherBizEvent((OtherBizFlowEvent)event);
        }
    }

    @Override
    public void merge(List<? extends Event> events) {
    }

    @Override
    public void max(Event event) {
        if (event instanceof BaseLineEvent) {
            BaseLineEvent e = (BaseLineEvent)event;
            Boolean synp = this.synPps < e.getSynPps() || this.synAckPps < e.getSynAckPps() || this.ackPps < e.getAckPps() || this.tcpFragPps < e.getTcpFragPps() || this.finstPps < e.getFinstPps();
            Boolean tcpp = this.tcpIncreaseCon < e.getTcpIncreaseCon() || this.tcpCurCon < e.getTcpCurCon() || this.icmpPps < e.getIcmpPps() || this.otherKbps < e.getOtherKbps() || this.udpKbps < e.getUdpKbps();
            Boolean udpp = this.udpFragKbps < e.getUdpFragKbps() || this.httpPps < e.getHttpPps() || this.httpGetPps < e.getHttpGetPps() || this.httpsPps < e.getHttpsPps() || this.dnsRequestPps < e.getDnsRequestPps();
            Boolean tailp = this.dnsReplyPps < e.getDnsReplyPps() || this.sipInvitePps < e.getSipInvitePps() || this.tcpSrcIncreaseCon < e.getTcpSrcIncreaseCon() || this.tcpSrcCurCon < e.getTcpSrcCurCon();
            Boolean tatiop = this.tcpRatio < e.getTcpRatio() || this.tcpL500Ratio < e.getTcpL500Ratio() || this.synPktNum < e.getSynPktNum();
            if (synp.booleanValue() || tcpp.booleanValue() || udpp.booleanValue() || tailp.booleanValue() || tatiop.booleanValue()) {
                Logger logger = LogManager.getInstance().getBaseLineLog();
                logger.debug((Object)("Before max, the event=" + this.toString()));
                this.isChanged = true;
                this.synPps = this.synPps > e.getSynPps() ? this.synPps : e.getSynPps();
                this.synAckPps = this.synAckPps > e.getSynAckPps() ? this.synAckPps : e.getSynAckPps();
                this.ackPps = this.ackPps > e.getAckPps() ? this.ackPps : e.getAckPps();
                this.tcpFragPps = this.tcpFragPps > e.getTcpFragPps() ? this.tcpFragPps : e.getTcpFragPps();
                this.finstPps = this.finstPps > e.getFinstPps() ? this.finstPps : e.getFinstPps();
                this.tcpIncreaseCon = this.tcpIncreaseCon > e.getTcpIncreaseCon() ? this.tcpIncreaseCon : e.getTcpIncreaseCon();
                this.tcpCurCon = this.tcpCurCon > e.getTcpCurCon() ? this.tcpCurCon : e.getTcpCurCon();
                this.icmpPps = this.icmpPps > e.getIcmpPps() ? this.icmpPps : e.getIcmpPps();
                this.otherKbps = this.otherKbps > e.getOtherKbps() ? this.otherKbps : e.getOtherKbps();
                this.udpKbps = this.udpKbps > e.getUdpKbps() ? this.udpKbps : e.getUdpKbps();
                this.udpFragKbps = this.udpFragKbps > e.getUdpFragKbps() ? this.udpFragKbps : e.getUdpFragKbps();
                this.httpPps = this.httpPps > e.getHttpPps() ? this.httpPps : e.getHttpPps();
                this.httpsPps = this.httpsPps > e.getHttpsPps() ? this.httpsPps : e.getHttpsPps();
                this.httpGetPps = this.httpGetPps > e.getHttpGetPps() ? this.httpGetPps : e.getHttpGetPps();
                this.dnsRequestPps = this.dnsRequestPps > e.getDnsRequestPps() ? this.dnsRequestPps : e.getDnsRequestPps();
                this.dnsReplyPps = this.dnsReplyPps > e.getDnsReplyPps() ? this.dnsReplyPps : e.getDnsReplyPps();
                this.sipInvitePps = this.sipInvitePps > e.getSipInvitePps() ? this.sipInvitePps : e.getSipInvitePps();
                this.tcpSrcIncreaseCon = this.tcpSrcIncreaseCon > e.getTcpSrcIncreaseCon() ? this.tcpSrcIncreaseCon : e.getTcpSrcIncreaseCon();
                this.tcpSrcCurCon = this.tcpSrcCurCon > e.getTcpSrcCurCon() ? this.tcpSrcCurCon : e.getTcpSrcCurCon();
                this.tcpRatio = this.tcpRatio > e.getTcpRatio() ? this.tcpRatio : e.getTcpRatio();
                this.tcpL500Ratio = this.tcpL500Ratio > e.getTcpL500Ratio() ? this.tcpL500Ratio : e.getTcpL500Ratio();
                this.synPktNum = this.synPktNum > e.getSynPktNum() ? this.synPktNum : e.getSynPktNum();
                logger.debug((Object)("After max, the event=" + this.toString()));
            }
        }
    }

    protected void maxInflowEvent(InFlowEvent e) {
        this.synPps = this.synPps > e.getSynPps() ? this.synPps : e.getSynPps();
        this.synAckPps = this.synAckPps > e.getSynAckPps() ? this.synAckPps : e.getSynAckPps();
        this.ackPps = this.ackPps > e.getAckPps() ? this.ackPps : e.getAckPps();
        this.tcpFragPps = this.tcpFragPps > e.getTcpFragPps() ? this.tcpFragPps : e.getTcpFragPps();
        this.finstPps = this.finstPps > e.getFinRstPps() ? this.finstPps : e.getFinRstPps();
        this.tcpIncreaseCon = this.tcpIncreaseCon > e.getTcpIncreaseCon() ? this.tcpIncreaseCon : e.getTcpIncreaseCon();
        this.tcpCurCon = this.tcpCurCon > e.getTcpConcurCon() ? this.tcpCurCon : e.getTcpConcurCon();
        this.udpKbps = this.udpKbps > e.getUdpKbps() ? this.udpKbps : e.getUdpKbps();
        this.udpFragKbps = this.udpFragKbps > e.getUdpFragKbps() ? this.udpFragKbps : e.getUdpFragKbps();
        this.icmpPps = this.icmpPps > e.getIcmpPps() ? this.icmpPps : e.getIcmpPps();
        this.otherKbps = this.otherKbps > e.getOtherKbps() ? this.otherKbps : e.getOtherKbps();
        this.httpPps = this.httpPps > e.getHttpPps() ? this.httpPps : e.getHttpPps();
        this.httpsPps = this.httpsPps > e.getHttpsPps() ? this.httpsPps : e.getHttpsPps();
        this.dnsRequestPps = this.dnsRequestPps > e.getDnsRequestPps() ? this.dnsRequestPps : e.getDnsRequestPps();
        this.dnsReplyPps = this.dnsReplyPps > e.getDnsReplyPps() ? this.dnsReplyPps : e.getDnsReplyPps();
        this.sipInvitePps = this.sipInvitePps > e.getSipInvitePps() ? this.sipInvitePps : e.getSipInvitePps();
        this.httpGetPps = this.httpGetPps > e.getHttpGetPps() ? this.httpGetPps : e.getHttpGetPps();
        this.tcpSrcIncreaseCon = this.tcpSrcIncreaseCon > e.getTcpSrcIncreaseCon() ? this.tcpSrcIncreaseCon : e.getTcpSrcIncreaseCon();
        this.tcpSrcCurCon = this.tcpSrcCurCon > e.getTcpSrcConcurCon() ? this.tcpSrcCurCon : e.getTcpSrcConcurCon();
        this.tcpRatio = this.tcpRatio > e.getTcpRatio() ? this.tcpRatio : e.getTcpRatio();
        this.tcpL500Ratio = this.tcpL500Ratio > e.getTcpL500Ratio() ? this.tcpL500Ratio : e.getTcpL500Ratio();
        this.synPktNum = this.synPktNum > e.getSynPktNum() ? this.synPktNum : e.getSynPktNum();
    }

    protected void maxForwardflowEvent(ForwardFlowEvent e) {
        this.synPps = this.synPps > e.getSynPps() ? this.synPps : e.getSynPps();
        this.synAckPps = this.synAckPps > e.getSynAckPps() ? this.synAckPps : e.getSynAckPps();
        this.ackPps = this.ackPps > e.getAckPps() ? this.ackPps : e.getAckPps();
        this.tcpFragPps = this.tcpFragPps > e.getTcpFragPps() ? this.tcpFragPps : e.getTcpFragPps();
        this.finstPps = this.finstPps > e.getFinRstPps() ? this.finstPps : e.getFinRstPps();
        this.tcpIncreaseCon = this.tcpIncreaseCon > e.getTcpIncreaseCon() ? this.tcpIncreaseCon : e.getTcpIncreaseCon();
        this.tcpCurCon = this.tcpCurCon > e.getTcpConcurCon() ? this.tcpCurCon : e.getTcpConcurCon();
        this.udpKbps = this.udpKbps > e.getUdpKbps() ? this.udpKbps : e.getUdpKbps();
        this.udpFragKbps = this.udpFragKbps > e.getUdpFragKbps() ? this.udpFragKbps : e.getUdpFragKbps();
        this.icmpPps = this.icmpPps > e.getIcmpPps() ? this.icmpPps : e.getIcmpPps();
        this.otherKbps = this.otherKbps > e.getOtherKbps() ? this.otherKbps : e.getOtherKbps();
        this.httpPps = this.httpPps > e.getHttpPps() ? this.httpPps : e.getHttpPps();
        this.httpsPps = this.httpsPps > e.getHttpsPps() ? this.httpsPps : e.getHttpsPps();
        this.dnsRequestPps = this.dnsRequestPps > e.getDnsRequestPps() ? this.dnsRequestPps : e.getDnsRequestPps();
        this.dnsReplyPps = this.dnsReplyPps > e.getDnsReplyPps() ? this.dnsReplyPps : e.getDnsReplyPps();
        this.sipInvitePps = this.sipInvitePps > e.getSipInvitePps() ? this.sipInvitePps : e.getSipInvitePps();
        this.httpGetPps = this.httpGetPps > e.getHttpGetPps() ? this.httpGetPps : e.getHttpGetPps();
        this.tcpSrcIncreaseCon = this.tcpSrcIncreaseCon > e.getTcpSrcIncreaseCon() ? this.tcpSrcIncreaseCon : e.getTcpSrcIncreaseCon();
        this.tcpSrcCurCon = this.tcpSrcCurCon > e.getTcpSrcConcurCon() ? this.tcpSrcCurCon : e.getTcpSrcConcurCon();
        this.tcpRatio = this.tcpRatio > e.getTcpRatio() ? this.tcpRatio : e.getTcpRatio();
        this.tcpL500Ratio = this.tcpL500Ratio > e.getTcpL500Ratio() ? this.tcpL500Ratio : e.getTcpL500Ratio();
        this.synPktNum = this.synPktNum > e.getSynPktNum() ? this.synPktNum : e.getSynPktNum();
    }

    protected void maxTcpBizEvent(TcpBizFlowEvent e) {
        this.synPps = this.synPps > e.getSynPps() ? this.synPps : e.getSynPps();
        this.synAckPps = this.synAckPps > e.getSynAckPps() ? this.synAckPps : e.getSynAckPps();
        this.ackPps = this.ackPps > e.getAckPps() ? this.ackPps : e.getAckPps();
        this.finstPps = this.finstPps > e.getFinRstPps() ? this.finstPps : e.getFinRstPps();
        this.tcpIncreaseCon = this.tcpIncreaseCon > e.getIncreaseConPps() ? this.tcpIncreaseCon : e.getIncreaseConPps();
        this.tcpCurCon = this.tcpCurCon > e.getCurConPps() ? this.tcpCurCon : e.getCurConPps();
    }

    protected void maxHttpBizEvent(HttpBizFlowEvent e) {
        this.httpPps = this.httpPps > e.getTotalPps() ? this.httpPps : e.getTotalPps();
        this.httpGetPps = this.httpGetPps > e.getGetPps() ? this.httpGetPps : e.getGetPps();
    }

    protected void maxHttpsBizEvent(HttpsBizFlowEvent e) {
        this.httpsPps = this.httpsPps > e.getTotalPps() ? this.httpsPps : e.getTotalPps();
    }

    protected void maxTcpDnsBizEvent(TcpDnsBizFlowEvent e) {
    }

    protected void maxUdpDnsBizEvent(UdpDnsBizFlowEvent e) {
        this.dnsRequestPps = this.dnsRequestPps > e.getRequestPps() ? this.dnsRequestPps : e.getRequestPps();
        this.dnsReplyPps = this.dnsReplyPps > e.getReplyPps() ? this.dnsReplyPps : e.getReplyPps();
    }

    protected void maxUdpBizEvent(UdpBizFlowEvent e) {
        this.udpKbps = this.udpKbps > e.getTotalKbps() ? this.udpKbps : e.getTotalKbps();
    }

    protected void maxSipBizEvent(SipBizFlowEvent e) {
        this.sipInvitePps = this.sipInvitePps > e.getTotalPps() ? this.sipInvitePps : e.getTotalPps();
    }

    protected void maxOtherBizEvent(OtherBizFlowEvent e) {
        this.otherKbps = this.otherKbps > e.getTotalKbps() ? this.otherKbps : e.getTotalKbps();
    }

    @Override
    public String toString() {
        return super.toString() + "BaseLineEvent [ackPps=" + this.ackPps + ", dnsReplyPps=" + this.dnsReplyPps + ", dnsRequestPps=" + this.dnsRequestPps + ", finstPps=" + this.finstPps + ", httpGetPps=" + this.httpGetPps + ", httpPps=" + this.httpPps + ", httpsPps=" + this.httpsPps + ", icmpPps=" + this.icmpPps + ", isChanged=" + this.isChanged + ", otherKbps=" + this.otherKbps + ", pkid=" + this.baseLinePkid + ", saved=" + this.saved + ", alert" + this.alert + ", sipInvitePps=" + this.sipInvitePps + ", synAckPps=" + this.synAckPps + ", synPps=" + this.synPps + ", tcpCurCon=" + this.tcpCurCon + ", tcpFragPps=" + this.tcpFragPps + ", tcpIncreaseCon=" + this.tcpIncreaseCon + ", udpFragKbps=" + this.udpFragKbps + ", udpKbps=" + this.udpKbps + "]";
    }
}

