/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.AbnormalEvent;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.IpAttackEvent;
import com.hs.atic.collector.entity.event.SumAbnormalEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class BizAttackEvent
extends AbnormalEvent
implements SumAbnormalEvent<IpAttackEvent, BizAttackEvent> {
    private Set<String> alertZoneIps = new HashSet<String>();
    private Set<AttackType> attackedTypes = new HashSet<AttackType>();
    private Set<String> attackedZoneIps = new HashSet<String>();
    private Set<String> attackingZoneIps = new HashSet<String>();

    public BizAttackEvent(EventIdentifier identifer) {
        super(identifer);
        identifer.setZoneType();
    }

    public Set<String> getAlertZoneIps() {
        return this.alertZoneIps;
    }

    public Set<AttackType> getAttackedTypes() {
        HashSet<AttackType> copy = new HashSet<AttackType>();
        copy.addAll(this.attackedTypes);
        return copy;
    }

    public Set<String> getAttackedZoneIps() {
        return this.attackedZoneIps;
    }

    public Set<String> getAttackingZoneIps() {
        return this.attackingZoneIps;
    }

    public Set<String> getAttackZoneIps() {
        return this.attackedZoneIps;
    }

    @Override
    public BizAttackEvent getCopyEvent() {
        BizAttackEvent copy = new BizAttackEvent(this.getIdentifierCopy());
        copy.setAlertZoneIps(this.getAlertZoneIps());
        copy.setAttackingZoneIps(this.getAttackingZoneIps());
        copy.setAttackedZoneIps(this.getAttackZoneIps());
        this.copy(copy);
        return copy;
    }

    @Override
    public List<String> getSysLogInfo() {
        return new ArrayList<String>();
    }

    @Override
    public boolean isDeviceEvent() {
        return false;
    }

    @Override
    public boolean isBizEvent() {
        return true;
    }

    @Override
    public boolean isZoneIp() {
        return false;
    }

    @Override
    public void merge(List<? extends Event> events) {
    }

    public void setAlertZoneIps(Set<String> alertZoneIps) {
        this.alertZoneIps = alertZoneIps;
    }

    public void setAttackedTypes(Set<AttackType> attackedTypes) {
        this.attackedTypes = attackedTypes;
    }

    public void setAttackedZoneIps(Set<String> attackedZoneIps) {
        this.attackedZoneIps = attackedZoneIps;
    }

    public void setAttackingZoneIps(Set<String> attackingZoneIps) {
        this.attackingZoneIps = attackingZoneIps;
    }

    public void setAttackZoneIps(Set<String> attackZoneIps) {
        this.attackedZoneIps = attackZoneIps;
    }

    @Override
    public BizAttackEvent sumElement(List<IpAttackEvent> ipEvents) {
        for (IpAttackEvent each : ipEvents) {
            this.setDropPkgs(this.getDropPkgs() + each.getDropPkgs());
            this.setDropKbits(this.getDropKbits() + each.getDropKbits());
            this.setIpAttackPeakKbps(this.queryMaxValue(this.getIpAttackPeakKbps(), each.getIpAttackPeakKbps()));
            this.setIpAttackPeakPps(this.queryMaxValue(this.getIpAttackPeakPps(), each.getIpAttackPeakPps()));
            this.setIpInPeakKbps(this.queryMaxValue(this.getIpInPeakKbps(), each.getIpInPeakKbps()));
            this.setIpInPeakPps(this.queryMaxValue(this.getIpInPeakPps(), each.getIpInPeakPps()));
            this.setTcpCurConnNum(this.queryMaxValue(this.getTcpCurConnNum(), each.getTcpCurConnNum()));
            this.setTcpNewConnNum(this.queryMaxValue(this.getTcpNewConnNum(), each.getTcpNewConnNum()));
            this.setAttackPeakKbps(this.queryMaxValue(this.getAttackPeakKbps(), each.getAttackPeakKbps()));
            this.setAttackPeakPpsOrQps(this.queryMaxValue(this.getAttackPeakPpsOrQps(), each.getAttackPeakPpsOrQps()));
            this.updateTime(each);
            String zoneIp = each.getZoneIp();
            if (each.isNormal()) {
                this.attackingZoneIps.remove(zoneIp);
                this.alertZoneIps.remove(zoneIp);
                continue;
            }
            if (each.isAlert()) {
                this.alertZoneIps.add(zoneIp);
                this.attackingZoneIps.remove(zoneIp);
                continue;
            }
            this.attackedZoneIps.add(zoneIp);
            this.attackingZoneIps.add(zoneIp);
            this.alertZoneIps.remove(zoneIp);
            this.setAttackCount(this.getAttackCount() + each.getAttackCount());
            this.attackedTypes.addAll(each.getAttackedTypes());
            this.addAttackers(each.getAttackers());
        }
        this.refreshState();
        return this;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("attackedZoneIps", this.attackedZoneIps).append("attackingZoneIps", this.attackingZoneIps).append("alertZoneIps", this.alertZoneIps).append("attackedTypes", this.attackedTypes).toString();
    }

    private void refreshState() {
        if (!this.attackingZoneIps.isEmpty()) {
            this.setCurrentState(2);
        } else if (!this.alertZoneIps.isEmpty()) {
            this.setCurrentState(1);
        } else {
            this.setCurrentState(0);
        }
    }
}

