/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class BizEvent
extends Event {
    private long pkid;
    private boolean saved;
    private int ipProtocol;
    private int bizDstPort;
    private int protoId;
    private String protoName;
    private int appId;
    private String appnName;
    private int srvId;
    private String srvName;
    private long srvPps;
    private long srvKbps;
    private String serviceName;

    public BizEvent(EventIdentifier identifer) {
        super(identifer);
    }

    public long getPkid() {
        return this.pkid;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public void setPkid(long pkid) {
        this.pkid = pkid;
    }

    public String getProtoName() {
        return this.protoName;
    }

    public void setProtoName(String protoName) {
        this.protoName = protoName;
    }

    public String getAppnName() {
        return this.appnName;
    }

    public void setAppnName(String appnName) {
        this.appnName = appnName;
    }

    public String getSrvName() {
        return this.srvName;
    }

    public void setSrvName(String srvName) {
        this.srvName = srvName;
    }

    public boolean isHasPkId() {
        return this.pkid != 0L;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public Event getCopyEvent() {
        BizEvent copy = new BizEvent(this.getIdentifierCopy());
        copy.setIpProtocol(this.getIpProtocol());
        copy.setBizDstPort(this.getBizDstPort());
        copy.setServiceName(this.getServiceName());
        copy.setAppId(this.getAppId());
        copy.setAppnName(this.getAppnName());
        copy.setProtoName(this.getProtoName());
        copy.setProtoId(this.getProtoId());
        copy.setSrvId(this.getSrvId());
        copy.setSrvName(this.getSrvName());
        return copy;
    }

    @Override
    public void average(int number) {
        this.setSrvKbps(this.devideUp(this.getSrvKbps(), number));
        this.setSrvPps(this.devideUp(this.getSrvPps(), number));
    }

    public int getAppId() {
        return this.appId;
    }

    public int getBizDstPort() {
        return this.bizDstPort;
    }

    public int getIpProtocol() {
        return this.ipProtocol;
    }

    public int getProtoId() {
        return this.protoId;
    }

    public int getSrvId() {
        return this.srvId;
    }

    public long getSrvKbps() {
        return this.srvKbps;
    }

    public long getSrvPps() {
        return this.srvPps;
    }

    @Override
    public void merge(List<? extends Event> events) {
        if (null != events && !events.isEmpty()) {
            for (Event event : events) {
                this.merge(event);
            }
        }
    }

    private void merge(Event e) {
        BizEvent event = (BizEvent)e;
        this.setSrvKbps(this.getSrvKbps() + event.getSrvKbps());
        this.setSrvPps(this.getSrvPps() + event.getSrvPps());
    }

    public void setAppId(int appId) {
        this.appId = appId;
    }

    public void setBizDstPort(int bizDstPort) {
        this.bizDstPort = bizDstPort;
    }

    public void setIpProtocol(int ipProtocol) {
        this.ipProtocol = ipProtocol;
    }

    public void setProtoId(int protoId) {
        this.protoId = protoId;
    }

    public void setSrvId(int srvId) {
        this.srvId = srvId;
    }

    public void setSrvKbps(int srvKbps) {
        this.srvKbps = srvKbps;
    }

    public void setSrvKbps(long srvKbps) {
        this.srvKbps = srvKbps;
    }

    public void setSrvPps(int srvPps) {
        this.srvPps = srvPps;
    }

    public void setSrvPps(long srvPps) {
        this.srvPps = srvPps;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).appendSuper(this.getIdentifier().toString()).append("ipProtocol", this.getIpProtocol()).append("BizDstPort", this.getBizDstPort()).append("ProtoId", this.getProtoId()).append("appid", this.getAppId()).append("SrvId", this.getSrvId()).append("SrvPps", this.getSrvPps()).append("SrvKbps", this.getSrvKbps()).toString();
    }
}

