/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ForwardFlowEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.OtherBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.TotalFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class BizTotalFlowEvent
extends TotalFlowEvent {
    private BizTotalBizFlowType type = new BizTotalBizFlowType();
    private long totalPps;
    private long totalKbps;
    private long allReboundPps;
    private long allReboundKbps;

    public BizTotalFlowEvent(EventIdentifier identifer, boolean isDrop) {
        this(identifer);
        super.setDropFlow(isDrop);
        this.type.setDrop(isDrop);
    }

    public BizTotalFlowEvent(EventIdentifier identifer) {
        super(identifer);
        this.type.setClazzName(this.getClass().getName());
    }

    @Override
    public void average(int size) {
        this.setTotalPps(this.devideUp(this.totalPps, size));
        this.setTotalKbps(this.devideUp(this.totalKbps, size));
        this.setAllReboundPps(this.devideUp(this.allReboundPps, size));
        this.setAllReboundKbps(this.devideUp(this.allReboundKbps, size));
    }

    @Override
    public List<String> getSysLogInfo() {
        List<String> info = super.getSysLogInfo();
        info.add("total_pps=" + this.getTotalPps());
        info.add("total_kbps=" + this.getTotalKbps());
        return info;
    }

    public long getTotalKbps() {
        return this.totalKbps;
    }

    public long getTotalPps() {
        return this.totalPps;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void max(Event e) {
        if (null != e && e instanceof BizTotalFlowEvent) {
            BizTotalFlowEvent totalBiz = (BizTotalFlowEvent)e;
            this.setTotalPps(this.getTotalPps() > totalBiz.getTotalPps() ? this.getTotalPps() : totalBiz.getTotalPps());
            this.setTotalKbps(this.getTotalKbps() > totalBiz.getTotalKbps() ? this.getTotalKbps() : totalBiz.getTotalKbps());
            this.setAllReboundPps(this.allReboundPps > totalBiz.allReboundPps ? this.allReboundPps : totalBiz.allReboundPps);
            this.setAllReboundKbps(this.allReboundKbps > totalBiz.allReboundKbps ? this.allReboundKbps : totalBiz.allReboundKbps);
        }
    }

    protected void merge(Event event) {
        BizTotalFlowEvent bizTotal = (BizTotalFlowEvent)event;
        this.setTotalPps(this.totalPps + bizTotal.getTotalPps());
        this.setTotalKbps(this.totalKbps + bizTotal.getTotalKbps());
        this.setAllReboundPps(this.allReboundPps + bizTotal.allReboundPps);
        this.setAllReboundKbps(this.allReboundKbps + bizTotal.allReboundKbps);
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            this.merge(event);
        }
    }

    @Override
    public void mergeDiscardFlowEvent(DiscardFlowEvent discard) {
        this.setTotalPps(this.totalPps + discard.getAllPps());
        this.setTotalKbps(this.totalKbps + discard.getAllKbps());
        this.setAllReboundPps(this.allReboundPps + discard.getAllReboundPps());
        this.setAllReboundKbps(this.allReboundKbps + discard.getAllReboundKbps());
    }

    @Override
    public void mergeInFlowEvent(InFlowEvent flowEvent) {
        this.setTotalPps(this.totalPps + flowEvent.getAllPps());
        this.setTotalKbps(this.totalKbps + flowEvent.getAllKbps());
    }

    public void mergeForwardFlowEvent(ForwardFlowEvent flowEvent) {
        this.setTotalPps(this.totalPps + flowEvent.getAllPps());
        this.setTotalKbps(this.totalKbps + flowEvent.getAllKbps());
    }

    @Override
    public void mergeTcpBizFlowEvent(TcpBizFlowEvent tcpBizFlow) {
        this.setTotalPps(this.totalPps + tcpBizFlow.getTotalPps());
        this.setTotalKbps(this.totalKbps + tcpBizFlow.getTotalKbps());
        this.setAllReboundPps(this.allReboundPps + tcpBizFlow.getTotalReboundPps());
        this.setAllReboundKbps(this.allReboundKbps + tcpBizFlow.getTotalReboundKbps());
    }

    @Override
    public void mergeUdpBizFlowEvent(UdpBizFlowEvent udpBizFlow) {
        this.setTotalPps(this.totalPps + udpBizFlow.getTotalPps());
        this.setTotalKbps(this.totalKbps + udpBizFlow.getTotalKbps());
        this.setAllReboundPps(this.allReboundPps + udpBizFlow.getTotalReboundPps());
        this.setAllReboundKbps(this.allReboundKbps + udpBizFlow.getTotalReboundKbps());
    }

    @Override
    public void mergeOtherBizFlowEvent(OtherBizFlowEvent each) {
        this.setTotalPps(this.totalPps + each.getTotalPps());
        this.setTotalKbps(this.totalKbps + each.getTotalKbps());
    }

    @Override
    public void setDropFlow(boolean isDropFlow) {
        super.setDropFlow(isDropFlow);
        this.type.setDrop(isDropFlow);
    }

    public void setTotalKbps(long totalKbps) {
        this.totalKbps = totalKbps;
    }

    public void setTotalPps(long totalPps) {
        this.totalPps = totalPps;
    }

    public long getAllReboundPps() {
        return this.allReboundPps;
    }

    public void setAllReboundPps(long allReboundPps) {
        this.allReboundPps = allReboundPps;
    }

    public long getAllReboundKbps() {
        return this.allReboundKbps;
    }

    public void setAllReboundKbps(long allReboundKbps) {
        this.allReboundKbps = allReboundKbps;
    }

    @Override
    public String toString() {
        if (this.isValid()) {
            return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("is dorp flow: ", this.isIsDropFlow()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("totolPps", this.getTotalPps()).append("allBkps", this.getTotalKbps()).append("allReboundPps", this.allReboundPps).append("allReboundKbps", this.allReboundKbps).toString();
        }
        return "invalide flow event";
    }

    private static class BizTotalBizFlowType
    implements Type {
        boolean isDrop;
        private String clazzName;

        private BizTotalBizFlowType() {
        }

        public boolean equals(Object o) {
            if (o instanceof BizTotalBizFlowType) {
                BizTotalBizFlowType type = (BizTotalBizFlowType)o;
                return this.isDrop == type.isIsDrop() && this.clazzName.equals(type.getClazzName());
            }
            return false;
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public int hashCode() {
            return this.isDrop ? 0 : 1 + this.clazzName.hashCode();
        }

        public boolean isIsDrop() {
            return this.isDrop;
        }

        public void setClazzName(String clazzName) {
            this.clazzName = clazzName;
        }

        public void setDrop(boolean isDrops) {
            this.isDrop = isDrops;
        }
    }
}

