/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.FlowEvent;
import com.hs.atic.collector.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DiscardFlowEvent
extends FlowEvent {
    private long allReboundPps;
    private long allReboundKbps;
    private long tcpReboundPps;
    private long tcpReboundKbps;
    private long udpReboundPps;
    private long udpReboundKbps;
    private long synReboundPps;
    private long synAckReboundPps;

    public DiscardFlowEvent(EventIdentifier identifer) {
        super(identifer);
        super.setDropFlow(true);
    }

    public long getAllReboundPps() {
        return this.allReboundPps;
    }

    public void setAllReboundPps(long allReboundPps) {
        this.allReboundPps = allReboundPps;
    }

    public long getAllReboundKbps() {
        return this.allReboundKbps;
    }

    public void setAllReboundKbps(long allReboundKbps) {
        this.allReboundKbps = allReboundKbps;
    }

    public long getTcpReboundPps() {
        return this.tcpReboundPps;
    }

    public void setTcpReboundPps(long tcpReboundPps) {
        this.tcpReboundPps = tcpReboundPps;
    }

    public long getTcpReboundKbps() {
        return this.tcpReboundKbps;
    }

    public void setTcpReboundKbps(long tcpReboundKbps) {
        this.tcpReboundKbps = tcpReboundKbps;
    }

    public long getUdpReboundPps() {
        return this.udpReboundPps;
    }

    public void setUdpReboundPps(long udpReboundPps) {
        this.udpReboundPps = udpReboundPps;
    }

    public long getUdpReboundKbps() {
        return this.udpReboundKbps;
    }

    public void setUdpReboundKbps(long udpReboundKbps) {
        this.udpReboundKbps = udpReboundKbps;
    }

    public long getSynReboundPps() {
        return this.synReboundPps;
    }

    public void setSynReboundPps(long synReboundPps) {
        this.synReboundPps = synReboundPps;
    }

    public long getSynAckReboundPps() {
        return this.synAckReboundPps;
    }

    public void setSynAckReboundPps(long synAckReboundPps) {
        this.synAckReboundPps = synAckReboundPps;
    }

    @Override
    public void average(int size) {
        super.average(size);
        this.setAllReboundPps(this.devideUp(this.allReboundPps, size));
        this.setAllReboundKbps(this.devideUp(this.allReboundKbps, size));
        this.setTcpReboundPps(this.devideUp(this.tcpReboundPps, size));
        this.setTcpReboundKbps(this.devideUp(this.tcpReboundKbps, size));
        this.setUdpReboundPps(this.devideUp(this.udpReboundPps, size));
        this.setUdpReboundKbps(this.devideUp(this.udpReboundKbps, size));
        this.setSynReboundPps(this.devideUp(this.synReboundPps, size));
        this.setSynAckReboundPps(this.devideUp(this.synAckReboundPps, size));
    }

    @Override
    public void max(Event event) {
        super.max(event);
        if (event instanceof DiscardFlowEvent) {
            DiscardFlowEvent discard = (DiscardFlowEvent)event;
            this.setAllReboundPps(this.allReboundPps > discard.allReboundPps ? this.allReboundPps : discard.allReboundPps);
            this.setAllReboundKbps(this.allReboundKbps > discard.allReboundKbps ? this.allReboundKbps : discard.allReboundKbps);
            this.setTcpReboundPps(this.tcpReboundPps > discard.tcpReboundPps ? this.tcpReboundPps : discard.tcpReboundPps);
            this.setTcpReboundKbps(this.tcpReboundKbps > discard.tcpReboundKbps ? this.tcpReboundKbps : discard.tcpReboundKbps);
            this.setUdpReboundPps(this.udpReboundPps > discard.udpReboundPps ? this.udpReboundPps : discard.udpReboundPps);
            this.setUdpReboundKbps(this.udpReboundKbps > discard.udpReboundKbps ? this.udpReboundKbps : discard.udpReboundKbps);
            this.setSynReboundPps(this.synReboundPps > discard.synReboundPps ? this.synReboundPps : discard.synReboundPps);
            this.setSynAckReboundPps(this.synAckReboundPps > discard.synAckReboundPps ? this.synAckReboundPps : discard.synAckReboundPps);
        }
    }

    @Override
    protected void merge(Event event) {
        super.merge(event);
        if (event instanceof DiscardFlowEvent) {
            DiscardFlowEvent discard = (DiscardFlowEvent)event;
            this.setAllReboundPps(this.allReboundPps + discard.allReboundPps);
            this.setAllReboundKbps(this.allReboundKbps + discard.allReboundKbps);
            this.setTcpReboundPps(this.tcpReboundPps + discard.tcpReboundPps);
            this.setTcpReboundKbps(this.tcpReboundKbps + discard.tcpReboundKbps);
            this.setUdpReboundPps(this.udpReboundPps + discard.udpReboundPps);
            this.setUdpReboundKbps(this.udpReboundKbps + discard.udpReboundKbps);
            this.setSynReboundPps(this.synReboundPps + discard.synReboundPps);
            this.setSynAckReboundPps(this.synAckReboundPps + discard.synAckReboundPps);
        }
    }

    @Override
    public void caculateTotal() {
        super.caculateTotal();
        this.allReboundPps = this.tcpReboundPps + this.udpReboundPps;
        this.allReboundKbps = this.tcpReboundKbps + this.udpReboundKbps;
    }

    public void caculateReboundTotal() {
        this.allReboundPps = this.tcpReboundPps + this.udpReboundPps;
        this.allReboundKbps = this.tcpReboundKbps + this.udpReboundKbps;
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        if (this.isDeviceEvent()) {
            if (this.isIsMaxEvent()) {
                info.add("log_type=device_drop_flow");
                this.getDeviceMaxSyslogInfo(info);
                info.add("max_total_rebound_pps=" + this.allReboundPps);
                info.add("max_total_rebound_kbps=" + this.allReboundKbps);
                info.add("max_tcp_rebound_pps=" + this.tcpReboundPps);
                info.add("max_tcp_rebound_kbps=" + this.tcpReboundKbps);
                info.add("max_udp_rebound_pps=" + this.udpReboundPps);
                info.add("max_udp_rebound_kbps=" + this.udpReboundKbps);
            } else {
                this.getDeviceAvgSyslogInfo(info);
                info.add("avg_total_rebound_pps=" + this.allReboundPps);
                info.add("avg_total_rebound_kbps=" + this.allReboundKbps);
                info.add("avg_tcp_rebound_pps=" + this.tcpReboundPps);
                info.add("avg_tcp_rebound_kbps=" + this.tcpReboundKbps);
                info.add("avg_udp_rebound_pps=" + this.udpReboundPps);
                info.add("avg_udp_rebound_kbps=" + this.udpReboundKbps);
            }
        } else if (this.isIsMaxEvent()) {
            info.add("log_type=ip_drop");
            info.addAll(super.getSysLogInfo());
        } else {
            info.add("total_average_pps=" + this.getTotalPps());
            info.add("total_average_kbps=" + this.getTotalKbps());
        }
        return info;
    }

    @Override
    public String toString() {
        if (this.isValid()) {
            return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("allReboundPps", this.allReboundPps).append("allReboundKbps", this.allReboundKbps).append("tcpReboundPps", this.tcpReboundPps).append("tcpReboundKbps", this.tcpReboundKbps).append("udpReboundPps", this.udpReboundPps).append("udpReboundKbps", this.udpReboundKbps).append("synReboundPps", this.synReboundPps).append("synAckReboundPps", this.synAckReboundPps).toString();
        }
        return "invalide flow event";
    }

    @Override
    public boolean isFlowOverMax() {
        int aticFlowMaxNum = CommonUtil.getAticFlowMaxNum();
        if (super.isFlowOverMax()) {
            return true;
        }
        if (this.allReboundPps > (long)aticFlowMaxNum) {
            return true;
        }
        if (this.allReboundKbps > (long)aticFlowMaxNum) {
            return true;
        }
        if (this.tcpReboundPps > (long)aticFlowMaxNum) {
            return true;
        }
        if (this.tcpReboundKbps > (long)aticFlowMaxNum) {
            return true;
        }
        if (this.udpReboundPps > (long)aticFlowMaxNum) {
            return true;
        }
        if (this.udpReboundKbps > (long)aticFlowMaxNum) {
            return true;
        }
        if (this.synReboundPps > (long)aticFlowMaxNum) {
            return true;
        }
        return this.synAckReboundPps > (long)aticFlowMaxNum;
    }
}

