/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.log.DynamicBaseLineData;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DynamicBaseLineTask {
    public static final int CANCEL = 0;
    private boolean isCancel = false;
    private boolean isSaved;
    private long endTime;
    private long startTime;
    private long taskId;
    private long zoneId;
    private DynamicBaseLineData data;

    public DynamicBaseLineTask(long taskId, long zoneId) {
        this.taskId = taskId;
        this.zoneId = zoneId;
        this.data = new DynamicBaseLineData();
        this.data.setTaskId(taskId);
        this.data.setZoneId(zoneId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DynamicBaseLineTask) {
            DynamicBaseLineTask temp = (DynamicBaseLineTask)o;
            return temp.getTaskId() == this.taskId && this.zoneId == temp.getZoneId();
        }
        return false;
    }

    public DynamicBaseLineData getData() {
        return this.data;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public DynamicBaseLineData getMaxValue(DynamicBaseLineData event) {
        this.data.max(event);
        return this.data;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public int hashCode() {
        long result = 17L;
        result += result * 21L + this.zoneId;
        result += result * 21L + this.taskId;
        return (int)result;
    }

    public boolean isIsCancel() {
        return this.isCancel;
    }

    public boolean isCompleted() {
        return System.currentTimeMillis() >= this.endTime;
    }

    public boolean isIsSaved() {
        return this.isSaved;
    }

    public boolean isShowTime() {
        long currentTimeMillis = System.currentTimeMillis();
        return currentTimeMillis >= this.startTime && currentTimeMillis <= this.endTime && !this.isCancel;
    }

    public void setCancel(boolean cancel) {
        this.isCancel = cancel;
    }

    public void setData(DynamicBaseLineData data) {
        this.data = data;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setSaved(boolean saved) {
        this.isSaved = saved;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("isCancel", this.isCancel).append("isSaved", this.isSaved).append("startTime", (Object)new Date(this.startTime)).append("endTime", (Object)new Date(this.endTime)).append("taskId", this.taskId).append("zoenId", this.zoneId).append("baseLineData", (Object)this.data).toString();
    }
}

