/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.EventType;
import com.hs.atic.collector.entity.event.ToSysLog;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.ZoneUitl;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public abstract class Event
implements ToSysLog {
    private static final String[] DEVICE_TYPE = new String[]{"CLEAN", "DETECT"};
    private EventIdentifier identifer;
    private EventType type;
    private boolean isHourEvent;
    private boolean isMaxEvent;
    private boolean isMinSumEvent;
    private boolean needSum = true;
    private boolean isDropFlow;
    private boolean isForwardFlow;

    public Event(EventIdentifier identifer) {
        this.identifer = identifer;
        this.type = new EventType();
        this.type.setClazzName(this.getClass().getName());
    }

    public abstract void average(int var1);

    public long devideUp(long num, int count) {
        return (num + (long)count - 1L) / (long)count;
    }

    public long getBizId() {
        return this.identifer.getBizId();
    }

    public Event getCopyEvent() {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(EventIdentifier.class);
            Event copy = (Event)constructor.newInstance(this.identifer);
            copy.setDropFlow(this.isDropFlow);
            copy.setForwardFlow(this.isForwardFlow);
            copy.setMaxEvent(this.isMaxEvent);
            copy.setHourEvent(this.isHourEvent);
            copy.setNeedSum(this.needSum);
            return copy;
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("when copy a event ,error hanpped,source event is " + this, e);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException("when copy a event ,error hanpped,source event is " + this, e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("when copy a event ,error hanpped,source event is " + this, e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("when copy a event ,error hanpped,source event is " + this, e);
        }
    }

    public int getCpu() {
        return this.identifer.getCpu();
    }

    public int getVpnIndex() {
        return this.identifer.getVpnIndex();
    }

    public String getDeviceIp() {
        return this.identifer.getDeviceIp();
    }

    public int getDeviceType() {
        return this.identifer.getDeviceType();
    }

    @Override
    public String getHostName() {
        return this.identifer.getDeviceIp();
    }

    public EventIdentifier getIdentifierCopy() {
        EventIdentifier copy = new EventIdentifier();
        copy.setCpu(this.identifer.getCpu());
        copy.setDeviceIp(this.identifer.getDeviceIp());
        copy.setDeviceType(this.identifer.getDeviceType());
        copy.setDirection(this.identifer.getDirection());
        copy.setLogTime(this.identifer.getLogTime());
        copy.setZoneId(this.identifer.getZoneId());
        copy.setBizId(this.identifer.getBizId());
        copy.setZoneIp(this.identifer.getZoneIp());
        copy.setTypeValue(this.identifer.getType());
        copy.setProtocol(this.identifer.getProtocol());
        copy.setPort(this.identifer.getPort());
        copy.setSlotId(this.identifer.getSlotId());
        copy.setIsDefaultBiz(this.identifer.getIsDefaultBiz());
        copy.setVersion(this.identifer.getVersion());
        copy.setDesZone(this.identifer.isDesZone());
        copy.setIpLocation(this.identifer.isIpLocation());
        copy.setIpLocationId(this.identifer.getIpLocationId());
        copy.setVpnIndex(this.identifer.getVpnIndex());
        copy.setDeviceTypeName(this.identifer.getDeviceTypeName());
        return copy;
    }

    public EventIdentifier getIdentifier() {
        return this.identifer;
    }

    public long getLogTime() {
        return this.identifer.getLogTime();
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("time=\"" + EventUtil.getTimeStamp(System.currentTimeMillis()) + "\"");
        info.add("device_ip=" + this.getDeviceIp());
        info.add("device_type=" + DEVICE_TYPE[this.getDeviceType()]);
        info.add("direction=" + CommonUtil.getDirectionStr(this.getDirection()));
        info.add("zone_id=" + this.getZoneId());
        info.add("zone_name=" + ZoneUitl.getInstance().getZoneNameById(this.getZoneId()));
        info.add("zone_ip=" + this.getZoneIp());
        info.add("biz_id=" + this.getBizId());
        info.add("is_deszone=" + (this.isZoneEvent() ? "true" : "false"));
        info.add("is_ipLocation=" + (this.getIdentifier().isIpLocation() ? "true" : "false"));
        info.add("ipLocation_id=" + this.getIdentifier().getIpLocationId());
        return info;
    }

    public boolean isLess(Event t) {
        return false;
    }

    @Override
    public long getTime() {
        return this.identifer.getLogTime();
    }

    public Type getType() {
        return this.type;
    }

    public long getZoneId() {
        return this.identifer.getZoneId();
    }

    public String getZoneIp() {
        return this.identifer.getZoneIp();
    }

    public int getSlotId() {
        return this.identifer.getSlotId();
    }

    public long getIpLocationId() {
        return this.identifer.getIpLocationId();
    }

    public boolean isBizEvent() {
        return this.identifer.isBizEvent();
    }

    public boolean isDeviceEvent() {
        return this.identifer.isDeviceEvent();
    }

    public boolean isSlotEvent() {
        return this.identifer.isSlotEvent();
    }

    public boolean isIpLocationEvent() {
        return this.identifer.isIpLocationEvent();
    }

    public boolean isFromCleanDevice() {
        return this.getDeviceType() == 0;
    }

    public boolean isIsHourEvent() {
        return this.isHourEvent;
    }

    public boolean isIsMaxEvent() {
        return this.isMaxEvent;
    }

    public boolean isIsMinSumEvent() {
        return this.isMinSumEvent;
    }

    public boolean isNeedSum() {
        return this.needSum;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isDefaultZone() {
        return this.identifer.getZoneId() <= 1L;
    }

    public boolean isZoneEvent() {
        return this.identifer.isZoneEvent();
    }

    public boolean isZoneIp() {
        return this.identifer.isZoneIp();
    }

    public void max(Event event) {
    }

    public abstract void merge(List<? extends Event> var1);

    public void mergeWithDesZone(Event e) {
    }

    public void setHourEvent(boolean isHourEvents) {
        this.isHourEvent = isHourEvents;
    }

    public void setMinSumEvent(boolean isMinSumEvents) {
        this.isMinSumEvent = isMinSumEvents;
    }

    public void setIdentifer(EventIdentifier identifer) {
        this.identifer = identifer;
    }

    public void setLogTime(long time) {
        this.identifer.setLogTime(time);
    }

    public void setMaxEvent(boolean isMaxEvents) {
        this.isMaxEvent = isMaxEvents;
    }

    public void setNeedSum(boolean needSum) {
        this.needSum = needSum;
    }

    public boolean isIsDropFlow() {
        return this.isDropFlow;
    }

    public boolean isIsForwardFlow() {
        return this.isForwardFlow;
    }

    public void setDropFlow(boolean isDropFlows) {
        this.isDropFlow = isDropFlows;
    }

    public void setForwardFlow(boolean isForwardFlows) {
        this.isForwardFlow = isForwardFlows;
    }

    public String getEventTypeString() {
        return this.getClass().getName();
    }

    public String getDeviceTypeName() {
        return this.identifer.getDeviceTypeName();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).appendSuper("super").append("head", (Object)this.identifer).append("isMaxEvent", this.isMaxEvent).append("isDropFlow", this.isDropFlow).append("isForwardFlow", this.isForwardFlow).append("isHourEvent", this.isHourEvent).append("isMinSumEvent", this.isMinSumEvent).toString();
    }

    public boolean isFlowOverMax() {
        return false;
    }

    public Event getFlowCopyEvent() {
        return null;
    }

    public int getDirection() {
        return this.identifer.getDirection();
    }

    public boolean isInboundEvent() {
        return 1 == this.identifer.getDirection();
    }
}

