/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.monitor.DeviceObj;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class EventIdentifier {
    private static final int CPU = 0;
    private static final int IP = 1;
    private static final int ZONE = 2;
    private static final int DEVICE = 3;
    private static final int BIZ = 4;
    private static final int SLOT = 5;
    private static final int IPLOCATION = 6;
    private int type = 0;
    private int cpu;
    private int direction = 1;
    private String deviceIp = "0.0.0.0";
    private int version;
    private int deviceType;
    private long logTime;
    private long zoneId;
    private String zoneIp = "0.0.0.0";
    private long bizId;
    private long dnsId;
    private int protocol;
    private int port;
    private boolean desZone = false;
    private boolean ipLocation = false;
    private long ipLocationId;
    private int slotId;
    private Boolean isDefaultBiz = true;
    private int vpnIndex;
    private String deviceTypeName;

    public boolean equals(Object o) {
        EventIdentifier identifer;
        if (o instanceof EventIdentifier && (identifer = (EventIdentifier)o).getType() == this.getType() && identifer.getDirection() == this.getDirection()) {
            if (this.isDeviceEvent()) {
                return identifer.getDeviceIp().equals(this.deviceIp) && identifer.getDeviceType() == this.deviceType;
            }
            if (this.isZoneEvent()) {
                return identifer.getDeviceIp().equals(this.deviceIp) && identifer.getDeviceType() == this.deviceType && identifer.getZoneId() == this.zoneId;
            }
            if (this.isBizEvent()) {
                return identifer.getDeviceIp().equals(this.deviceIp) && identifer.getDeviceType() == this.deviceType && identifer.getZoneId() == this.zoneId && identifer.getBizId() == this.bizId;
            }
            return identifer.getDeviceIp().equals(this.deviceIp) && identifer.getDeviceType() == this.deviceType && identifer.getZoneId() == this.zoneId && identifer.getBizId() == this.bizId && identifer.getZoneIp().equals(this.zoneIp);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result += 19 * this.deviceType;
        result += 19 * this.direction;
        if (this.isDeviceEvent()) {
            result += 19 * this.deviceIp.hashCode();
        } else if (this.isZoneEvent()) {
            result += 19 * (int)(this.zoneId ^ this.zoneId >>> 32);
            result += 19 * this.deviceIp.hashCode();
        } else {
            result += 19 * (int)(this.zoneId ^ this.zoneId >>> 32);
            result += 19 * this.deviceIp.hashCode();
            result += 19 * this.zoneIp.hashCode();
        }
        return result;
    }

    public boolean isDesZone() {
        return this.desZone;
    }

    public void setDesZone(boolean desZone) {
        this.desZone = desZone;
    }

    public boolean isIpLocation() {
        return this.ipLocation;
    }

    public void setIpLocation(boolean ipLocation) {
        this.ipLocation = ipLocation;
    }

    public long getIpLocationId() {
        return this.ipLocationId;
    }

    public void setIpLocationId(long ipLocationId) {
        this.ipLocationId = ipLocationId;
    }

    public long getBizId() {
        return this.bizId;
    }

    public int getCpu() {
        return this.cpu;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public long getDnsId() {
        return this.dnsId;
    }

    public Boolean getIsDefaultBiz() {
        return this.isDefaultBiz;
    }

    public long getLogTime() {
        return this.logTime;
    }

    public int getPort() {
        return this.port;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int getSlotId() {
        return this.slotId;
    }

    public int getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getZoneIp() {
        return this.zoneIp;
    }

    public boolean isBizEvent() {
        return this.type == 4;
    }

    public boolean isCpuEvent() {
        return this.type == 0;
    }

    public boolean isDeviceEvent() {
        return this.type == 3;
    }

    public boolean isFromDetectDevice() {
        return this.deviceType == 1;
    }

    public boolean isSlotEvent() {
        return this.type == 5;
    }

    public boolean isIpLocationEvent() {
        return this.type == 6;
    }

    public boolean isZoneEvent() {
        return this.type == 2;
    }

    public boolean isZoneIp() {
        return this.type == 1;
    }

    public void setBizId(long bizId) {
        this.bizId = bizId;
    }

    public void setBizType() {
        this.type = 4;
    }

    public void setCpu(int cpu) {
        this.cpu = cpu;
    }

    public void setCpuType() {
        this.type = 0;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public void setDeviceType() {
        this.type = 3;
    }

    public void setDeviceType(int deviceType) {
        this.deviceType = deviceType;
    }

    public void setDnsId(long dnsId) {
        this.dnsId = dnsId;
    }

    public void setIsDefaultBiz(Boolean isDefaultBiz) {
        this.isDefaultBiz = isDefaultBiz;
    }

    public void setLogTime(long logTime) {
        this.logTime = logTime;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public void setSlotId(int slotId) {
        this.slotId = slotId;
    }

    public void setSlotType() {
        this.type = 5;
    }

    public void setIpLocationType() {
        this.type = 6;
    }

    public void setTypeValue(int typeValue) {
        this.type = typeValue;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setZoneId(long zoneId) {
        this.zoneId = zoneId;
    }

    public void setZoneIp(String zoneIp) {
        this.zoneIp = zoneIp;
    }

    public void setZoneIpType() {
        this.type = 1;
    }

    public void setZoneType() {
        this.type = 2;
    }

    public int getVpnIndex() {
        return this.vpnIndex;
    }

    public void setVpnIndex(int vpnIndex) {
        this.vpnIndex = vpnIndex;
    }

    public String toString() {
        String typed = null;
        typed = this.type == 2 ? "ZONE" : (this.type == 1 ? "IP" : (this.type == 0 ? "CPU" : (this.type == 5 ? "SLOT" : (this.type == 6 ? "IPLOCATION" : "DEVICE"))));
        return new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE).appendSuper(super.toString()).append("device ip", (Object)this.deviceIp).append("device type", (Object)DeviceObj.getDeviceTypeDescriptor(this.deviceType)).append("direction", this.direction).append("slot", this.slotId).append("zone id", this.zoneId).append("zone ip", (Object)this.zoneIp).append("type", (Object)typed).append("vpnIndex", this.vpnIndex).append("bizId", this.bizId).append("cpu", this.cpu).append("logTime", (Object)new Date(this.logTime)).append("desZone", (Object)(this.desZone ? "true" : "false")).append("ipLocation", (Object)(this.ipLocation ? "true,ipLocationId," + this.ipLocationId : "false")).append("deviceTypeName", (Object)this.deviceTypeName).toString();
    }

    public void setDeviceTypeName(String devTypeName) {
        this.deviceTypeName = devTypeName;
    }

    public String getDeviceTypeName() {
        return this.deviceTypeName;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }
}

