/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dom4j.Element;

public class HttpBizFlowEvent
extends TcpBizFlowEvent {
    private static final String GET_PPS = "GET_PPS";
    private static final String POST_PPS = "POST_PPS";
    private static final String HOST_PPS = "HOST_PPS";
    private static final String TYPE = "TYPE";
    private static final String TYPE_VALUE = "HTTP";
    private long getPps;
    private long postPps;
    private long hostPps;
    private long reboundGetPps;
    private long reboundPostPps;

    public HttpBizFlowEvent(EventIdentifier identifer) {
        super(identifer);
    }

    @Override
    public void average(int size) {
        super.average(size);
        this.setGetPps(this.devideUp(this.getPps, size));
        this.setPostPps(this.devideUp(this.postPps, size));
        this.setHostPps(this.devideUp(this.hostPps, size));
        this.setReboundGetPps(this.devideUp(this.reboundGetPps, size));
        this.setReboundPostPps(this.devideUp(this.reboundPostPps, size));
    }

    public long getGetPps() {
        return this.getPps;
    }

    public long getHostPps() {
        return this.hostPps;
    }

    public long getPostPps() {
        return this.postPps;
    }

    @Override
    protected void merge(Event event) {
        HttpBizFlowEvent httpBizFlowEvent = (HttpBizFlowEvent)event;
        super.merge(httpBizFlowEvent);
        this.setGetPps(this.getPps + httpBizFlowEvent.getGetPps());
        this.setPostPps(this.postPps + httpBizFlowEvent.getPostPps());
        this.setHostPps(this.hostPps + httpBizFlowEvent.getHostPps());
        this.setReboundGetPps(this.reboundGetPps + httpBizFlowEvent.reboundGetPps);
        this.setReboundPostPps(this.reboundPostPps + httpBizFlowEvent.reboundPostPps);
    }

    @Override
    public void max(Event event) {
        if (null != event && event instanceof HttpBizFlowEvent) {
            HttpBizFlowEvent httpBizFlowEvent = (HttpBizFlowEvent)event;
            super.max(httpBizFlowEvent);
            this.setGetPps(this.getPps > httpBizFlowEvent.getPps ? this.getPps : httpBizFlowEvent.getPps);
            this.setPostPps(this.postPps > httpBizFlowEvent.postPps ? this.postPps : httpBizFlowEvent.postPps);
            this.setHostPps(this.hostPps > httpBizFlowEvent.hostPps ? this.hostPps : httpBizFlowEvent.hostPps);
            this.setReboundGetPps(this.reboundGetPps > httpBizFlowEvent.reboundGetPps ? this.reboundGetPps : httpBizFlowEvent.reboundGetPps);
            this.setReboundPostPps(this.reboundPostPps > httpBizFlowEvent.reboundPostPps ? this.reboundPostPps : httpBizFlowEvent.reboundPostPps);
        }
    }

    @Override
    public boolean isLess(Event e) {
        if (e instanceof HttpBizFlowEvent) {
            HttpBizFlowEvent event = (HttpBizFlowEvent)e;
            return super.isLess(e) || this.getPps < event.getPps || this.postPps < event.postPps || this.hostPps < event.hostPps;
        }
        return false;
    }

    public void setGetPps(long getPps) {
        this.getPps = getPps;
    }

    public void setHostPps(long hostPps) {
        this.hostPps = hostPps;
    }

    public void setPostPps(long postPps) {
        this.postPps = postPps;
    }

    public long getReboundGetPps() {
        return this.reboundGetPps;
    }

    public void setReboundGetPps(long reboundGetPps) {
        this.reboundGetPps = reboundGetPps;
    }

    public long getReboundPostPps() {
        return this.reboundPostPps;
    }

    public void setReboundPostPps(long reboundPostPps) {
        this.reboundPostPps = reboundPostPps;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("is dorp flow: ", this.isIsDropFlow()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("getPps: ", this.getPps).append("postPps: ", this.postPps).append("hostPps: ", this.hostPps).append("reboundGetPps: ", this.reboundGetPps).append("reboundPostPps: ", this.reboundPostPps).toString();
    }

    @Override
    public void toXml(Element element) {
        super.toXmlLoTime(element);
        element.addAttribute(TYPE, TYPE_VALUE);
        super.toXmlEntity(element);
        element.addAttribute(GET_PPS, this.getGetPps() + "");
        element.addAttribute(POST_PPS, this.getPostPps() + "");
        element.addAttribute(HOST_PPS, this.getHostPps() + "");
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("log_type=http_biz");
        info.addAll(super.getSysLogEntry());
        info.add("get_pps=" + this.getPps);
        info.add("post_pps=" + this.postPps);
        info.add("host_pps=" + this.hostPps);
        return info;
    }

    @Override
    public boolean isFlowOverMax() {
        int aticFlowMaxNum = CommonUtil.getAticFlowMaxNum();
        return super.isFlowOverMax() || this.getPps > (long)aticFlowMaxNum || this.postPps > (long)aticFlowMaxNum || this.hostPps > (long)aticFlowMaxNum || this.reboundGetPps > (long)aticFlowMaxNum || this.reboundPostPps > (long)aticFlowMaxNum;
    }

    @Override
    public HttpBizFlowEvent getCopyEvent() {
        HttpBizFlowEvent copy = (HttpBizFlowEvent)super.getCopyEvent();
        return copy;
    }

    @Override
    public HttpBizFlowEvent getFlowCopyEvent() {
        HttpBizFlowEvent copy = new HttpBizFlowEvent(this.getIdentifierCopy());
        copy.setDropFlow(this.isIsDropFlow());
        copy.setMaxEvent(this.isIsMaxEvent());
        copy.setHourEvent(this.isIsHourEvent());
        copy.setNeedSum(this.isNeedSum());
        copy.merge(this);
        return copy;
    }
}

