/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dom4j.Element;

public class HttpsBizFlowEvent
extends TcpBizFlowEvent {
    private static final String HELLO_PPS = "HELLO_PPS";
    private static final String TYPE = "TYPE";
    private static final String TYPE_VALUE = "HTTPS";
    private long helloPps;

    public HttpsBizFlowEvent(EventIdentifier identifer) {
        super(identifer);
    }

    @Override
    public void average(int size) {
        super.average(size);
        this.setHelloPps(this.devideUp(this.helloPps, size));
    }

    public long getHelloPps() {
        return this.helloPps;
    }

    @Override
    protected void merge(Event e) {
        HttpsBizFlowEvent event = (HttpsBizFlowEvent)e;
        super.merge(event);
        this.setHelloPps(this.helloPps + event.getHelloPps());
    }

    @Override
    public void max(Event e) {
        if (null != e && e instanceof HttpsBizFlowEvent) {
            HttpsBizFlowEvent event = (HttpsBizFlowEvent)e;
            super.max(event);
            this.setHelloPps(this.getHelloPps() > event.getHelloPps() ? this.getHelloPps() : event.getHelloPps());
        }
    }

    @Override
    public boolean isLess(Event e) {
        if (e instanceof HttpsBizFlowEvent) {
            HttpsBizFlowEvent event = (HttpsBizFlowEvent)e;
            return super.isLess(e) || this.helloPps < event.helloPps;
        }
        return false;
    }

    public void setHelloPps(long helloPps) {
        this.helloPps = helloPps;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("is dorp flow: ", this.isIsDropFlow()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("helloPps: ", this.helloPps).toString();
    }

    @Override
    public void toXml(Element element) {
        super.toXmlLoTime(element);
        element.addAttribute(TYPE, TYPE_VALUE);
        super.toXmlEntity(element);
        element.addAttribute(HELLO_PPS, this.getHelloPps() + "");
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("log_type=https_biz");
        info.addAll(super.getSysLogEntry());
        info.add("hello_pps=" + this.helloPps);
        return info;
    }

    @Override
    public boolean isFlowOverMax() {
        return super.isFlowOverMax() || this.helloPps > (long)CommonUtil.getAticFlowMaxNum();
    }

    @Override
    public HttpsBizFlowEvent getCopyEvent() {
        HttpsBizFlowEvent copy = (HttpsBizFlowEvent)super.getCopyEvent();
        return copy;
    }

    @Override
    public HttpsBizFlowEvent getFlowCopyEvent() {
        HttpsBizFlowEvent copy = new HttpsBizFlowEvent(this.getIdentifierCopy());
        copy.setDropFlow(this.isIsDropFlow());
        copy.setMaxEvent(this.isIsMaxEvent());
        copy.setHourEvent(this.isIsHourEvent());
        copy.setNeedSum(this.isNeedSum());
        copy.merge(this);
        return copy;
    }
}

