/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.FlowEvent;
import com.hs.atic.collector.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dom4j.Element;

public class InFlowEvent
extends FlowEvent {
    private static final String TCP_INCREASE_CON = "tcp_increase_con";
    private static final String UDP_INCREASE_CON = "udp_increase_con";
    private static final String ICMP_INCREASE_CON = "icmp_increase_con";
    private static final String OTHER_INCREASECON = "other_increase_con";
    private static final String TCP_CONCURCON = "tcp_concur_con";
    private static final String UDP_CONCURCON = "udp_concur_con";
    private static final String ICMP_CONCURCON = "icmp_concur_con";
    private static final String OTHER_CONCURCON = "other_concur_con";
    private long tcpIncreaseCon;
    private long udpIncreaseCon;
    private long icmpIncreaseCon;
    private long otherIncreaseCon;
    private long tcpConcurCon;
    private long udpConcurCon;
    private long icmpConcurCon;
    private long otherConcurCon;
    private long tcpSrcIncreaseCon;
    private long tcpSrcConcurCon;
    private long tcpRatio;
    private long tcpL500Ratio;
    private long synPktNum;
    private long srcAckKbps;

    public InFlowEvent(EventIdentifier identifer) {
        super(identifer);
    }

    @Override
    public void average(int size) {
        super.average(size);
        this.setTcpIncreaseCon(this.devideUp(this.tcpIncreaseCon, size));
        this.setUdpIncreaseCon(this.devideUp(this.udpIncreaseCon, size));
        this.setIcmpIncreaseCon(this.devideUp(this.icmpIncreaseCon, size));
        this.setOtherIncreaseCon(this.devideUp(this.otherIncreaseCon, size));
        this.setTcpConcurCon(this.devideUp(this.tcpConcurCon, size));
        this.setUdpConcurCon(this.devideUp(this.udpConcurCon, size));
        this.setIcmpConcurCon(this.devideUp(this.icmpConcurCon, size));
        this.setOtherConcurCon(this.devideUp(this.otherConcurCon, size));
        this.setSrcAckKbps(this.devideUp(this.srcAckKbps, size));
        this.setTcpSrcConcurCon(this.devideUp(this.tcpSrcIncreaseCon, size));
        this.setTcpIncreaseCon(this.devideUp(this.tcpSrcConcurCon, size));
    }

    public long getIcmpConcurCon() {
        return this.icmpConcurCon;
    }

    public long getIcmpIncreaseCon() {
        return this.icmpIncreaseCon;
    }

    public long getIncreaseRate() {
        return this.tcpIncreaseCon;
    }

    public long getOtherConcurCon() {
        return this.otherConcurCon;
    }

    public long getOtherIncreaseCon() {
        return this.otherIncreaseCon;
    }

    public long getTcpSrcIncreaseCon() {
        return this.tcpSrcIncreaseCon;
    }

    public void setTcpSrcIncreaseCon(long tcpSrcIncreaseCon) {
        this.tcpSrcIncreaseCon = tcpSrcIncreaseCon;
    }

    public long getTcpSrcConcurCon() {
        return this.tcpSrcConcurCon;
    }

    public void setTcpSrcConcurCon(long tcpSrcConcurCon) {
        this.tcpSrcConcurCon = tcpSrcConcurCon;
    }

    public long getTcpRatio() {
        return this.tcpRatio;
    }

    public void setTcpRatio(long tcpRatio) {
        this.tcpRatio = tcpRatio;
    }

    public long getTcpL500Ratio() {
        return this.tcpL500Ratio;
    }

    public void setTcpL500Ratio(long tcpL500Ratio) {
        this.tcpL500Ratio = tcpL500Ratio;
    }

    public long getSynPktNum() {
        return this.synPktNum;
    }

    public void setSynPktNum(long synPktNum) {
        this.synPktNum = synPktNum;
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        if (this.isDeviceEvent()) {
            if (this.isIsMaxEvent()) {
                info.add("log_type=device_in_flow");
                this.getDeviceMaxSyslogInfo(info);
            } else {
                this.getDeviceAvgSyslogInfo(info);
            }
        } else if (this.isIsMaxEvent()) {
            info.add("log_type=ip_flow");
            info.addAll(super.getSysLogInfo());
            info.add("tcp_increase_con=" + this.getTcpIncreaseCon());
            info.add("udp_increase_con=" + this.getUdpIncreaseCon());
            info.add("icmp_increase_con=" + this.getIcmpIncreaseCon());
            info.add("other_increase_con=" + this.getOtherIncreaseCon());
            info.add("tcp_concur_con=" + this.getTcpConcurCon());
            info.add("udp_concur_con=" + this.getUdpConcurCon());
            info.add("icmp_concur_con=" + this.getIcmpConcurCon());
            info.add("other_concur_con=" + this.getOtherConcurCon());
        } else {
            info.add("total_average_pps=" + this.getTotalPps());
            info.add("total_average_kbps=" + this.getTotalKbps());
        }
        return info;
    }

    public long getTcpConcurCon() {
        return this.tcpConcurCon;
    }

    public long getTcpIncreaseCon() {
        return this.tcpIncreaseCon;
    }

    public long getUdpConcurCon() {
        return this.udpConcurCon;
    }

    public long getUdpIncreaseCon() {
        return this.udpIncreaseCon;
    }

    @Override
    public void max(Event event) {
        super.max(event);
        if (event instanceof InFlowEvent) {
            InFlowEvent inFlow = (InFlowEvent)event;
            this.maxConcurCon(inFlow);
            this.maxIncreaseCon(inFlow);
            this.setSrcAckKbps(this.srcAckKbps > inFlow.getSrcAckKbps() ? this.srcAckKbps : inFlow.getSrcAckKbps());
        }
    }

    private void maxConcurCon(InFlowEvent inFlow) {
        this.setTcpConcurCon(this.getTcpConcurCon() > inFlow.getTcpConcurCon() ? this.getTcpConcurCon() : inFlow.getTcpConcurCon());
        this.setUdpConcurCon(this.getUdpConcurCon() > inFlow.getUdpConcurCon() ? this.getUdpConcurCon() : inFlow.getUdpConcurCon());
        this.setIcmpConcurCon(this.getIcmpConcurCon() > inFlow.getIcmpConcurCon() ? this.getIcmpConcurCon() : inFlow.getIcmpConcurCon());
        this.setOtherConcurCon(this.getOtherConcurCon() > inFlow.getOtherConcurCon() ? this.getOtherConcurCon() : inFlow.getOtherConcurCon());
        this.setTcpSrcConcurCon(this.getTcpSrcConcurCon() > inFlow.getTcpSrcConcurCon() ? this.getTcpSrcConcurCon() : inFlow.getTcpSrcConcurCon());
    }

    private void maxIncreaseCon(InFlowEvent inFlow) {
        this.setTcpIncreaseCon(this.getTcpIncreaseCon() > inFlow.getTcpIncreaseCon() ? this.getTcpIncreaseCon() : inFlow.getTcpIncreaseCon());
        this.setUdpIncreaseCon(this.getUdpIncreaseCon() > inFlow.getUdpIncreaseCon() ? this.getUdpIncreaseCon() : inFlow.getUdpIncreaseCon());
        this.setIcmpIncreaseCon(this.getIcmpIncreaseCon() > inFlow.getIcmpIncreaseCon() ? this.getIcmpIncreaseCon() : inFlow.getIcmpIncreaseCon());
        this.setOtherIncreaseCon(this.getOtherIncreaseCon() > inFlow.getOtherIncreaseCon() ? this.getOtherIncreaseCon() : inFlow.getOtherIncreaseCon());
        this.setTcpSrcIncreaseCon(this.getTcpSrcIncreaseCon() > inFlow.getTcpSrcIncreaseCon() ? this.getTcpSrcIncreaseCon() : inFlow.getTcpSrcIncreaseCon());
    }

    @Override
    protected void merge(Event event) {
        InFlowEvent inFlow = (InFlowEvent)event;
        super.merge(inFlow);
        this.setTcpIncreaseCon(this.tcpIncreaseCon + inFlow.getTcpIncreaseCon());
        this.setUdpIncreaseCon(this.udpIncreaseCon + inFlow.getUdpIncreaseCon());
        this.setIcmpIncreaseCon(this.icmpIncreaseCon + inFlow.getIcmpIncreaseCon());
        this.setOtherIncreaseCon(this.otherIncreaseCon + inFlow.getOtherIncreaseCon());
        this.setTcpConcurCon(this.tcpConcurCon + inFlow.getTcpConcurCon());
        this.setUdpConcurCon(this.udpConcurCon + inFlow.getUdpConcurCon());
        this.setIcmpConcurCon(this.icmpConcurCon + inFlow.getIcmpConcurCon());
        this.setOtherConcurCon(this.otherConcurCon + inFlow.getOtherConcurCon());
        this.setTcpRatio(this.tcpRatio > inFlow.getTcpRatio() ? this.tcpRatio : inFlow.getTcpRatio());
        this.setTcpL500Ratio(this.tcpL500Ratio > inFlow.getTcpL500Ratio() ? this.tcpL500Ratio : inFlow.getTcpL500Ratio());
        this.setSynPktNum(this.synPktNum + inFlow.getSynPktNum());
        this.setSrcAckKbps(this.srcAckKbps + inFlow.getSrcAckKbps());
        this.setTcpSrcIncreaseCon(this.tcpSrcIncreaseCon + inFlow.getTcpSrcIncreaseCon());
        this.setTcpSrcConcurCon(this.tcpSrcConcurCon + inFlow.getTcpSrcConcurCon());
    }

    public void setIcmpConcurCon(long connection) {
        this.icmpConcurCon = connection;
    }

    public void setIcmpIncreaseCon(long connection) {
        this.icmpIncreaseCon = connection;
    }

    public void setOtherConcurCon(long connection) {
        this.otherConcurCon = connection;
    }

    public void setOtherIncreaseCon(long connection) {
        this.otherIncreaseCon = connection;
    }

    public void setTcpConcurCon(long connection) {
        this.tcpConcurCon = connection;
    }

    public void setTcpIncreaseCon(long tcpIncreaseconnection) {
        this.tcpIncreaseCon = tcpIncreaseconnection;
    }

    public void setUdpConcurCon(long connection) {
        this.udpConcurCon = connection;
    }

    public void setUdpIncreaseCon(long connection) {
        this.udpIncreaseCon = connection;
    }

    public long getSrcAckKbps() {
        return this.srcAckKbps;
    }

    public void setSrcAckKbps(long srcAckKbps) {
        this.srcAckKbps = srcAckKbps;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("icmpIncreaseCon", this.icmpIncreaseCon).append("icmpConcurCon", this.icmpConcurCon).append("otherIncreaseCon", this.otherIncreaseCon).append("otherConcurCon", this.otherConcurCon).append("tcpIncreaseCon", this.tcpIncreaseCon).append("tcpConcurCon", this.tcpConcurCon).append("tcpSrcIncreaseCon", this.tcpSrcIncreaseCon).append("tcpSrcConcurCon", this.tcpSrcConcurCon).append("udpConcurCon", this.udpConcurCon).append("udpIncreaseCon", this.udpIncreaseCon).append("srcAckKbps", this.srcAckKbps).toString();
    }

    @Override
    public void toXml(Element element) {
        super.toXml(element);
        element.addAttribute(TCP_INCREASE_CON, this.tcpIncreaseCon + "");
        element.addAttribute(UDP_INCREASE_CON, this.udpIncreaseCon + "");
        element.addAttribute(ICMP_INCREASE_CON, this.icmpIncreaseCon + "");
        element.addAttribute(OTHER_INCREASECON, this.otherIncreaseCon + "");
        element.addAttribute(TCP_CONCURCON, this.tcpConcurCon + "");
        element.addAttribute(UDP_CONCURCON, this.udpConcurCon + "");
        element.addAttribute(ICMP_CONCURCON, this.icmpConcurCon + "");
        element.addAttribute(OTHER_CONCURCON, this.otherConcurCon + "");
    }

    @Override
    public boolean isFlowOverMax() {
        int aticFlowMaxNum = CommonUtil.getAticFlowMaxNum();
        Boolean flow = super.isFlowOverMax() || this.tcpIncreaseCon > (long)aticFlowMaxNum || this.udpIncreaseCon > (long)aticFlowMaxNum || this.icmpIncreaseCon > (long)aticFlowMaxNum || this.otherIncreaseCon > (long)aticFlowMaxNum;
        return flow != false || this.tcpConcurCon > (long)aticFlowMaxNum || this.udpConcurCon > (long)aticFlowMaxNum || this.icmpConcurCon > (long)aticFlowMaxNum || this.otherConcurCon > (long)aticFlowMaxNum;
    }

    @Override
    public InFlowEvent getCopyEvent() {
        InFlowEvent copy = (InFlowEvent)super.getCopyEvent();
        return copy;
    }

    @Override
    public InFlowEvent getFlowCopyEvent() {
        InFlowEvent copy = new InFlowEvent(this.getIdentifierCopy());
        copy.setDropFlow(this.isIsDropFlow());
        copy.setMaxEvent(this.isIsMaxEvent());
        copy.setHourEvent(this.isIsHourEvent());
        copy.setNeedSum(this.isNeedSum());
        copy.merge(this);
        return copy;
    }
}

