/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.AbnormalEvent;
import com.hs.atic.collector.entity.event.AttackType;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ExceptionEvent;
import com.hs.atic.collector.entity.event.SumAbnormalEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class IpAttackEvent
extends AbnormalEvent
implements SumAbnormalEvent<ExceptionEvent, IpAttackEvent> {
    private String exactLogIds;
    private Set<AttackType> alertingTypes = new HashSet<AttackType>();
    private Set<AttackType> alertedTypes = new HashSet<AttackType>();
    private Set<AttackType> attackedTypes = new HashSet<AttackType>();
    private Set<AttackType> attackTypes = new HashSet<AttackType>();
    private Set<AttackType> attackeringTypes = new HashSet<AttackType>();

    public IpAttackEvent(EventIdentifier identifer) {
        super(identifer);
        identifer.setZoneIpType();
    }

    public Set<AttackType> getAlertedTypes() {
        HashSet<AttackType> copy = new HashSet<AttackType>();
        copy.addAll(this.alertedTypes);
        return copy;
    }

    public Set<AttackType> getAlertingTypes() {
        HashSet<AttackType> copy = new HashSet<AttackType>();
        copy.addAll(this.alertingTypes);
        return copy;
    }

    public Set<AttackType> getAttackedTypes() {
        HashSet<AttackType> copy = new HashSet<AttackType>();
        copy.addAll(this.attackedTypes);
        return copy;
    }

    public Set<AttackType> getAttackingTypes() {
        HashSet<AttackType> copy = new HashSet<AttackType>();
        copy.addAll(this.attackeringTypes);
        return copy;
    }

    @Override
    public IpAttackEvent getCopyEvent() {
        IpAttackEvent copy = new IpAttackEvent(this.getIdentifierCopy());
        this.copy(copy);
        copy.setAlertingTypes(this.getAlertingTypes());
        copy.setAlertedTypes(this.getAlertedTypes());
        copy.setAttackingTypes(this.getAttackingTypes());
        copy.setAttackedTypes(this.getAttackedTypes());
        return copy;
    }

    public String getExactLogIds() {
        return this.exactLogIds;
    }

    @Override
    public List<String> getSysLogInfo() {
        return new ArrayList<String>();
    }

    @Override
    public boolean isDeviceEvent() {
        return false;
    }

    @Override
    public boolean isZoneEvent() {
        return false;
    }

    @Override
    public boolean isZoneIp() {
        return true;
    }

    public void setAlertedTypes(Set<AttackType> alertTypes) {
        this.alertedTypes = alertTypes;
    }

    public void setAlertingTypes(Set<AttackType> alertTypes) {
        this.alertingTypes = alertTypes;
    }

    public void setAttackedTypes(Set<AttackType> attackedTypes) {
        this.attackedTypes = attackedTypes;
    }

    public void setAttackingTypes(Set<AttackType> attackers) {
        this.attackeringTypes = attackers;
    }

    public void setExactLogIds(String exactLogIds) {
        this.exactLogIds = exactLogIds;
    }

    @Override
    public IpAttackEvent sumElement(List<ExceptionEvent> events) {
        long changedPackets = 0L;
        long changeKbits = 0L;
        long changedIpAttackPeakKbps = 0L;
        long changedIpAttackPeakPps = 0L;
        long changedIpInPeakKbps = 0L;
        long changedIpInPeakPps = 0L;
        long changedTcpCurConnNum = 0L;
        long changedTcpNewConnNum = 0L;
        long changedAttackPeakKbps = 0L;
        long changedAttackPeakPpsOrQps = 0L;
        long currentAttackCount = this.getAttackCount();
        String oldIds = this.getExactLogIds();
        Set<String> idSet = this.handleExcatlogId(oldIds);
        long attackCount = this.getAttackCount();
        for (ExceptionEvent event : events) {
            this.setPortData(event.getPortData());
            this.addPort(event.getPortData());
            AttackType attackType = event.getAttackType();
            this.updateTime(event);
            this.setDropPkgs(this.getDropPkgs() + event.getDropPkgs());
            this.setDropKbits(this.getDropKbits() + event.getDropKbits());
            changedPackets += event.getDropPkgs();
            changeKbits += event.getDropKbits();
            changedIpInPeakKbps = this.queryMaxValue(this.getIpInPeakKbps(), event.getIpInPeakKbps());
            changedIpInPeakPps = this.queryMaxValue(this.getIpInPeakPps(), event.getIpInPeakPps());
            changedTcpCurConnNum = this.queryMaxValue(this.getTcpCurConnNum(), event.getTcpCurConnNum());
            changedTcpNewConnNum = this.queryMaxValue(this.getTcpNewConnNum(), event.getTcpNewConnNum());
            this.setIpInPeakKbps(changedIpInPeakKbps);
            this.setIpInPeakPps(changedIpInPeakPps);
            this.setTcpCurConnNum(changedTcpCurConnNum);
            this.setTcpNewConnNum(changedTcpNewConnNum);
            if (event.getCurrentState() == 2) {
                if (!this.attackTypes.contains(attackType)) {
                    ++attackCount;
                    this.attackTypes.add(attackType);
                }
                this.attackedTypes.add(attackType);
                this.alertedTypes.add(attackType);
                this.alertingTypes.remove(attackType);
                this.setAttackCount(this.getAttackCount() + event.getAttackCount());
                this.attackeringTypes.add(attackType);
                this.addAttackers(event.getAttackers());
                changedIpAttackPeakKbps = this.queryMaxValue(this.getIpAttackPeakKbps(), event.getIpAttackPeakKbps());
                changedIpAttackPeakPps = this.queryMaxValue(this.getIpAttackPeakPps(), event.getIpAttackPeakPps());
                changedAttackPeakKbps = this.queryMaxValue(this.getAttackPeakKbps(), event.getAttackPeakKbps());
                changedAttackPeakPpsOrQps = this.queryMaxValue(this.getAttackPeakPpsOrQps(), event.getAttackPeakPpsOrQps());
                this.setIpAttackPeakKbps(changedIpAttackPeakKbps);
                this.setIpAttackPeakPps(changedIpAttackPeakPps);
                this.setAttackPeakKbps(changedAttackPeakKbps);
                this.setAttackPeakPpsOrQps(changedAttackPeakPpsOrQps);
            } else if (event.getCurrentState() == 0) {
                this.attackeringTypes.remove(attackType);
                this.alertingTypes.remove(attackType);
                this.attackTypes.remove(attackType);
                this.alertedTypes.add(attackType);
            } else {
                this.alertingTypes.add(attackType);
                this.alertedTypes.add(attackType);
                this.attackeringTypes.remove(attackType);
            }
            if (event.getAbnormalPkId() == -1L) continue;
            idSet.add(String.valueOf(event.getAbnormalPkId()));
        }
        this.updateState();
        String pkids = this.handleId2String(idSet);
        this.setAttackCount(attackCount);
        this.setExactLogIds(pkids);
        IpAttackEvent changed = this.getCopyEvent();
        changed.setAttackCount(this.getAttackCount() - currentAttackCount);
        changed.setDropPkgs(changedPackets);
        changed.setDropKbits(changeKbits);
        changed.setIpAttackPeakPps(changedIpAttackPeakPps);
        changed.setIpAttackPeakKbps(changedIpAttackPeakKbps);
        changed.setIpInPeakKbps(changedIpInPeakKbps);
        changed.setIpInPeakPps(changedIpInPeakPps);
        changed.setTcpCurConnNum(changedTcpCurConnNum);
        changed.setTcpNewConnNum(changedTcpNewConnNum);
        changed.setAttackPeakKbps(changedAttackPeakKbps);
        changed.setAttackPeakPpsOrQps(changedAttackPeakPpsOrQps);
        return changed;
    }

    private String handleId2String(Set<String> idSet) {
        if (!idSet.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            for (String id : idSet) {
                buffer.append(id);
                buffer.append(',');
            }
            String result = buffer.toString();
            return result.substring(0, result.length() - 1);
        }
        return "";
    }

    private Set<String> handleExcatlogId(String oldIds) {
        HashSet<String> idSet = new HashSet<String>();
        if (oldIds != null && !oldIds.equals("")) {
            String[] ids;
            for (String id : ids = oldIds.split(",")) {
                idSet.add(id);
            }
        }
        return idSet;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("attackedTypes", this.attackedTypes).append("attackingTypes", this.attackeringTypes).append("alertTypes", this.alertingTypes).toString();
    }

    private void updateState() {
        if (!this.attackeringTypes.isEmpty()) {
            this.setCurrentState(2);
        } else if (!this.alertingTypes.isEmpty()) {
            this.setCurrentState(1);
        } else {
            this.setCurrentState(0);
        }
    }
}

