/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.OtherBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.TotalFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.entity.event.ZoneTotalFlowEvent;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class IpLocationTotalFlowEvent
extends TotalFlowEvent {
    private long totalPps;
    private long totalKbps;
    private long tcpKbps;
    private long tcpPps;
    private long udpKbps;
    private long udpPps;
    private long icmpKbps;
    private long icmpPps;
    private long otherKbps;
    private long otherPps;
    private IpLocationTotalFlowType type = new IpLocationTotalFlowType();

    public IpLocationTotalFlowEvent(EventIdentifier identifer, boolean isDrop) {
        this(identifer);
        super.setDropFlow(isDrop);
        this.type.setDrop(isDrop);
    }

    public IpLocationTotalFlowEvent(EventIdentifier identifer) {
        super(identifer);
        this.type.setClazzName(this.getClass().getName());
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void average(int size) {
        this.setTotalPps(this.devideUp(this.totalPps, size));
        this.setTotalKbps(this.devideUp(this.totalKbps, size));
        this.setTcpPps(this.devideUp(this.getTcpPps(), size));
        this.setTcpKbps(this.devideUp(this.getTcpKbps(), size));
        this.setUdpKbps(this.devideUp(this.getUdpKbps(), size));
        this.setUdpPps(this.devideUp(this.getUdpPps(), size));
        this.setIcmpKbps(this.devideUp(this.getIcmpKbps(), size));
        this.setIcmpPps(this.devideUp(this.getIcmpPps(), size));
        this.setOtherKbps(this.devideUp(this.getOtherKbps(), size));
        this.setOtherPps(this.devideUp(this.getOtherPps(), size));
    }

    public long getIcmpKbps() {
        return this.icmpKbps;
    }

    public long getIcmpPps() {
        return this.icmpPps;
    }

    public long getOtherKbps() {
        return this.otherKbps;
    }

    public long getOtherPps() {
        return this.otherPps;
    }

    public long getTcpKbps() {
        return this.tcpKbps;
    }

    public long getTcpPps() {
        return this.tcpPps;
    }

    public long getTotalKbps() {
        return this.totalKbps;
    }

    public long getTotalPps() {
        return this.totalPps;
    }

    public long getUdpKbps() {
        return this.udpKbps;
    }

    public long getUdpPps() {
        return this.udpPps;
    }

    @Override
    public void max(Event e) {
        if (null != e && e instanceof IpLocationTotalFlowEvent) {
            IpLocationTotalFlowEvent ipLocatioinTotal = (IpLocationTotalFlowEvent)e;
            this.setTotalPps(this.getTotalPps() > ipLocatioinTotal.getTotalPps() ? this.getTotalPps() : ipLocatioinTotal.getTotalPps());
            this.setTotalKbps(this.getTotalKbps() > ipLocatioinTotal.getTotalKbps() ? this.getTotalKbps() : ipLocatioinTotal.getTotalKbps());
            this.setTcpPps(this.getTcpPps() > ipLocatioinTotal.getTcpPps() ? this.getTcpPps() : ipLocatioinTotal.getTcpPps());
            this.setTcpKbps(this.getTcpKbps() > ipLocatioinTotal.getTcpKbps() ? this.getTcpKbps() : ipLocatioinTotal.getTcpKbps());
            this.setUdpPps(this.getUdpPps() > ipLocatioinTotal.getUdpPps() ? this.getUdpPps() : ipLocatioinTotal.getUdpPps());
            this.setUdpKbps(this.getUdpKbps() > ipLocatioinTotal.getUdpKbps() ? this.getUdpKbps() : ipLocatioinTotal.getUdpKbps());
            this.setIcmpKbps(this.getIcmpKbps() > ipLocatioinTotal.getIcmpKbps() ? this.getIcmpKbps() : ipLocatioinTotal.getIcmpKbps());
            this.setIcmpPps(this.getIcmpPps() > ipLocatioinTotal.getIcmpPps() ? this.getIcmpPps() : ipLocatioinTotal.getIcmpPps());
            this.setOtherKbps(this.getOtherKbps() > ipLocatioinTotal.getOtherKbps() ? this.getOtherKbps() : ipLocatioinTotal.getOtherKbps());
            this.setOtherPps(this.getOtherPps() > ipLocatioinTotal.getOtherPps() ? this.getOtherPps() : ipLocatioinTotal.getOtherPps());
        }
    }

    protected void merge(Event event) {
        IpLocationTotalFlowEvent ipLocatioinTotal = (IpLocationTotalFlowEvent)event;
        this.setTotalPps(this.totalPps + ipLocatioinTotal.getTotalPps());
        this.setTotalKbps(this.totalKbps + ipLocatioinTotal.getTotalKbps());
        this.setTcpKbps(this.tcpKbps + ipLocatioinTotal.getTcpKbps());
        this.setTcpPps(this.tcpPps + ipLocatioinTotal.getTcpPps());
        this.setUdpKbps(this.udpKbps + ipLocatioinTotal.getUdpKbps());
        this.setUdpPps(this.udpPps + ipLocatioinTotal.getUdpPps());
        this.setIcmpKbps(this.icmpKbps + ipLocatioinTotal.getIcmpKbps());
        this.setIcmpPps(this.icmpPps + ipLocatioinTotal.getIcmpPps());
        this.setOtherKbps(this.otherKbps + ipLocatioinTotal.getOtherKbps());
        this.setOtherPps(this.otherPps + ipLocatioinTotal.getOtherPps());
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            this.merge(event);
        }
    }

    @Override
    public void mergeDiscardFlowEvent(DiscardFlowEvent discard) {
        this.setTotalPps(this.totalPps + discard.getAllPps());
        this.setTotalKbps(this.totalKbps + discard.getAllKbps());
        this.setTcpKbps(this.tcpKbps + discard.getTcpKbps());
        this.setTcpPps(this.tcpPps + discard.getTcpPps());
        this.setUdpKbps(this.udpKbps + discard.getUdpKbps());
        this.setUdpPps(this.udpPps + discard.getUdpPps());
        this.setIcmpKbps(this.icmpKbps + discard.getIcmpKbps());
        this.setIcmpPps(this.icmpPps + discard.getIcmpPps());
        this.setOtherKbps(this.otherKbps + discard.getOtherKbps());
        this.setOtherPps(this.otherPps + discard.getOtherPps());
    }

    @Override
    public void mergeInFlowEvent(InFlowEvent flowEvent) {
        this.setTotalPps(this.totalPps + flowEvent.getAllPps());
        this.setTotalKbps(this.totalKbps + flowEvent.getAllKbps());
        this.setTcpKbps(this.tcpKbps + flowEvent.getTcpKbps());
        this.setTcpPps(this.tcpPps + flowEvent.getTcpPps());
        this.setUdpKbps(this.udpKbps + flowEvent.getUdpKbps());
        this.setUdpPps(this.udpPps + flowEvent.getUdpPps());
        this.setIcmpKbps(this.icmpKbps + flowEvent.getIcmpKbps());
        this.setIcmpPps(this.icmpPps + flowEvent.getIcmpPps());
        this.setOtherKbps(this.otherKbps + flowEvent.getOtherKbps());
        this.setOtherPps(this.otherPps + flowEvent.getOtherPps());
    }

    @Override
    public void mergeZoneTotalFlowEvent(ZoneTotalFlowEvent zoneTotalFlowEvent) {
        this.setTotalPps(this.totalPps + zoneTotalFlowEvent.getAllPps());
        this.setTotalKbps(this.totalKbps + zoneTotalFlowEvent.getAllKbps());
        this.setTcpKbps(this.tcpKbps + zoneTotalFlowEvent.getTcpKbps());
        this.setTcpPps(this.tcpPps + zoneTotalFlowEvent.getTcpPps());
        this.setUdpKbps(this.udpKbps + zoneTotalFlowEvent.getUdpKbps());
        this.setUdpPps(this.udpPps + zoneTotalFlowEvent.getUdpPps());
        this.setIcmpKbps(this.icmpKbps + zoneTotalFlowEvent.getIcmpKbps());
        this.setIcmpPps(this.icmpPps + zoneTotalFlowEvent.getIcmpPps());
        this.setOtherKbps(this.otherKbps + zoneTotalFlowEvent.getOtherKbps());
        this.setOtherPps(this.otherPps + zoneTotalFlowEvent.getOtherPps());
    }

    @Override
    public void mergeTcpBizFlowEvent(TcpBizFlowEvent tcpBizFlow) {
        this.setTotalPps(this.totalPps + tcpBizFlow.getTotalPps());
        this.setTotalKbps(this.totalKbps + tcpBizFlow.getTotalKbps());
        this.setTcpKbps(this.tcpKbps + tcpBizFlow.getTotalKbps());
        this.setTcpPps(this.tcpPps + tcpBizFlow.getTotalPps());
    }

    @Override
    public void mergeUdpBizFlowEvent(UdpBizFlowEvent udpBizFlow) {
        this.setTotalPps(this.totalPps + udpBizFlow.getTotalPps());
        this.setTotalKbps(this.totalKbps + udpBizFlow.getTotalKbps());
        this.setUdpKbps(this.udpKbps + udpBizFlow.getTotalKbps());
        this.setUdpPps(this.udpPps + udpBizFlow.getTotalPps());
    }

    @Override
    public void mergeOtherBizFlowEvent(OtherBizFlowEvent otherBizFlow) {
        this.setTotalPps(this.totalPps + otherBizFlow.getTotalPps());
        this.setTotalKbps(this.totalKbps + otherBizFlow.getTotalKbps());
        this.setOtherKbps(this.otherKbps + otherBizFlow.getTotalKbps());
        this.setOtherPps(this.otherPps + otherBizFlow.getTotalPps());
    }

    @Override
    public void setDropFlow(boolean isDropFlow) {
        super.setDropFlow(isDropFlow);
        this.type.setDrop(isDropFlow);
    }

    public void setIcmpKbps(long icmpKbps) {
        this.icmpKbps = icmpKbps;
    }

    public void setIcmpPps(long icmpPps) {
        this.icmpPps = icmpPps;
    }

    public void setOtherKbps(long otherKbps) {
        this.otherKbps = otherKbps;
    }

    public void setOtherPps(long otherPps) {
        this.otherPps = otherPps;
    }

    public void setTcpKbps(long tcpKbps) {
        this.tcpKbps = tcpKbps;
    }

    public void setTcpPps(long tcpPps) {
        this.tcpPps = tcpPps;
    }

    public void setTotalKbps(long totalKbps) {
        this.totalKbps = totalKbps;
    }

    public void setTotalPps(long totalPps) {
        this.totalPps = totalPps;
    }

    public void setUdpKbps(long udpKbps) {
        this.udpKbps = udpKbps;
    }

    public void setUdpPps(long udpPps) {
        this.udpPps = udpPps;
    }

    @Override
    public String toString() {
        if (this.isValid()) {
            return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("IpLocationTotalFlowEvent is dorp flow: ", this.isIsDropFlow()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("totolPps", this.getTotalPps()).append("allBkps", this.getTcpKbps()).append("icmpKbps", this.icmpKbps).append("icmpPps", this.icmpPps).append("otherKbps", this.otherKbps).append("otherPps", this.otherPps).append("tcpKbps", this.tcpKbps).append("tcpPps", this.tcpPps).append("udpPps", this.udpPps).append("udpKbps", this.udpKbps).toString();
        }
        return "invalide flow event";
    }

    private static class IpLocationTotalFlowType
    implements Type {
        boolean isDrop;
        private String clazzName;

        private IpLocationTotalFlowType() {
        }

        public boolean equals(Object o) {
            if (o instanceof IpLocationTotalFlowType) {
                IpLocationTotalFlowType type = (IpLocationTotalFlowType)o;
                return this.isDrop == type.isIsDrop() && this.clazzName.equals(type.getClazzName());
            }
            return false;
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public int hashCode() {
            return this.isDrop ? 0 : 1 + this.clazzName.hashCode();
        }

        public boolean isIsDrop() {
            return this.isDrop;
        }

        public void setClazzName(String clazzName) {
            this.clazzName = clazzName;
        }

        public void setDrop(boolean isDrops) {
            this.isDrop = isDrops;
        }
    }
}

