/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.IpSuitEntity;
import com.hs.atic.collector.entity.event.BizEvent;
import com.hs.atic.collector.entity.event.CarEvent;
import com.hs.atic.collector.entity.event.ContentTopnEvent;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.DnsDefendEvent;
import com.hs.atic.collector.entity.event.DnsStatisEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ForwardFlowEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.entity.event.SecondFlowEvent;
import com.hs.atic.collector.entity.event.SrcTopnEvent;
import com.hs.atic.collector.entity.event.UdpDnsUserDefTypeEvent;
import com.hs.atic.collector.entity.event.ZoneBlackListEvent;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class IpSuitEvent
extends IpSuitEntity<Event> {
    public static final int NORMAL = 1;
    private static long limitPps = 2500L;
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private List<ZoneBlackListEvent> zoneBlackEvents = new ArrayList<ZoneBlackListEvent>();
    private CarEvent carEvent;
    private DiscardFlowEvent discardFlowEvent;
    private DiscardFlowEvent maxDiscardFlowEvent;
    private List<OriginalExceptionEvent> exceptionEvents = new ArrayList<OriginalExceptionEvent>();
    private InFlowEvent inFlowEvent;
    private InFlowEvent maxInFlowEvent;
    private SecondFlowEvent secondFlowEvent;
    private ForwardFlowEvent maxForwardFlowEvent;
    private Collection<Event> serviceEvents = new ArrayList<Event>();
    private List<UdpDnsUserDefTypeEvent> udpDnsTypeEvents = new ArrayList<UdpDnsUserDefTypeEvent>();
    private List<BizEvent> bizEventList = new ArrayList<BizEvent>();
    private List<DnsStatisEvent> dnsStatisEventList = new ArrayList<DnsStatisEvent>();
    private List<SrcTopnEvent> dnsSrcTopnEventList = new ArrayList<SrcTopnEvent>();
    private List<ContentTopnEvent> dnsTopnEventList = new ArrayList<ContentTopnEvent>();
    private List<DnsDefendEvent> dnsDefendEventList = new ArrayList<DnsDefendEvent>();

    public IpSuitEvent(EventIdentifier identifiers) {
        super(identifiers);
    }

    public void addBizEvent(BizEvent event) {
        this.bizEventList.add(event);
    }

    public void addDnsSrcTopnEvent(SrcTopnEvent e) {
        this.dnsSrcTopnEventList.add(e);
    }

    public void addDnsStatisEvent(DnsStatisEvent e) {
        this.dnsStatisEventList.add(e);
    }

    public void addDnsTopnEvent(ContentTopnEvent e) {
        this.dnsTopnEventList.add(e);
    }

    public void addDnsDefendEvent(DnsDefendEvent e) {
        this.dnsDefendEventList.add(e);
    }

    public void addOriginalExceptionEvent(OriginalExceptionEvent event) {
        this.exceptionEvents.add(event);
    }

    public void addServiceEvents(Event e) {
        this.serviceEvents.add(e);
    }

    public void addDnsTypeEvents(List<UdpDnsUserDefTypeEvent> events) {
        this.udpDnsTypeEvents.addAll(events);
    }

    private void adjustAttackEvent() {
        Iterator<OriginalExceptionEvent> itor = this.exceptionEvents.iterator();
        while (itor.hasNext()) {
            OriginalExceptionEvent event = itor.next();
            if (!event.isAttack()) continue;
            if (event.getDeviceType() == 1) {
                LOGGER.error((Object)("drop a attack event case it comes from a detect device. " + event));
                itor.remove();
                continue;
            }
            if (event.getAttackType().isIsDdosDrop() || !event.getIdentifier().getIsDefaultBiz().booleanValue()) continue;
            if (null == this.inFlowEvent || 0L == this.inFlowEvent.getAllPps()) {
                int dropRate = event.getDropRate();
                long dropPps = event.getDropPkgs() / 64L;
                if (dropPps * (long)dropRate >= event.getRealValue() && event.getRealValue() >= limitPps) continue;
                itor.remove();
                LOGGER.error((Object)(" i drop a global attack event case flow is lower than limitPps:" + limitPps + ". attack=" + event.toString()));
                continue;
            }
            if (this.isOverThreshold(event) && this.inFlowEvent.getAllPps() >= limitPps) continue;
            itor.remove();
            LOGGER.error((Object)(" i drop a global attack event case inFlowEvent.getAllPps is lower than limitPps:" + limitPps + ",attack=" + event.toString() + ". inFlowEvent=" + this.inFlowEvent.toString()));
        }
    }

    public Event queryServiceEvent(Class<? extends Event> cl, boolean isDrop, boolean isMax, long bizId) {
        if (null != this.serviceEvents) {
            for (Event e : this.serviceEvents) {
                if (!e.getClass().getName().equals(cl.getName()) || e.isIsDropFlow() != isDrop || e.isIsMaxEvent() != isMax || e.getBizId() != bizId) continue;
                return e;
            }
        }
        try {
            Event e;
            Constructor<? extends Event> constructor = cl.getConstructor(EventIdentifier.class);
            e = constructor.newInstance(this.getIdentifier());
            e.setDropFlow(isDrop);
            e.setMaxEvent(isMax);
            if (null != this.serviceEvents) {
                this.serviceEvents.add(e);
            }
            return e;
        }
        catch (NoSuchMethodException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public Collection<Event> getEntitys() {
        this.adjustAttackEvent();
        ArrayList<Event> events = new ArrayList<Event>();
        if (!this.exceptionEvents.isEmpty()) {
            events.addAll(this.exceptionEvents);
        }
        if (this.carEvent != null) {
            events.add(this.carEvent);
        }
        if (null != this.discardFlowEvent) {
            events.add(this.discardFlowEvent);
        }
        if (null != this.inFlowEvent) {
            events.add(this.inFlowEvent);
        }
        if (null != this.maxDiscardFlowEvent) {
            events.add(this.maxDiscardFlowEvent);
        }
        if (null != this.maxInFlowEvent) {
            events.add(this.maxInFlowEvent);
        }
        if (null != this.maxForwardFlowEvent) {
            events.add(this.maxForwardFlowEvent);
        }
        events.addAll(this.zoneBlackEvents);
        if (null != this.bizEventList) {
            events.addAll(this.bizEventList);
        }
        if (null != this.dnsStatisEventList) {
            events.addAll(this.dnsStatisEventList);
        }
        if (null != this.dnsSrcTopnEventList) {
            events.addAll(this.dnsSrcTopnEventList);
        }
        if (null != this.dnsTopnEventList) {
            events.addAll(this.dnsTopnEventList);
        }
        if (null != this.serviceEvents) {
            events.addAll(this.serviceEvents);
        }
        if (null != this.udpDnsTypeEvents) {
            events.addAll(this.udpDnsTypeEvents);
        }
        if (null != this.dnsDefendEventList) {
            events.addAll(this.dnsDefendEventList);
        }
        if (null != this.secondFlowEvent) {
            events.add(this.secondFlowEvent);
        }
        return events;
    }

    private boolean isOverThreshold(OriginalExceptionEvent event) {
        int dropRate = event.getDropRate();
        long dropPps = event.getDropPkgs() / 64L;
        return this.inFlowEvent != null && dropPps * (long)dropRate >= this.inFlowEvent.getAllPps();
    }

    public CarEvent getCarEvent() {
        return this.carEvent;
    }

    public DiscardFlowEvent getDiscardFlowEvent() {
        return this.discardFlowEvent;
    }

    public List<DnsStatisEvent> getDnsStatisEventList() {
        return this.dnsStatisEventList;
    }

    public InFlowEvent getInFlowEvent() {
        return this.inFlowEvent;
    }

    public List<OriginalExceptionEvent> getOriginalExceptionEvents() {
        return this.exceptionEvents;
    }

    public Collection<Event> getServiceEvents() {
        return this.serviceEvents;
    }

    public List<ZoneBlackListEvent> getZoneBlackEvents() {
        return this.zoneBlackEvents;
    }

    public void setCarEvent(CarEvent carEvent) {
        this.carEvent = carEvent;
    }

    public void setDiscardFlowEvent(DiscardFlowEvent discardFlowEvent) {
        this.discardFlowEvent = discardFlowEvent;
    }

    public void setDnsStatisEventList(List<DnsStatisEvent> dnsStatisEventList) {
        this.dnsStatisEventList = dnsStatisEventList;
    }

    public void setInFlowEvent(InFlowEvent inFlowEvent) {
        this.inFlowEvent = inFlowEvent;
    }

    public void setOriginalExceptionEvents(List<OriginalExceptionEvent> exceptionEvent) {
        this.exceptionEvents = exceptionEvent;
    }

    public void setServiceEvents(Collection<Event> serviceEvents) {
        this.serviceEvents = serviceEvents;
    }

    public void setZoneBlackEvents(List<ZoneBlackListEvent> zoneBlackEvents) {
        this.zoneBlackEvents = zoneBlackEvents;
    }

    public DiscardFlowEvent getMaxDiscardFlowEvent() {
        return this.maxDiscardFlowEvent;
    }

    public void setMaxDiscardFlowEvent(DiscardFlowEvent maxDiscardFlowEvent) {
        this.maxDiscardFlowEvent = maxDiscardFlowEvent;
    }

    public InFlowEvent getMaxInFlowEvent() {
        return this.maxInFlowEvent;
    }

    public void setMaxInFlowEvent(InFlowEvent maxInFlowEvent) {
        this.maxInFlowEvent = maxInFlowEvent;
    }

    public ForwardFlowEvent getMaxForwardFlowEvent() {
        return this.maxForwardFlowEvent;
    }

    public void setMaxForwardFlowEvent(ForwardFlowEvent maxForwardFlowEvent) {
        this.maxForwardFlowEvent = maxForwardFlowEvent;
    }

    public void setSecondFlowEvent(SecondFlowEvent secondFlowEvent) {
        this.secondFlowEvent = secondFlowEvent;
    }

    public boolean isFlowOverMax() {
        Boolean in = null != this.inFlowEvent && this.inFlowEvent.isFlowOverMax() || null != this.maxInFlowEvent && this.maxInFlowEvent.isFlowOverMax();
        Boolean discard = null != this.discardFlowEvent && this.discardFlowEvent.isFlowOverMax() || null != this.maxDiscardFlowEvent && this.maxDiscardFlowEvent.isFlowOverMax();
        if (in.booleanValue() || discard.booleanValue()) {
            return true;
        }
        if (null != this.serviceEvents && !this.serviceEvents.isEmpty()) {
            for (Event event : this.serviceEvents) {
                if (!event.isFlowOverMax()) continue;
                return true;
            }
        }
        return false;
    }

    static {
        try {
            limitPps = Long.parseLong(EventUtil.getEventConfigProperty("DropPpsLimit"));
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

