/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.ForwardFlowEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.OtherBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.TotalFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.util.EventUtil;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dom4j.Element;

public class IpTotalFlowEvent
extends TotalFlowEvent {
    private static final String TOTALPPS = "total_pps";
    private static final String TOTALKBPS = "total_kbps";
    private static final String TCPPPS = "tcp_pps";
    private static final String TCPKBPS = "tcp_kbps";
    private static final String TCPFRAGPPS = "tcpfrag_pps";
    private static final String TCPFRAGKBPS = "tcpfrag_kbps";
    private static final String UDPPPS = "udp_pps";
    private static final String UDPKBPS = "udp_kbps";
    private static final String UDPFRAGPPS = "udpfrag_pps";
    private static final String UDPFRAGKBPS = "udpfrag_kbps";
    private static final String ICMPPPS = "icmp_pps";
    private static final String ICMPKBPS = "icmp_kbps";
    private static final String OTHERPPS = "other_pps";
    private static final String OTHERKBPS = "other_kbps";
    private static final String SYNPPS = "syn_pps";
    private static final String SYNACKPPS = "synack_pps";
    private static final String ACKPPS = "ack_pps";
    private static final String FINRSTPPS = "finrst_pps";
    private static final String TIME = "log_time";
    private IpTotalFlowType type = new IpTotalFlowType();
    private long allPps;
    private long allKbps;
    private long tcpKbps;
    private long tcpPps;
    private long udpKbps;
    private long udpPps;
    private long icmpKbps;
    private long icmpPps;
    private long otherKbps;
    private long otherPps;
    private long httpPps;
    private long httpKbps;
    private long httpsPps;
    private long httpsKbps;
    private long dnsRequestPps;
    private long dnsRequestKbps;
    private long dnsReplyPps;
    private long dnsReplyKbps;
    private long sipInvitePps;
    private long sipInviteKbps;
    private long sipInviteQps;
    private long tcpIncreaseCon;
    private long udpIncreaseCon;
    private long icmpIncreaseCon;
    private long otherIncreaseCon;
    private long tcpConcurCon;
    private long udpConcurCon;
    private long icmpConcurCon;
    private long otherConcurCon;
    private long tcpFragKbps;
    private long tcpFragPps;
    private long udpFragKbps;
    private long udpFragPps;
    private long synPps;
    private long synAckPps;
    private long ackPps;
    private long finRstPps;
    private long allReboundPps;
    private long allReboundKbps;
    private long tcpReboundPps;
    private long tcpReboundKbps;
    private long udpReboundPps;
    private long udpReboundKbps;
    private long synReboundPps;
    private long synAckReboundPps;

    public IpTotalFlowEvent(EventIdentifier identifer) {
        super(identifer);
        this.type.setClazzName(this.getClass().getName());
    }

    public IpTotalFlowEvent(EventIdentifier identifer, boolean isDrop, boolean isForward) {
        this(identifer);
        super.setDropFlow(isDrop);
        super.setForwardFlow(isForward);
        this.type.setDrop(isDrop);
        this.type.setForward(isForward);
    }

    @Override
    public void average(int size) {
        this.setAllPps(this.devideUp(this.getAllPps(), size));
        this.setAllKbps(this.devideUp(this.getAllKbps(), size));
        this.setTcpPps(this.devideUp(this.getTcpPps(), size));
        this.setTcpKbps(this.devideUp(this.getTcpKbps(), size));
        this.setUdpPps(this.devideUp(this.getUdpPps(), size));
        this.setUdpKbps(this.devideUp(this.getUdpKbps(), size));
        this.setIcmpKbps(this.devideUp(this.getIcmpKbps(), size));
        this.setIcmpPps(this.devideUp(this.getIcmpPps(), size));
        this.setOtherKbps(this.devideUp(this.getOtherKbps(), size));
        this.setOtherPps(this.devideUp(this.getOtherPps(), size));
        this.setHttpPps(this.devideUp(this.getHttpPps(), size));
        this.setHttpKbps(this.devideUp(this.getHttpKbps(), size));
        this.setHttpsPps(this.devideUp(this.getHttpsPps(), size));
        this.setHttpsKbps(this.devideUp(this.getHttpsKbps(), size));
        this.setDnsRequestPps(this.devideUp(this.getDnsRequestPps(), size));
        this.setDnsRequestKbps(this.devideUp(this.getDnsRequestKbps(), size));
        this.setDnsReplyPps(this.devideUp(this.getDnsReplyPps(), size));
        this.setDnsReplyKbps(this.devideUp(this.getDnsReplyKbps(), size));
        this.setSipInvitePps(this.devideUp(this.getSipInvitePps(), size));
        this.setSipInviteKbps(this.devideUp(this.getSipInviteKbps(), size));
        this.setSipInviteQps(this.devideUp(this.getSipInviteQps(), size));
        this.setTcpIncreaseCon(this.devideUp(this.getTcpIncreaseCon(), size));
        this.setTcpConcurCon(this.devideUp(this.getTcpConcurCon(), size));
        this.setUdpIncreaseCon(this.devideUp(this.getUdpIncreaseCon(), size));
        this.setUdpConcurCon(this.devideUp(this.getUdpConcurCon(), size));
        this.setIcmpIncreaseCon(this.devideUp(this.getIcmpIncreaseCon(), size));
        this.setIcmpConcurCon(this.devideUp(this.getIcmpConcurCon(), size));
        this.setOtherIncreaseCon(this.devideUp(this.getOtherIncreaseCon(), size));
        this.setOtherConcurCon(this.devideUp(this.getOtherConcurCon(), size));
        this.setTcpFragPps(this.devideUp(this.getTcpFragPps(), size));
        this.setTcpFragKbps(this.devideUp(this.getTcpFragKbps(), size));
        this.setUdpFragPps(this.devideUp(this.getUdpFragPps(), size));
        this.setUdpFragKbps(this.devideUp(this.getUdpFragKbps(), size));
        this.setSynPps(this.devideUp(this.getSynPps(), size));
        this.setSynAckPps(this.devideUp(this.getSynAckPps(), size));
        this.setAckPps(this.devideUp(this.getAckPps(), size));
        this.setFinRstPps(this.devideUp(this.getFinRstPps(), size));
        this.setAllReboundPps(this.devideUp(this.allReboundPps, size));
        this.setAllReboundKbps(this.devideUp(this.allReboundKbps, size));
        this.setTcpReboundPps(this.devideUp(this.tcpReboundPps, size));
        this.setTcpReboundKbps(this.devideUp(this.tcpReboundKbps, size));
        this.setUdpReboundPps(this.devideUp(this.udpReboundPps, size));
        this.setUdpReboundKbps(this.devideUp(this.udpReboundKbps, size));
        this.setSynReboundPps(this.devideUp(this.synReboundPps, size));
        this.setSynAckReboundPps(this.devideUp(this.synAckReboundPps, size));
    }

    public long getAckPps() {
        return this.ackPps;
    }

    public long getAllKbps() {
        return this.allKbps;
    }

    public long getAllPps() {
        return this.allPps;
    }

    public long getDnsReplyKbps() {
        return this.dnsReplyKbps;
    }

    public long getDnsReplyPps() {
        return this.dnsReplyPps;
    }

    public long getDnsRequestKbps() {
        return this.dnsRequestKbps;
    }

    public long getDnsRequestPps() {
        return this.dnsRequestPps;
    }

    public long getFinRstPps() {
        return this.finRstPps;
    }

    public long getHttpKbps() {
        return this.httpKbps;
    }

    public long getHttpPps() {
        return this.httpPps;
    }

    public long getHttpsKbps() {
        return this.httpsKbps;
    }

    public long getHttpsPps() {
        return this.httpsPps;
    }

    public long getIcmpConcurCon() {
        return this.icmpConcurCon;
    }

    public long getIcmpIncreaseCon() {
        return this.icmpIncreaseCon;
    }

    public long getIcmpKbps() {
        return this.icmpKbps;
    }

    public long getIcmpPps() {
        return this.icmpPps;
    }

    public long getOtherConcurCon() {
        return this.otherConcurCon;
    }

    public long getOtherIncreaseCon() {
        return this.otherIncreaseCon;
    }

    public long getOtherKbps() {
        return this.otherKbps;
    }

    public long getOtherPps() {
        return this.otherPps;
    }

    public long getSipInviteKbps() {
        return this.sipInviteKbps;
    }

    public long getSipInvitePps() {
        return this.sipInvitePps;
    }

    public long getSynAckPps() {
        return this.synAckPps;
    }

    public long getSynPps() {
        return this.synPps;
    }

    @Override
    public List<String> getSysLogInfo() {
        List<String> info = super.getSysLogInfo();
        info.add("total_pps=" + this.getAllPps());
        info.add("total_kbps=" + this.getAllPps());
        info.add("tcp_pps=" + this.getTcpPps());
        info.add("tcp_kbps=" + this.getTcpKbps());
        info.add("tcpfrag_pps=" + this.getTcpPps());
        info.add("tcpfrag_kbps=" + this.getTcpKbps());
        info.add("udp_pps=" + this.getUdpPps());
        info.add("udp_kbps=" + this.getUdpKbps());
        info.add("udpfrag_pps=" + this.getUdpFragPps());
        info.add("udpfrag_kbps=" + this.getUdpFragKbps());
        info.add("icmp_pps=" + this.getIcmpPps());
        info.add("icmp_kbps=" + this.getIcmpKbps());
        info.add("other_pps=" + this.getOtherPps());
        info.add("other_kbps=" + this.getOtherKbps());
        info.add("syn_pps=" + this.getSynPps());
        info.add("synack_pps=" + this.getSynAckPps());
        info.add("ack_pps=" + this.getAckPps());
        info.add("finrst_pps=" + this.getFinRstPps());
        return info;
    }

    public long getTcpConcurCon() {
        return this.tcpConcurCon;
    }

    public long getTcpFragKbps() {
        return this.tcpFragKbps;
    }

    public long getTcpFragPps() {
        return this.tcpFragPps;
    }

    public long getTcpIncreaseCon() {
        return this.tcpIncreaseCon;
    }

    public long getTcpKbps() {
        return this.tcpKbps;
    }

    public long getTcpPps() {
        return this.tcpPps;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public long getUdpConcurCon() {
        return this.udpConcurCon;
    }

    public long getUdpFragKbps() {
        return this.udpFragKbps;
    }

    public long getUdpFragPps() {
        return this.udpFragPps;
    }

    public long getUdpIncreaseCon() {
        return this.udpIncreaseCon;
    }

    public long getUdpKbps() {
        return this.udpKbps;
    }

    public long getUdpPps() {
        return this.udpPps;
    }

    @Override
    public void max(Event e) {
        if (null != e && e instanceof IpTotalFlowEvent) {
            IpTotalFlowEvent iptotal = (IpTotalFlowEvent)e;
            this.setAllPps(this.getAllPps() > iptotal.getAllPps() ? this.getAllPps() : iptotal.getAllPps());
            this.setAllKbps(this.getAllKbps() > iptotal.getAllKbps() ? this.getAllKbps() : iptotal.getAllKbps());
            this.setTcpPps(this.getTcpPps() > iptotal.getTcpPps() ? this.getTcpPps() : iptotal.getTcpPps());
            this.setTcpKbps(this.getTcpKbps() > iptotal.getTcpKbps() ? this.getTcpKbps() : iptotal.getTcpKbps());
            this.setUdpPps(this.getUdpPps() > iptotal.getUdpPps() ? this.getUdpPps() : iptotal.getUdpPps());
            this.setUdpKbps(this.getUdpKbps() > iptotal.getUdpKbps() ? this.getUdpKbps() : iptotal.getUdpKbps());
            this.setIcmpPps(this.getIcmpPps() > iptotal.getIcmpPps() ? this.getIcmpPps() : iptotal.getIcmpPps());
            this.setIcmpKbps(this.getIcmpKbps() > iptotal.getIcmpKbps() ? this.getIcmpKbps() : iptotal.getIcmpKbps());
            this.setOtherPps(this.getOtherPps() > iptotal.getOtherPps() ? this.getOtherPps() : iptotal.getOtherPps());
            this.setOtherKbps(this.getOtherKbps() > iptotal.getOtherKbps() ? this.getOtherKbps() : iptotal.getOtherKbps());
            this.setHttpPps(this.getHttpPps() > iptotal.getHttpPps() ? this.getHttpPps() : iptotal.getHttpPps());
            this.setHttpKbps(this.getHttpKbps() > iptotal.getHttpKbps() ? this.getHttpKbps() : iptotal.getHttpKbps());
            this.setHttpsPps(this.getHttpsPps() > iptotal.getHttpsPps() ? this.getHttpsPps() : iptotal.getHttpsPps());
            this.setHttpsKbps(this.getHttpsKbps() > iptotal.getHttpsKbps() ? this.getHttpsKbps() : iptotal.getHttpsKbps());
            this.setDnsRequestPps(this.getDnsRequestPps() > iptotal.getDnsRequestPps() ? this.getDnsRequestPps() : iptotal.getDnsRequestPps());
            this.setDnsRequestKbps(this.getDnsRequestKbps() > iptotal.getDnsRequestKbps() ? this.getDnsRequestKbps() : iptotal.getDnsRequestKbps());
            this.setDnsReplyPps(this.getDnsReplyPps() > iptotal.getDnsReplyPps() ? this.getDnsReplyPps() : iptotal.getDnsReplyPps());
            this.setDnsReplyKbps(this.getDnsReplyKbps() > iptotal.getDnsReplyKbps() ? this.getDnsReplyKbps() : iptotal.getDnsReplyKbps());
            this.setSipInvitePps(this.getSipInvitePps() > iptotal.getSipInvitePps() ? this.getSipInvitePps() : iptotal.getSipInvitePps());
            this.setSipInviteKbps(this.getSipInviteKbps() > iptotal.getSipInviteKbps() ? this.getSipInviteKbps() : iptotal.getSipInviteKbps());
            this.setSipInviteQps(this.getSipInviteQps() > iptotal.getSipInviteQps() ? this.getSipInviteQps() : iptotal.getSipInviteQps());
            this.setTcpIncreaseCon(this.getTcpIncreaseCon() > iptotal.getTcpIncreaseCon() ? this.getTcpIncreaseCon() : iptotal.getTcpIncreaseCon());
            this.setUdpIncreaseCon(this.getUdpIncreaseCon() > iptotal.getUdpIncreaseCon() ? this.getUdpIncreaseCon() : iptotal.getUdpIncreaseCon());
            this.setIcmpIncreaseCon(this.getIcmpIncreaseCon() > iptotal.getIcmpIncreaseCon() ? this.getIcmpIncreaseCon() : iptotal.getIcmpIncreaseCon());
            this.setOtherIncreaseCon(this.getOtherIncreaseCon() > iptotal.getOtherIncreaseCon() ? this.getOtherIncreaseCon() : iptotal.getOtherIncreaseCon());
            this.setTcpConcurCon(this.getTcpConcurCon() > iptotal.getTcpConcurCon() ? this.getTcpConcurCon() : iptotal.getTcpConcurCon());
            this.setUdpConcurCon(this.getUdpConcurCon() > iptotal.getUdpConcurCon() ? this.getUdpConcurCon() : iptotal.getUdpConcurCon());
            this.setIcmpConcurCon(this.getIcmpConcurCon() > iptotal.getIcmpConcurCon() ? this.getIcmpConcurCon() : iptotal.getIcmpConcurCon());
            this.setOtherConcurCon(this.getOtherConcurCon() > iptotal.getOtherConcurCon() ? this.getOtherConcurCon() : iptotal.getOtherConcurCon());
            this.setTcpFragPps(this.getTcpFragPps() > iptotal.getTcpFragPps() ? this.getTcpFragPps() : iptotal.getTcpFragPps());
            this.setTcpFragKbps(this.getTcpFragKbps() > iptotal.getTcpFragKbps() ? this.getTcpFragKbps() : iptotal.getTcpFragKbps());
            this.setUdpFragPps(this.getUdpFragPps() > iptotal.getUdpFragPps() ? this.getUdpFragPps() : iptotal.getUdpFragPps());
            this.setUdpFragKbps(this.getUdpFragKbps() > iptotal.getUdpFragKbps() ? this.getUdpFragKbps() : iptotal.getUdpFragKbps());
            this.setSynPps(this.getSynPps() > iptotal.getSynPps() ? this.getSynPps() : iptotal.getSynPps());
            this.setSynAckPps(this.getSynAckPps() > iptotal.getSynAckPps() ? this.getSynAckPps() : iptotal.getSynAckPps());
            this.setAckPps(this.getAckPps() > iptotal.getAckPps() ? this.getAckPps() : iptotal.getAckPps());
            this.setFinRstPps(this.getFinRstPps() > iptotal.getFinRstPps() ? this.getFinRstPps() : iptotal.getFinRstPps());
            this.setAllReboundPps(this.allReboundPps > iptotal.allReboundPps ? this.allReboundPps : iptotal.allReboundPps);
            this.setAllReboundKbps(this.allReboundKbps > iptotal.allReboundKbps ? this.allReboundKbps : iptotal.allReboundKbps);
            this.setTcpReboundPps(this.tcpReboundPps > iptotal.tcpReboundPps ? this.tcpReboundPps : iptotal.tcpReboundPps);
            this.setTcpReboundKbps(this.tcpReboundKbps > iptotal.tcpReboundKbps ? this.tcpReboundKbps : iptotal.tcpReboundKbps);
            this.setUdpReboundPps(this.udpReboundPps > iptotal.udpReboundPps ? this.udpReboundPps : iptotal.udpReboundPps);
            this.setUdpReboundKbps(this.udpReboundKbps > iptotal.udpReboundKbps ? this.udpReboundKbps : iptotal.udpReboundKbps);
            this.setSynReboundPps(this.synReboundPps > iptotal.synReboundPps ? this.synReboundPps : iptotal.synReboundPps);
            this.setSynAckReboundPps(this.synAckReboundPps > iptotal.synAckReboundPps ? this.synAckReboundPps : iptotal.synAckReboundPps);
        }
    }

    protected void merge(Event event) {
        IpTotalFlowEvent ipTotal = (IpTotalFlowEvent)event;
        this.setAllPps(this.allPps + ipTotal.getAllPps());
        this.setAllKbps(this.allKbps + ipTotal.getAllKbps());
        this.setTcpPps(this.tcpPps + ipTotal.getTcpPps());
        this.setTcpKbps(this.tcpKbps + ipTotal.getTcpKbps());
        this.setUdpPps(this.udpPps + ipTotal.getUdpPps());
        this.setUdpKbps(this.udpKbps + ipTotal.getUdpKbps());
        this.setIcmpPps(this.icmpPps + ipTotal.getIcmpPps());
        this.setIcmpKbps(this.icmpKbps + ipTotal.getIcmpKbps());
        this.setOtherPps(this.otherPps + ipTotal.getOtherPps());
        this.setOtherKbps(this.otherKbps + ipTotal.getOtherKbps());
        this.setHttpPps(this.httpPps + ipTotal.getHttpPps());
        this.setHttpKbps(this.httpKbps + ipTotal.getHttpKbps());
        this.setHttpsPps(this.httpsPps + ipTotal.getHttpsPps());
        this.setHttpsKbps(this.httpsKbps + ipTotal.getHttpsKbps());
        this.setDnsRequestPps(this.dnsRequestPps + ipTotal.getDnsRequestPps());
        this.setDnsRequestKbps(this.dnsRequestKbps + ipTotal.getDnsRequestKbps());
        this.setDnsReplyPps(this.dnsReplyPps + ipTotal.getDnsReplyPps());
        this.setDnsReplyKbps(this.dnsReplyKbps + ipTotal.getDnsReplyKbps());
        this.setSipInvitePps(this.sipInvitePps + ipTotal.getSipInvitePps());
        this.setSipInviteKbps(this.sipInviteKbps + ipTotal.getSipInviteKbps());
        this.setSipInviteQps(this.sipInviteQps + ipTotal.getSipInviteQps());
        this.setTcpIncreaseCon(this.tcpIncreaseCon + ipTotal.getTcpIncreaseCon());
        this.setUdpIncreaseCon(this.udpIncreaseCon + ipTotal.getUdpIncreaseCon());
        this.setIcmpIncreaseCon(this.icmpIncreaseCon + ipTotal.getIcmpIncreaseCon());
        this.setOtherIncreaseCon(this.otherIncreaseCon + ipTotal.getOtherIncreaseCon());
        this.setTcpConcurCon(this.tcpConcurCon + ipTotal.getTcpConcurCon());
        this.setUdpConcurCon(this.udpConcurCon + ipTotal.getUdpConcurCon());
        this.setIcmpConcurCon(this.icmpConcurCon + ipTotal.getIcmpConcurCon());
        this.setOtherConcurCon(this.otherConcurCon + ipTotal.getOtherConcurCon());
        this.setTcpFragPps(this.tcpFragPps + ipTotal.getTcpFragPps());
        this.setTcpFragKbps(this.tcpFragKbps + ipTotal.getTcpFragKbps());
        this.setUdpFragPps(this.udpFragPps + ipTotal.getUdpFragPps());
        this.setUdpFragKbps(this.udpFragKbps + ipTotal.getUdpFragKbps());
        this.setSynPps(this.synPps + ipTotal.getSynPps());
        this.setSynAckPps(this.synAckPps + ipTotal.getSynAckPps());
        this.setAckPps(this.ackPps + ipTotal.getAckPps());
        this.setFinRstPps(this.finRstPps + ipTotal.getFinRstPps());
        this.setAllReboundPps(this.allReboundPps + ipTotal.allReboundPps);
        this.setAllReboundKbps(this.allReboundKbps + ipTotal.allReboundKbps);
        this.setTcpReboundPps(this.tcpReboundPps + ipTotal.tcpReboundPps);
        this.setTcpReboundKbps(this.tcpReboundKbps + ipTotal.tcpReboundKbps);
        this.setUdpReboundPps(this.udpReboundPps + ipTotal.udpReboundPps);
        this.setUdpReboundKbps(this.udpReboundKbps + ipTotal.udpReboundKbps);
        this.setSynReboundPps(this.synReboundPps + ipTotal.synReboundPps);
        this.setSynAckReboundPps(this.synAckReboundPps + ipTotal.synAckReboundPps);
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            this.merge(event);
        }
    }

    @Override
    public void mergeDiscardFlowEvent(DiscardFlowEvent discardFlow) {
        this.setAllPps(this.allPps + discardFlow.getAllPps());
        this.setAllKbps(this.allKbps + discardFlow.getAllKbps());
        this.setTcpPps(this.tcpPps + discardFlow.getTcpPps());
        this.setTcpKbps(this.tcpKbps + discardFlow.getTcpKbps());
        this.setUdpPps(this.udpPps + discardFlow.getUdpPps());
        this.setUdpKbps(this.udpKbps + discardFlow.getUdpKbps());
        this.setIcmpPps(this.icmpPps + discardFlow.getIcmpPps());
        this.setIcmpKbps(this.icmpKbps + discardFlow.getIcmpKbps());
        this.setOtherPps(this.otherPps + discardFlow.getOtherPps());
        this.setOtherKbps(this.otherKbps + discardFlow.getOtherKbps());
        this.setHttpPps(this.httpPps + discardFlow.getHttpPps());
        this.setHttpKbps(this.httpKbps + discardFlow.getHttpKbps());
        this.setHttpsPps(this.httpsPps + discardFlow.getHttpsPps());
        this.setHttpsKbps(this.httpsKbps + discardFlow.getHttpsKbps());
        this.setDnsRequestPps(this.dnsRequestPps + discardFlow.getDnsRequestPps());
        this.setDnsRequestKbps(this.dnsRequestKbps + discardFlow.getDnsRequestKbps());
        this.setDnsReplyPps(this.dnsReplyPps + discardFlow.getDnsReplyPps());
        this.setDnsReplyKbps(this.dnsReplyKbps + discardFlow.getDnsReplyKbps());
        this.setSipInvitePps(this.sipInvitePps + discardFlow.getSipInvitePps());
        this.setSipInviteKbps(this.sipInviteKbps + discardFlow.getSipInviteKbps());
        this.setSipInviteQps(this.sipInviteQps + discardFlow.getSipInviteQps());
        this.setTcpFragPps(this.tcpFragPps + discardFlow.getTcpFragPps());
        this.setTcpFragKbps(this.tcpFragKbps + discardFlow.getTcpFragKbps());
        this.setUdpFragPps(this.udpFragPps + discardFlow.getUdpFragPps());
        this.setUdpFragKbps(this.udpFragKbps + discardFlow.getUdpFragKbps());
        this.setSynPps(this.synPps + discardFlow.getSynPps());
        this.setSynAckPps(this.synAckPps + discardFlow.getSynAckPps());
        this.setAckPps(this.ackPps + discardFlow.getAckPps());
        this.setFinRstPps(this.finRstPps + discardFlow.getFinRstPps());
        this.setAllReboundPps(this.allReboundPps + discardFlow.getAllReboundPps());
        this.setAllReboundKbps(this.allReboundKbps + discardFlow.getAllReboundKbps());
        this.setTcpReboundPps(this.tcpReboundPps + discardFlow.getTcpReboundPps());
        this.setTcpReboundKbps(this.tcpReboundKbps + discardFlow.getTcpReboundKbps());
        this.setUdpReboundPps(this.udpReboundPps + discardFlow.getUdpReboundPps());
        this.setUdpReboundKbps(this.udpReboundKbps + discardFlow.getUdpReboundKbps());
        this.setSynReboundPps(this.synReboundPps + discardFlow.getSynReboundPps());
        this.setSynAckReboundPps(this.synAckReboundPps + discardFlow.getSynAckReboundPps());
    }

    @Override
    public void mergeInFlowEvent(InFlowEvent inFlow) {
        this.setAllPps(this.allPps + inFlow.getAllPps());
        this.setAllKbps(this.allKbps + inFlow.getAllKbps());
        this.setTcpPps(this.tcpPps + inFlow.getTcpPps());
        this.setTcpKbps(this.tcpKbps + inFlow.getTcpKbps());
        this.setUdpPps(this.udpPps + inFlow.getUdpPps());
        this.setUdpKbps(this.udpKbps + inFlow.getUdpKbps());
        this.setIcmpPps(this.icmpPps + inFlow.getIcmpPps());
        this.setIcmpKbps(this.icmpKbps + inFlow.getIcmpKbps());
        this.setOtherPps(this.otherPps + inFlow.getOtherPps());
        this.setOtherKbps(this.otherKbps + inFlow.getOtherKbps());
        this.setHttpPps(this.httpPps + inFlow.getHttpPps());
        this.setHttpKbps(this.httpKbps + inFlow.getHttpKbps());
        this.setHttpsPps(this.httpsPps + inFlow.getHttpsPps());
        this.setHttpsKbps(this.httpsKbps + inFlow.getHttpsKbps());
        this.setDnsRequestPps(this.dnsRequestPps + inFlow.getDnsRequestPps());
        this.setDnsRequestKbps(this.dnsRequestKbps + inFlow.getDnsRequestKbps());
        this.setDnsReplyPps(this.dnsReplyPps + inFlow.getDnsReplyPps());
        this.setDnsReplyKbps(this.dnsReplyKbps + inFlow.getDnsReplyKbps());
        this.setSipInvitePps(this.sipInvitePps + inFlow.getSipInvitePps());
        this.setSipInviteKbps(this.sipInviteKbps + inFlow.getSipInviteKbps());
        this.setSipInviteQps(this.sipInviteQps + inFlow.getSipInviteQps());
        this.setTcpIncreaseCon(this.tcpIncreaseCon + inFlow.getTcpIncreaseCon());
        this.setUdpIncreaseCon(this.udpIncreaseCon + inFlow.getUdpIncreaseCon());
        this.setIcmpIncreaseCon(this.icmpIncreaseCon + inFlow.getIcmpIncreaseCon());
        this.setOtherIncreaseCon(this.otherIncreaseCon + inFlow.getOtherIncreaseCon());
        this.setTcpConcurCon(this.tcpConcurCon + inFlow.getTcpConcurCon());
        this.setUdpConcurCon(this.udpConcurCon + inFlow.getUdpConcurCon());
        this.setIcmpConcurCon(this.icmpConcurCon + inFlow.getIcmpConcurCon());
        this.setOtherConcurCon(this.otherConcurCon + inFlow.getOtherConcurCon());
        this.setTcpFragPps(this.tcpFragPps + inFlow.getTcpFragPps());
        this.setTcpFragKbps(this.tcpFragKbps + inFlow.getTcpFragKbps());
        this.setUdpFragPps(this.udpFragPps + inFlow.getUdpFragPps());
        this.setUdpFragKbps(this.udpFragKbps + inFlow.getUdpFragKbps());
        this.setSynPps(this.synPps + inFlow.getSynPps());
        this.setSynAckPps(this.synAckPps + inFlow.getSynAckPps());
        this.setAckPps(this.ackPps + inFlow.getAckPps());
        this.setFinRstPps(this.finRstPps + inFlow.getFinRstPps());
    }

    public void mergeForwardFlowEvent(ForwardFlowEvent forwardFlow) {
        this.setAllPps(this.allPps + forwardFlow.getAllPps());
        this.setAllKbps(this.allKbps + forwardFlow.getAllKbps());
        this.setTcpPps(this.tcpPps + forwardFlow.getTcpPps());
        this.setTcpKbps(this.tcpKbps + forwardFlow.getTcpKbps());
        this.setUdpPps(this.udpPps + forwardFlow.getUdpPps());
        this.setUdpKbps(this.udpKbps + forwardFlow.getUdpKbps());
        this.setIcmpPps(this.icmpPps + forwardFlow.getIcmpPps());
        this.setIcmpKbps(this.icmpKbps + forwardFlow.getIcmpKbps());
        this.setOtherPps(this.otherPps + forwardFlow.getOtherPps());
        this.setOtherKbps(this.otherKbps + forwardFlow.getOtherKbps());
        this.setHttpPps(this.httpPps + forwardFlow.getHttpPps());
        this.setHttpKbps(this.httpKbps + forwardFlow.getHttpKbps());
        this.setHttpsPps(this.httpsPps + forwardFlow.getHttpsPps());
        this.setHttpsKbps(this.httpsKbps + forwardFlow.getHttpsKbps());
        this.setDnsRequestPps(this.dnsRequestPps + forwardFlow.getDnsRequestPps());
        this.setDnsRequestKbps(this.dnsRequestKbps + forwardFlow.getDnsRequestKbps());
        this.setDnsReplyPps(this.dnsReplyPps + forwardFlow.getDnsReplyPps());
        this.setDnsReplyKbps(this.dnsReplyKbps + forwardFlow.getDnsReplyKbps());
        this.setSipInvitePps(this.sipInvitePps + forwardFlow.getSipInvitePps());
        this.setSipInviteKbps(this.sipInviteKbps + forwardFlow.getSipInviteKbps());
        this.setSipInviteQps(this.sipInviteQps + forwardFlow.getSipInviteQps());
        this.setTcpFragPps(this.tcpFragPps + forwardFlow.getTcpFragPps());
        this.setTcpFragKbps(this.tcpFragKbps + forwardFlow.getTcpFragKbps());
        this.setUdpFragPps(this.udpFragPps + forwardFlow.getUdpFragPps());
        this.setUdpFragKbps(this.udpFragKbps + forwardFlow.getUdpFragKbps());
        this.setSynPps(this.synPps + forwardFlow.getSynPps());
        this.setSynAckPps(this.synAckPps + forwardFlow.getSynAckPps());
        this.setAckPps(this.ackPps + forwardFlow.getAckPps());
        this.setFinRstPps(this.finRstPps + forwardFlow.getFinRstPps());
    }

    @Override
    public void mergeTcpBizFlowEvent(TcpBizFlowEvent tcpBizFlow) {
        this.setAllKbps(this.allKbps + tcpBizFlow.getTotalKbps());
        this.setAllPps(this.allPps + tcpBizFlow.getTotalPps());
        this.setTcpPps(this.tcpPps + tcpBizFlow.getTotalPps());
        this.setTcpKbps(this.tcpKbps + tcpBizFlow.getTotalKbps());
        this.setSynPps(this.synPps + tcpBizFlow.getSynPps());
        this.setAckPps(this.ackPps + tcpBizFlow.getAckPps());
        this.setSynAckPps(this.synAckPps + tcpBizFlow.getSynAckPps());
        this.setFinRstPps(this.finRstPps + tcpBizFlow.getFinRstPps());
        this.setTcpIncreaseCon(this.tcpIncreaseCon + tcpBizFlow.getIncreaseConPps());
        this.setTcpConcurCon(this.tcpConcurCon + tcpBizFlow.getCurConPps());
        this.setAllReboundPps(this.allReboundPps + tcpBizFlow.getTotalReboundPps());
        this.setAllReboundKbps(this.allReboundKbps + tcpBizFlow.getTotalReboundKbps());
        this.setTcpReboundPps(this.tcpReboundPps + tcpBizFlow.getTotalReboundPps());
        this.setTcpReboundKbps(this.tcpReboundKbps + tcpBizFlow.getTotalReboundKbps());
        this.setSynReboundPps(this.synReboundPps + tcpBizFlow.getSynReboundPps());
        this.setSynAckReboundPps(this.synAckReboundPps + tcpBizFlow.getSynAckReboundPps());
    }

    @Override
    public void mergeUdpBizFlowEvent(UdpBizFlowEvent udpBizFlow) {
        this.setAllKbps(this.allKbps + udpBizFlow.getTotalKbps());
        this.setAllPps(this.allPps + udpBizFlow.getTotalPps());
        this.setUdpKbps(this.udpKbps + udpBizFlow.getTotalKbps());
        this.setUdpPps(this.udpPps + udpBizFlow.getTotalPps());
        this.setUdpConcurCon(this.udpConcurCon + udpBizFlow.getCurConPps());
        this.setUdpIncreaseCon(this.udpIncreaseCon + udpBizFlow.getIncreaseConPps());
        this.setAllReboundPps(this.allReboundPps + udpBizFlow.getTotalReboundPps());
        this.setAllReboundKbps(this.allReboundKbps + udpBizFlow.getTotalReboundKbps());
        this.setUdpReboundPps(this.udpReboundPps + udpBizFlow.getTotalReboundPps());
        this.setUdpReboundKbps(this.udpReboundKbps + udpBizFlow.getTotalReboundKbps());
    }

    @Override
    public void mergeOtherBizFlowEvent(OtherBizFlowEvent otherBizFlow) {
        this.setAllKbps(this.allKbps + otherBizFlow.getTotalKbps());
        this.setAllPps(this.allPps + otherBizFlow.getTotalPps());
        this.setOtherKbps(this.otherKbps + otherBizFlow.getTotalKbps());
        this.setOtherPps(this.otherPps + otherBizFlow.getTotalPps());
    }

    public void setAckPps(long ackPps) {
        this.ackPps = ackPps;
    }

    public void setAllKbps(long allKbps) {
        this.allKbps = allKbps;
    }

    public void setAllPps(long allPps) {
        this.allPps = allPps;
    }

    public void setDnsReplyKbps(long dnsReplyKbps) {
        this.dnsReplyKbps = dnsReplyKbps;
    }

    public void setDnsReplyPps(long dnsReplyPps) {
        this.dnsReplyPps = dnsReplyPps;
    }

    public void setDnsRequestKbps(long dnsRequestKbps) {
        this.dnsRequestKbps = dnsRequestKbps;
    }

    public void setDnsRequestPps(long dnsRequestPps) {
        this.dnsRequestPps = dnsRequestPps;
    }

    @Override
    public void setDropFlow(boolean isDropFlow) {
        super.setDropFlow(isDropFlow);
        this.type.setDrop(isDropFlow);
    }

    @Override
    public void setForwardFlow(boolean isForwardFlow) {
        super.setForwardFlow(isForwardFlow);
        this.type.setForward(isForwardFlow);
    }

    public void setFinRstPps(long finPps) {
        this.finRstPps = finPps;
    }

    public void setHttpKbps(long httpKbps) {
        this.httpKbps = httpKbps;
    }

    public void setHttpPps(long httpPps) {
        this.httpPps = httpPps;
    }

    public void setHttpsKbps(long httpsKbps) {
        this.httpsKbps = httpsKbps;
    }

    public void setHttpsPps(long httpsPps) {
        this.httpsPps = httpsPps;
    }

    public void setIcmpConcurCon(long icmpConcurCon) {
        this.icmpConcurCon = icmpConcurCon;
    }

    public void setIcmpIncreaseCon(long icmpIncreaseCon) {
        this.icmpIncreaseCon = icmpIncreaseCon;
    }

    public void setIcmpKbps(long icmpKbps) {
        this.icmpKbps = icmpKbps;
    }

    public void setIcmpPps(long icmpPps) {
        this.icmpPps = icmpPps;
    }

    public void setOtherConcurCon(long otherConcurCon) {
        this.otherConcurCon = otherConcurCon;
    }

    public void setOtherIncreaseCon(long otherIncreaseCon) {
        this.otherIncreaseCon = otherIncreaseCon;
    }

    public void setOtherKbps(long otherKbps) {
        this.otherKbps = otherKbps;
    }

    public void setOtherPps(long otherPps) {
        this.otherPps = otherPps;
    }

    public void setSipInviteKbps(long sipInviteKbps) {
        this.sipInviteKbps = sipInviteKbps;
    }

    public void setSipInvitePps(long sipInvitePps) {
        this.sipInvitePps = sipInvitePps;
    }

    public void setSynAckPps(long synAckPps) {
        this.synAckPps = synAckPps;
    }

    public void setSynPps(long synPps) {
        this.synPps = synPps;
    }

    public void setTcpConcurCon(long tcpConcurCon) {
        this.tcpConcurCon = tcpConcurCon;
    }

    public void setTcpFragKbps(long tcpFragKbps) {
        this.tcpFragKbps = tcpFragKbps;
    }

    public void setTcpFragPps(long tcpFragPps) {
        this.tcpFragPps = tcpFragPps;
    }

    public void setTcpIncreaseCon(long tcpIncreaseCon) {
        this.tcpIncreaseCon = tcpIncreaseCon;
    }

    public void setTcpKbps(long tcpKbps) {
        this.tcpKbps = tcpKbps;
    }

    public void setTcpPps(long tcpPps) {
        this.tcpPps = tcpPps;
    }

    public void setUdpConcurCon(long udpConcurCon) {
        this.udpConcurCon = udpConcurCon;
    }

    public void setUdpFragKbps(long udpFragKbps) {
        this.udpFragKbps = udpFragKbps;
    }

    public void setUdpFragPps(long udpFragPps) {
        this.udpFragPps = udpFragPps;
    }

    public void setUdpIncreaseCon(long udpIncreaseCon) {
        this.udpIncreaseCon = udpIncreaseCon;
    }

    public void setUdpKbps(long udpKbps) {
        this.udpKbps = udpKbps;
    }

    public void setUdpPps(long udpPps) {
        this.udpPps = udpPps;
    }

    public long getAllReboundPps() {
        return this.allReboundPps;
    }

    public void setAllReboundPps(long allReboundPps) {
        this.allReboundPps = allReboundPps;
    }

    public long getAllReboundKbps() {
        return this.allReboundKbps;
    }

    public void setAllReboundKbps(long allReboundKbps) {
        this.allReboundKbps = allReboundKbps;
    }

    public long getTcpReboundPps() {
        return this.tcpReboundPps;
    }

    public void setTcpReboundPps(long tcpReboundPps) {
        this.tcpReboundPps = tcpReboundPps;
    }

    public long getTcpReboundKbps() {
        return this.tcpReboundKbps;
    }

    public void setTcpReboundKbps(long tcpReboundKbps) {
        this.tcpReboundKbps = tcpReboundKbps;
    }

    public long getUdpReboundPps() {
        return this.udpReboundPps;
    }

    public void setUdpReboundPps(long udpReboundPps) {
        this.udpReboundPps = udpReboundPps;
    }

    public long getUdpReboundKbps() {
        return this.udpReboundKbps;
    }

    public void setUdpReboundKbps(long udpReboundKbps) {
        this.udpReboundKbps = udpReboundKbps;
    }

    public long getSynReboundPps() {
        return this.synReboundPps;
    }

    public void setSynReboundPps(long synReboundPps) {
        this.synReboundPps = synReboundPps;
    }

    public long getSynAckReboundPps() {
        return this.synAckReboundPps;
    }

    public void setSynAckReboundPps(long synAckReboundPps) {
        this.synAckReboundPps = synAckReboundPps;
    }

    @Override
    public String toString() {
        if (this.isValid()) {
            return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("is dorp flow: ", this.isIsDropFlow()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("totolPps", this.getAllPps()).append("totolKbps", this.getAllKbps()).append("tcpKbps", this.tcpKbps).append("tcpPps", this.tcpPps).append("udpPps", this.udpPps).append("udpKbps", this.udpKbps).append("icmpKbps", this.icmpKbps).append("icmpPps", this.icmpPps).append("otherKbps", this.otherKbps).append("otherPps", this.otherPps).append("tcpFragPps", this.tcpFragPps).append("tcpFragKbps", this.tcpFragKbps).append("udpFragPps", this.udpFragPps).append("udpFragKbps", this.udpFragKbps).append("ack", this.ackPps).append("finRst", this.finRstPps).append("syn", this.synPps).append("synack", this.synAckPps).append("tcpIncreaseCon", this.tcpIncreaseCon).append("tcpConcurCon", this.tcpConcurCon).append("udpConcurCon", this.udpConcurCon).append("udpIncreaseCon", this.udpIncreaseCon).append("icmpIncreaseCon", this.icmpIncreaseCon).append("icmpConcurCon", this.icmpConcurCon).append("otherIncreaseCon", this.otherIncreaseCon).append("otherConcurCon", this.otherConcurCon).append("allReboundPps", this.allReboundPps).append("allReboundKbps", this.allReboundKbps).append("tcpReboundPps", this.tcpReboundPps).append("tcpReboundKbps", this.tcpReboundKbps).append("udpReboundPps", this.udpReboundPps).append("udpReboundKbps", this.udpReboundKbps).append("synReboundPps", this.synReboundPps).append("synAckReboundPps", this.synAckReboundPps).toString();
        }
        return "invalide flow event";
    }

    public void toXml(Element element) {
        element.addAttribute(TIME, EventUtil.getTimeStamp(this.getLogTime()));
        element.addAttribute(TOTALPPS, this.getAllPps() + "");
        element.addAttribute(TOTALKBPS, this.getAllKbps() + "");
        element.addAttribute(TCPKBPS, this.getTcpKbps() + "");
        element.addAttribute(TCPPPS, this.getTcpPps() + "");
        element.addAttribute(TCPFRAGKBPS, this.getTcpFragKbps() + "");
        element.addAttribute(TCPFRAGPPS, this.getTcpFragPps() + "");
        element.addAttribute(UDPKBPS, this.getUdpKbps() + "");
        element.addAttribute(UDPPPS, this.getUdpPps() + "");
        element.addAttribute(UDPFRAGKBPS, this.getUdpFragKbps() + "");
        element.addAttribute(UDPFRAGPPS, this.getUdpFragPps() + "");
        element.addAttribute(ICMPKBPS, this.getIcmpKbps() + "");
        element.addAttribute(ICMPPPS, this.getIcmpPps() + "");
        element.addAttribute(OTHERPPS, this.getOtherPps() + "");
        element.addAttribute(OTHERKBPS, this.getOtherKbps() + "");
        element.addAttribute(SYNPPS, this.getSynAckPps() + "");
        element.addAttribute(SYNACKPPS, this.getSynAckPps() + "");
        element.addAttribute(ACKPPS, this.getAckPps() + "");
        element.addAttribute(FINRSTPPS, this.getFinRstPps() + "");
    }

    public long getSipInviteQps() {
        return this.sipInviteQps;
    }

    public void setSipInviteQps(long sipInviteQps) {
        this.sipInviteQps = sipInviteQps;
    }

    private static class IpTotalFlowType
    implements Type {
        boolean isDrop;
        boolean isForward;
        private String clazzName;

        private IpTotalFlowType() {
        }

        public boolean equals(Object o) {
            if (o instanceof IpTotalFlowType) {
                IpTotalFlowType type = (IpTotalFlowType)o;
                return this.isDrop == type.isIsDrop() && this.isForward == type.isIsForward() && this.clazzName.equals(type.getClazzName());
            }
            return false;
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public int hashCode() {
            int result = 0;
            result += 17 * (this.isDrop ? 0 : 1);
            result += 19 * (this.isForward ? 0 : 1);
            return result += this.clazzName.hashCode();
        }

        public boolean isIsDrop() {
            return this.isDrop;
        }

        public boolean isIsForward() {
            return this.isForward;
        }

        public void setClazzName(String clazzName) {
            this.clazzName = clazzName;
        }

        public void setDrop(boolean isDrops) {
            this.isDrop = isDrops;
        }

        public void setForward(boolean isForwards) {
            this.isForward = isForwards;
        }
    }
}

