/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.FirstPageEvent;
import com.hs.atic.collector.entity.event.xml.ToXml;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.EventUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dom4j.Element;

public class OtherBizFlowEvent
extends Event
implements ToXml,
FirstPageEvent {
    private static final String TIME = "LOG_TIME";
    private static final String TOTAL_PPS = "TOTAL_PPS";
    private static final String TOTAL_KBPS = "TOTAL_KBPS";
    private static final String TYPE = "TYPE";
    private static final String TYPE_VALUE = "OTHER";
    private static final String BIZ_ID = "BIZ_ID";
    private static final String IS_DROP = "IS_DROP";
    protected OtherBizFlowType type = new OtherBizFlowType();
    private long totalPps;
    private long totalKbps;

    public OtherBizFlowEvent(EventIdentifier identifer) {
        super(identifer);
        this.type.setClazzName(this.getClass().getName());
    }

    @Override
    public void average(int size) {
        this.setTotalKbps(this.devideUp(this.totalKbps, size));
        this.setTotalPps(this.devideUp(this.totalPps, size));
    }

    @Override
    public boolean isFlowOverMax() {
        return super.isFlowOverMax() || this.totalKbps > (long)CommonUtil.getAticFlowMaxNum() || this.totalPps > (long)CommonUtil.getAticFlowMaxNum();
    }

    @Override
    public long getTotalKbps() {
        return this.totalKbps;
    }

    @Override
    public long getTotalPps() {
        return this.totalPps;
    }

    @Override
    public void max(Event e) {
        if (null != e && e instanceof OtherBizFlowEvent) {
            OtherBizFlowEvent event = (OtherBizFlowEvent)e;
            this.setTotalPps(this.getTotalPps() > event.getTotalPps() ? this.getTotalPps() : event.getTotalPps());
            this.setTotalKbps(this.getTotalKbps() > event.getTotalKbps() ? this.getTotalKbps() : event.getTotalKbps());
        }
    }

    @Override
    public boolean isLess(Event t) {
        if (t instanceof OtherBizFlowEvent) {
            OtherBizFlowEvent event = (OtherBizFlowEvent)t;
            return this.totalPps < event.totalPps || this.totalKbps < event.totalKbps;
        }
        return false;
    }

    protected void merge(Event e) {
        OtherBizFlowEvent event = (OtherBizFlowEvent)e;
        this.setTotalPps(this.totalPps + event.getTotalPps());
        this.setTotalKbps(this.totalKbps + event.getTotalKbps());
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            this.merge(event);
        }
    }

    @Override
    public void setDropFlow(boolean isDropFlow) {
        super.setDropFlow(isDropFlow);
        this.type.setDrop(isDropFlow);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setTotalKbps(long totalKbps) {
        this.totalKbps = totalKbps;
    }

    public void setTotalPps(long totalPps) {
        this.totalPps = totalPps;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("is dorp flow: ", this.isIsDropFlow()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("totalPps: ", this.totalPps).append("totalKbps: ", this.totalKbps).toString();
    }

    public void toXmlLoTime(Element element) {
        element.addAttribute(TIME, EventUtil.getTimeStamp(this.getLogTime()));
    }

    private void toXmlType(Element element) {
        element.addAttribute(TYPE, TYPE_VALUE);
    }

    public void toXmlEntity(Element element) {
        element.addAttribute(BIZ_ID, this.getIdentifier().getBizId() + "");
        element.addAttribute(IS_DROP, String.valueOf(this.isIsDropFlow()));
        element.addAttribute(TOTAL_PPS, this.getTotalPps() + "");
        element.addAttribute(TOTAL_KBPS, this.getTotalKbps() + "");
    }

    @Override
    public void toXml(Element element) {
        this.toXmlLoTime(element);
        this.toXmlType(element);
        this.toXmlEntity(element);
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("log_type=other_biz");
        info.addAll(this.getSysLogEntry());
        return info;
    }

    public List<String> getSysLogEntry() {
        ArrayList<String> info = new ArrayList<String>();
        info.addAll(super.getSysLogInfo());
        info.add("is_drop=" + this.isIsDropFlow());
        info.add("total_pps=" + this.totalPps);
        info.add("total_kbps=" + this.totalKbps);
        return info;
    }

    @Override
    public long getCurrConn() {
        return 0L;
    }

    @Override
    public long getNewConn() {
        return 0L;
    }

    @Override
    public OtherBizFlowEvent getCopyEvent() {
        OtherBizFlowEvent copy = (OtherBizFlowEvent)super.getCopyEvent();
        return copy;
    }

    @Override
    public OtherBizFlowEvent getFlowCopyEvent() {
        OtherBizFlowEvent copy = new OtherBizFlowEvent(this.getIdentifierCopy());
        copy.setDropFlow(this.isIsDropFlow());
        copy.setMaxEvent(this.isIsMaxEvent());
        copy.setHourEvent(this.isIsHourEvent());
        copy.setNeedSum(this.isNeedSum());
        copy.merge(this);
        return copy;
    }

    private static class OtherBizFlowType
    implements Type {
        boolean isDrop;
        private String clazzName;

        private OtherBizFlowType() {
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public void setClazzName(String clazzName) {
            this.clazzName = clazzName;
        }

        public boolean isIsDrop() {
            return this.isDrop;
        }

        public void setDrop(boolean isDrops) {
            this.isDrop = isDrops;
        }

        public boolean equals(Object o) {
            if (o instanceof OtherBizFlowType) {
                OtherBizFlowType type = (OtherBizFlowType)o;
                return this.isDrop == type.isIsDrop() && this.clazzName.equals(type.getClazzName());
            }
            return false;
        }

        public int hashCode() {
            return this.isDrop ? 0 : 1 + this.clazzName.hashCode();
        }
    }
}

