/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.dom4j.Element;

public class SipBizFlowEvent
extends UdpBizFlowEvent {
    private static final String INVITE_PPS = "INVITE_PPS";
    private static final String REPLY_PPS = "REPLY_PPS";
    private static final String TYPE = "TYPE";
    private static final String TYPE_VALUE = "SIP";
    private long invitePps;
    private long replyPps;

    public SipBizFlowEvent(EventIdentifier identifer) {
        super(identifer);
    }

    @Override
    public void average(int size) {
        super.average(size);
        this.setInvitePps(this.devideUp(this.invitePps, size));
        this.setReplyPps(this.devideUp(this.replyPps, size));
    }

    public long getInvitePps() {
        return this.invitePps;
    }

    public long getReplyPps() {
        return this.replyPps;
    }

    @Override
    public void merge(Event e) {
        if (null != e && e instanceof SipBizFlowEvent) {
            SipBizFlowEvent event = (SipBizFlowEvent)e;
            super.merge(event);
            this.setInvitePps(this.invitePps + event.getInvitePps());
            this.setReplyPps(this.replyPps + event.getReplyPps());
        }
    }

    @Override
    public void max(Event e) {
        if (null != e && e instanceof SipBizFlowEvent) {
            SipBizFlowEvent event = (SipBizFlowEvent)e;
            super.max(event);
            this.setInvitePps(this.getInvitePps() > event.getInvitePps() ? this.getInvitePps() : event.getInvitePps());
            this.setReplyPps(this.getReplyPps() > event.getReplyPps() ? this.getReplyPps() : event.getReplyPps());
        }
    }

    @Override
    public boolean isLess(Event t) {
        if (t instanceof SipBizFlowEvent) {
            SipBizFlowEvent event = (SipBizFlowEvent)t;
            return super.isLess(t) || this.invitePps < event.invitePps || this.replyPps < event.replyPps;
        }
        return false;
    }

    public void setInvitePps(long invitePps) {
        this.invitePps = invitePps;
    }

    public void setReplyPps(long replyPps) {
        this.replyPps = replyPps;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("is dorp flow: ", this.isIsDropFlow()).append("is hour event: ", this.isIsHourEvent()).append("is max event: ", this.isIsMaxEvent()).append("invitePps: ", this.invitePps).append("replyPps: ", this.replyPps).toString();
    }

    @Override
    public void toXml(Element element) {
        super.toXmlLoTime(element);
        element.addAttribute(TYPE, TYPE_VALUE);
        super.toXmlEntity(element);
        element.addAttribute(INVITE_PPS, this.getInvitePps() + "");
        element.addAttribute(REPLY_PPS, this.getReplyPps() + "");
    }

    @Override
    public List<String> getSysLogInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("log_type=sip_biz");
        info.addAll(this.getSysLogEntry());
        info.add("invite_pps=" + this.invitePps);
        info.add("reply_pps=" + this.replyPps);
        return info;
    }

    @Override
    public boolean isFlowOverMax() {
        return super.isFlowOverMax() || this.invitePps > (long)CommonUtil.getAticFlowMaxNum() || this.replyPps > (long)CommonUtil.getAticFlowMaxNum();
    }

    @Override
    public SipBizFlowEvent getCopyEvent() {
        SipBizFlowEvent copy = (SipBizFlowEvent)super.getCopyEvent();
        return copy;
    }

    @Override
    public SipBizFlowEvent getFlowCopyEvent() {
        SipBizFlowEvent copy = new SipBizFlowEvent(this.getIdentifierCopy());
        copy.setDropFlow(this.isIsDropFlow());
        copy.setMaxEvent(this.isIsMaxEvent());
        copy.setHourEvent(this.isIsHourEvent());
        copy.setNeedSum(this.isNeedSum());
        copy.merge(this);
        return copy;
    }
}

