/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.FlowEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.OtherBizFlowEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import java.util.ArrayList;
import java.util.List;

public class SumMinFlowEvent
extends Event {
    public static final String SUM_TYPE_IP = "IP";
    public static final String SUM_TYPE_ZONE = "ZONE";
    public static final String SUM_TYPE_DEVICE = "DEVICE";
    private String sumType;
    private FlowEvent inFlowEvent;
    private FlowEvent inFlowMax;
    private FlowEvent dropFlowEvent;
    private FlowEvent dropFlowMax;

    public SumMinFlowEvent(EventIdentifier identifer) {
        super(identifer);
        this.setInFlowEvent(new FlowEvent(identifer));
        this.setInFlowMax(new FlowEvent(identifer));
        this.setDropFlowEvent(new FlowEvent(identifer));
        this.setDropFlowMax(new FlowEvent(identifer));
    }

    @Override
    public void average(int number) {
        this.inFlowEvent.average(number);
        this.dropFlowEvent.average(number);
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            SumMinFlowEvent event2 = (SumMinFlowEvent)event;
            this.inFlowEvent.merge(event2.getInFlowEvent());
            this.inFlowMax.merge(event2.getInFlowMax());
            this.dropFlowEvent.merge(event2.getDropFlowEvent());
            this.dropFlowMax.merge(event2.getDropFlowMax());
        }
    }

    public void sumElement(List<Event> eventList) {
        for (Event event : eventList) {
            if (event.isIsMaxEvent()) {
                if (event.isIsDropFlow()) {
                    this.mergeTypeEvent(this.dropFlowMax, event);
                    continue;
                }
                this.mergeTypeEvent(this.inFlowMax, event);
                continue;
            }
            if (event.isIsDropFlow()) {
                this.mergeTypeEvent(this.dropFlowEvent, event);
                continue;
            }
            this.mergeTypeEvent(this.inFlowEvent, event);
        }
    }

    private void mergeTypeEvent(FlowEvent totalEvent, Event event) {
        ArrayList<Event> list = new ArrayList<Event>();
        list.add(event);
        if (event instanceof InFlowEvent || event instanceof DiscardFlowEvent) {
            totalEvent.merge(list);
        } else if (event instanceof TcpBizFlowEvent) {
            totalEvent.mergeTcpBizFlowEvent((TcpBizFlowEvent)event);
        } else if (event instanceof UdpBizFlowEvent) {
            totalEvent.mergeUdpBizFlowEvent((UdpBizFlowEvent)event);
        } else if (event instanceof OtherBizFlowEvent) {
            totalEvent.mergeOtherBizFlowEvent((OtherBizFlowEvent)event);
        }
    }

    public String getSumType() {
        return this.sumType;
    }

    public void setSumType(String sumType) {
        this.sumType = sumType;
    }

    public FlowEvent getInFlowEvent() {
        return this.inFlowEvent;
    }

    public void setInFlowEvent(FlowEvent inFlow) {
        this.inFlowEvent = inFlow;
    }

    public FlowEvent getInFlowMax() {
        return this.inFlowMax;
    }

    public void setInFlowMax(FlowEvent inMaxFlow) {
        this.inFlowMax = inMaxFlow;
    }

    public FlowEvent getDropFlowEvent() {
        return this.dropFlowEvent;
    }

    public void setDropFlowEvent(FlowEvent dropFlow) {
        this.dropFlowEvent = dropFlow;
    }

    public FlowEvent getDropFlowMax() {
        return this.dropFlowMax;
    }

    public void setDropFlowMax(FlowEvent dropMaxFlow) {
        this.dropFlowMax = dropMaxFlow;
    }
}

