/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.SysLogHeader;
import com.hs.atic.collector.entity.event.ToSysLog;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.log4j.Logger;

public class SysLog {
    private static final Logger LOGGER = LogManager.getInstance().getSysLogLogger();
    private static final String SEPRATOR = " ";
    private List<String> content;
    private SysLogHeader header = SysLogHeader.getInstance();
    private String hostName;
    private String timeStamp;
    private byte[] sysLogInfoBytes = new byte[0];

    public SysLog() {
    }

    public SysLog(ToSysLog info) {
        this.content = info.getSysLogInfo();
        this.hostName = info.getHostName();
        this.timeStamp = EventUtil.getTimeStamp(System.currentTimeMillis());
    }

    public List<String> getContent() {
        return this.content;
    }

    public SysLogHeader getHeader() {
        return this.header;
    }

    public String getHostName() {
        return this.hostName;
    }

    public byte[] getSyslogBytes() {
        if (this.sysLogInfoBytes.length == 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getHeader().getPreFix());
            buffer.append(this.getTimeStamp());
            buffer.append(SEPRATOR);
            buffer.append(this.getHostName());
            buffer.append(SEPRATOR);
            buffer.append(this.getHeader().getFlag());
            buffer.append(this.getHeader().getVersion());
            buffer.append(this.getHeader().getModelName());
            buffer.append(this.getHeader().getLogLevel());
            buffer.append(this.getHeader().getDescriptor());
            buffer.append(this.getHeader().getLogType());
            buffer.append(':');
            for (String each : this.content) {
                buffer.append(each);
                buffer.append(SEPRATOR);
            }
            try {
                this.sysLogInfoBytes = buffer.toString().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)("buffer.toString().getBytes is error:" + e));
            }
        }
        if (this.sysLogInfoBytes.length != 0) {
            return (byte[])this.sysLogInfoBytes.clone();
        }
        return new byte[0];
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setContent(List<String> content) {
        this.content = content;
    }

    public void setHeader(SysLogHeader header) {
        this.header = header;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String toString() {
        try {
            return new String(this.getSyslogBytes(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("toString is error:" + e));
            return "";
        }
    }

    public boolean isSecondFlowSyslog() {
        return "log_type=ip_flow_seconds".equals(this.getContent().get(0));
    }
}

