/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.event.SysLog;
import com.hs.atic.collector.util.LogManager;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;

public class ThirdPartLogServer {
    private static final Logger LOGGER = LogManager.getInstance().getSysLogLogger();
    private String ip;
    private int port = 514;
    private boolean isReachable = true;
    private DatagramSocket socket;

    public ThirdPartLogServer(String ip) {
        this.ip = ip;
    }

    public ThirdPartLogServer(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ThirdPartLogServer) {
            ThirdPartLogServer server = (ThirdPartLogServer)o;
            return server.getIp().equals(this.ip);
        }
        return false;
    }

    public String getIp() {
        return this.ip;
    }

    public int hashCode() {
        return this.ip.hashCode();
    }

    public void sendSyslog(SysLog log) {
        try {
            this.initSocket();
            this.socket.send(this.getPacket(log));
            LOGGER.info((Object)"send sys log succeed.log:");
        }
        catch (IOException e) {
            this.isReachable = false;
            LOGGER.error((Object)"send sys log error", (Throwable)e);
        }
    }

    public boolean isIsReachable() {
        return this.isReachable;
    }

    public void setReachable(boolean isReachables) {
        this.isReachable = isReachables;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("ip", (Object)this.ip).append("socket", (Object)this.socket).toString();
    }

    private DatagramPacket getPacket(SysLog log) throws IOException {
        byte[] content = log.getSyslogBytes();
        DatagramPacket packet = new DatagramPacket(content, content.length, InetAddress.getByName(this.ip), this.port);
        return packet;
    }

    private void initSocket() throws IOException {
        if (this.socket == null) {
            this.socket = new DatagramSocket();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

