/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event;

import com.hs.atic.collector.entity.BlackListData;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.util.EventUtil;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ZoneBlackListEvent
extends Event {
    private static final long DEFAULT_BLACKLIST_TIME_OUT = 5400001L;
    private static long timeOutPeroid;
    private int reason;
    private int enable;
    private int protocol;
    private int blackListType;
    private int port;
    private int status;
    private String blackIp;
    private boolean invalid;
    private int blackListMode;
    private long endTime;

    public ZoneBlackListEvent(EventIdentifier identifer) {
        super(identifer);
        identifer.setZoneType();
    }

    public boolean isTimeOut() {
        return System.currentTimeMillis() - this.getLogTime() >= timeOutPeroid;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public int getBlackListMode() {
        return this.blackListMode;
    }

    public void setBlackListMode(int blackListMode) {
        this.blackListMode = blackListMode;
    }

    @Override
    public void average(int number) {
    }

    public boolean equals(Object o) {
        if (o instanceof ZoneBlackListEvent) {
            ZoneBlackListEvent event = (ZoneBlackListEvent)o;
            return this.getZoneId() == event.getZoneId() && this.getBlackIp().equals(event.getBlackIp()) && this.getDeviceIp().equals(event.getDeviceIp()) && this.getPort() == event.getPort() && this.getProtocol() == event.getProtocol();
        }
        return false;
    }

    public String getBlackIp() {
        return this.blackIp;
    }

    public int getBlackListType() {
        return this.blackListType;
    }

    public int getEnable() {
        return this.enable;
    }

    public int getPort() {
        return this.port;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int getReason() {
        return this.reason;
    }

    public int getStatus() {
        return this.status;
    }

    public int hashCode() {
        int result = 17;
        result += 19 * this.getDeviceIp().hashCode();
        result += 19 * this.blackIp.hashCode();
        result += 19 * this.port;
        result += 19 * (int)(this.getZoneId() ^ this.getZoneId() >>> 32);
        return result += 19 * this.getProtocol();
    }

    @Override
    public void merge(List<? extends Event> events) {
        for (Event event : events) {
            ZoneBlackListEvent each = (ZoneBlackListEvent)event;
            this.setStatus(each.getStatus());
            int blackListTypes = each.getBlackListType();
            this.setBlackListType(blackListTypes);
            int eventStatus = each.getStatus();
            if (eventStatus == 1 || eventStatus == 6) {
                this.setEnable(2);
                continue;
            }
            if (eventStatus != 3) continue;
            this.setEnable(1);
        }
    }

    public void setBlackIp(String blackIp) {
        this.blackIp = blackIp;
    }

    public void setBlackListType(int blackListType) {
        this.blackListType = blackListType;
    }

    public void setEnable(int enable) {
        this.enable = enable;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public void setReason(int reason) {
        this.reason = reason;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).appendSuper("super").append("zoneId", this.getZoneId()).append("blackIp", (Object)this.getBlackIp()).append("type", this.getBlackListType()).append("port", this.getPort()).append("status", this.getStatus()).append("protocol", this.protocol).append("blackListMode", this.blackListMode).toString();
    }

    public boolean isSameBlacklist(BlackListData event) {
        if (null == event) {
            return false;
        }
        return this.getZoneId() == event.getZoneId().longValue() && this.getBlackIp().equals(event.getBlackIp()) && this.getDeviceIp().equals(event.getDeviceIp()) && (long)this.getPort() == event.getPort() && (long)this.getProtocol() == event.getProtocol();
    }

    static {
        try {
            timeOutPeroid = Long.parseLong(EventUtil.getEventConfigProperty("BlacklistTimeOut"));
        }
        catch (Exception e) {
            timeOutPeroid = 5400001L;
        }
    }
}

