/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event.xml;

import com.hs.atic.collector.util.LogManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public final class XmlGenerator {
    private static final String XML_POSTFIX = ".xml";
    private static final String XML_PREFIX = "report";
    private static XmlGenerator generator = new XmlGenerator();
    private String directory = "xml";
    private Logger logger = LogManager.getInstance().getXmlLogger();

    private XmlGenerator() {
    }

    public static XmlGenerator getInstance() {
        return generator;
    }

    public static String getTimeStamp(long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HH_mm");
        return dateFormat.format(new Date(time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generatorFile(Document document) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("utf-8");
        String fileName = this.directory + File.separator + XML_PREFIX + XmlGenerator.getTimeStamp(System.currentTimeMillis()) + XML_POSTFIX;
        File file = new File(fileName);
        XMLWriter writer = null;
        this.logger.info((Object)"begin generate xml file");
        try {
            writer = new XMLWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"), format);
            writer.write(document);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("write file secess ,file name is " + file.getName()));
            }
            String string = file.getCanonicalPath();
            return string;
        }
        catch (IOException e) {
            this.logger.error((Object)"when write file ,error happend", (Throwable)e);
        }
        finally {
            this.logger.info((Object)"end generate xml file");
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)"when close file ,error happend", (Throwable)e);
                }
            }
        }
        return null;
    }
}

