/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.event.xml;

import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.DiscardFlowEvent;
import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.ExceptionEvent;
import com.hs.atic.collector.entity.event.InFlowEvent;
import com.hs.atic.collector.entity.event.TcpBizFlowEvent;
import com.hs.atic.collector.entity.event.UdpBizFlowEvent;
import com.hs.atic.collector.entity.event.xml.ToXml;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class XmlZoneIpBlock
implements ToXml {
    private static final String ZONEIP_ATTRIBUTE = "ip";
    private static final String INFLOW_TAG = "Flow";
    private static final String DISCARD_TAG = "DROP";
    private static final String ATTACK_TAG = "EVENT";
    private static final String SERVICE_TAG = "SERVICE";
    private Map<Type, ExceptionEvent> exceptionEvents = new HashMap<Type, ExceptionEvent>();
    private InFlowEvent inFlow;
    private DiscardFlowEvent discard;
    private String zoneIp;
    private List<ToXml> bizFlows = new ArrayList<ToXml>();

    public XmlZoneIpBlock(List<Event> events) {
        if (!events.isEmpty()) {
            this.zoneIp = events.get(0).getZoneIp();
        }
        for (Event each : events) {
            Event event;
            if (each instanceof InFlowEvent) {
                event = (InFlowEvent)each;
                this.inFlow = event;
                continue;
            }
            if (each instanceof DiscardFlowEvent) {
                event = (DiscardFlowEvent)each;
                this.discard = event;
                continue;
            }
            if (each instanceof ExceptionEvent) {
                event = (ExceptionEvent)each;
                this.exceptionEvents.put(((ExceptionEvent)event).getType(), (ExceptionEvent)event);
                continue;
            }
            if (!(each instanceof ToXml)) continue;
            this.bizFlows.add((ToXml)((Object)each));
        }
    }

    public boolean isValid() {
        return !this.exceptionEvents.isEmpty();
    }

    @Override
    public void toXml(Element zoneIps) {
        Element e;
        zoneIps.addAttribute(ZONEIP_ATTRIBUTE, this.zoneIp);
        if (this.inFlow != null && this.inFlow.isValid()) {
            Element inElement = zoneIps.addElement(INFLOW_TAG);
            this.inFlow.toXml(inElement);
        }
        if (this.discard != null && this.discard.isValid()) {
            Element discardElement = zoneIps.addElement(DISCARD_TAG);
            this.discard.toXml(discardElement);
        }
        Iterator<ToXml> it = this.bizFlows.iterator();
        while (it.hasNext()) {
            ToXml xml = it.next();
            if (xml instanceof TcpBizFlowEvent || xml instanceof UdpBizFlowEvent) continue;
            e = zoneIps.addElement(SERVICE_TAG);
            xml.toXml(e);
            it.remove();
        }
        for (ToXml t : this.bizFlows) {
            if (!(t instanceof TcpBizFlowEvent) && !(t instanceof UdpBizFlowEvent)) continue;
            e = zoneIps.addElement(SERVICE_TAG);
            t.toXml(e);
        }
        for (ExceptionEvent event : this.exceptionEvents.values()) {
            Element attackElement = zoneIps.addElement(ATTACK_TAG);
            event.toXml(attackElement);
        }
    }
}

