/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.log;

import com.hs.atic.collector.entity.log.BizTypePoJo;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.ParamCheckUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataStatCondition
implements Serializable {
    protected static final Logger LOGGER = LogManager.getInstance().getReportLogger();
    private static final long serialVersionUID = -4619713184571603830L;
    private boolean isDefZone = false;
    private int direction;
    private Long deviceId;
    private String deviceIp;
    private Long zoneId;
    private Long bisId;
    private String zoneIp;
    private Long startTime;
    private Long endTime;
    private String bisType;
    private Long sessionId;
    private List<Long> zoneIdList;
    private Integer protocol;
    private Integer unit;
    private Integer topn;
    private Integer isClean;
    private Integer appType;
    private Integer port;
    private Integer devSerType;
    private Integer abnormalType;
    private Integer startRow;
    private Integer limit;
    private Integer attackType;
    private List<String> deviceIpList;
    private List<String> requestTrendType;
    private List<String> attackTypeKey;
    private List<String> attackTypeValue;
    private Boolean isServiceGroup;
    private Map<String, List<Long>> serviceIds;
    private Integer botId;
    private String botType;
    private String souceIp;
    private String descIp;
    private String domain;
    private String schedule;
    private List<BizTypePoJo> bizTypeList4App;
    private Map<String, List<BizTypePoJo>> bizTypeMap4AppDevice;
    private Integer topnType;
    private boolean portalQuery;
    private Long dropPacket;
    private long dropByte;
    private boolean showDropPacket;
    private Long minInFlow;
    private Long minAttackFlowPeak;
    private Integer timeSpanType;
    private String statisticalDimension = "-1";

    public boolean isPortalQuery() {
        return this.portalQuery;
    }

    public void setPortalQuery(boolean portalQuery) {
        this.portalQuery = portalQuery;
    }

    public List<BizTypePoJo> getBizTypeList4App() {
        return this.bizTypeList4App;
    }

    public void setBizTypeList4App(List<BizTypePoJo> bizTypeList4App) {
        this.bizTypeList4App = bizTypeList4App;
    }

    public Map<String, List<Long>> getServiceIds() {
        return this.serviceIds;
    }

    public void setServiceIds(Map<String, List<Long>> serviceIds) {
        this.serviceIds = serviceIds;
    }

    public Boolean getIsServiceGroup() {
        return this.isServiceGroup;
    }

    public void setIsServiceGroup(Boolean isServiceGroup) {
        this.isServiceGroup = isServiceGroup;
    }

    public List<String> getAttackTypeKey() {
        return this.attackTypeKey;
    }

    public void setAttackTypeKey(List<String> attackTypeKey) {
        this.attackTypeKey = attackTypeKey;
    }

    public List<String> getAttackTypeValue() {
        return this.attackTypeValue;
    }

    public void setAttackTypeValue(List<String> attackTypeValue) {
        this.attackTypeValue = attackTypeValue;
    }

    public List<String> getRequestTrendType() {
        return this.requestTrendType;
    }

    public void setRequestTrendType(List<String> requestTrendType) {
        this.requestTrendType = requestTrendType;
    }

    public Long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Long sessionId) {
        this.sessionId = sessionId;
    }

    public List<Long> getZoneIdList() {
        return this.zoneIdList;
    }

    public void setZoneIdList(List<Long> zoneIdList) {
        this.zoneIdList = zoneIdList;
    }

    public Integer getAttackType() {
        return this.attackType;
    }

    public void setAttackType(Integer attackType) {
        this.attackType = attackType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Long getZoneIdForCollector() {
        if (this.zoneId != null) {
            if (this.isDefZone) {
                return 1L;
            }
            return this.zoneId;
        }
        return null;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Integer getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Integer protocol) {
        this.protocol = protocol;
    }

    public Integer getUnit() {
        return this.unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public Integer getTopn() {
        return this.topn;
    }

    public void setTopn(Integer topn) {
        this.topn = topn;
    }

    public Integer getAppType() {
        return this.appType;
    }

    public void setAppType(Integer appType) {
        this.appType = appType;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public Integer getIsClean() {
        return this.isClean;
    }

    public void setIsClean(Integer isClean) {
        this.isClean = isClean;
    }

    public String getZoneIp() {
        return this.zoneIp;
    }

    public void setZoneIp(String zoneIp) {
        this.zoneIp = zoneIp;
    }

    public Integer getStartRow() {
        return this.startRow;
    }

    public void setStartRow(Integer startRow) {
        this.startRow = startRow;
    }

    public Integer getDevSerType() {
        return this.devSerType;
    }

    public void setDevSerType(Integer devSerType) {
        this.devSerType = devSerType;
    }

    public Integer getAbnormalType() {
        return this.abnormalType;
    }

    public void setAbnormalType(Integer abnormalType) {
        this.abnormalType = abnormalType;
    }

    public boolean isDefaultZone() {
        return this.isDefZone;
    }

    public void setDefaultZone(boolean isDefaultZone) {
        this.isDefZone = isDefaultZone;
    }

    public Long getBisId() {
        return this.bisId;
    }

    public void setBisId(Long bisId) {
        this.bisId = bisId;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public String getBisType() {
        return this.bisType;
    }

    public void setBisType(String bisType) {
        this.bisType = bisType;
    }

    public List<String> getDeviceIpList() {
        return this.deviceIpList;
    }

    public void setDeviceIpList(List<String> deviceIpList) {
        this.deviceIpList = deviceIpList;
    }

    public Integer getBotId() {
        return this.botId;
    }

    public void setBotId(Integer botId) {
        this.botId = botId;
    }

    public String getBotType() {
        return this.botType;
    }

    public void setBotType(String botType) {
        this.botType = botType;
    }

    public String getSouceIp() {
        return this.souceIp;
    }

    public void setSouceIp(String souceIp) {
        this.souceIp = souceIp;
    }

    public String getDescIp() {
        return this.descIp;
    }

    public void setDescIp(String descIp) {
        this.descIp = descIp;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public Integer getTopnType() {
        return this.topnType;
    }

    public Map<String, List<BizTypePoJo>> getBizTypeMap4AppDevice() {
        return this.bizTypeMap4AppDevice;
    }

    public void setBizTypeMap4AppDevice(Map<String, List<BizTypePoJo>> bizTypeMap4AppDevice) {
        this.bizTypeMap4AppDevice = bizTypeMap4AppDevice;
    }

    public void setTopnType(Integer topnType) {
        this.topnType = topnType;
    }

    public Long getDropPacket() {
        return this.dropPacket;
    }

    public void setDropPacket(Long dropPacket) {
        this.dropPacket = dropPacket;
    }

    public long getDropByte() {
        return this.dropByte;
    }

    public void setDropByte(long dropByte) {
        this.dropByte = dropByte;
    }

    public boolean isShowDropPacket() {
        return this.showDropPacket;
    }

    public void setShowDropPacket(boolean showDropPacket) {
        this.showDropPacket = showDropPacket;
    }

    public String toString() {
        return "DataStatCondition [isDefZone=" + this.isDefZone + ", deviceId=" + this.deviceId + ", deviceIp=" + this.deviceIp + ", zoneId=" + this.zoneId + ", bisId=" + this.bisId + ", zoneIp=" + this.zoneIp + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", bisType=" + this.bisType + ", sessionId=" + this.sessionId + ", zoneIdList=" + this.zoneIdList + ", protocol=" + this.protocol + ", unit=" + this.unit + ", topn=" + this.topn + ", isClean=" + this.isClean + ", appType=" + this.appType + ", port=" + this.port + ", devSerType=" + this.devSerType + ", abnormalType=" + this.abnormalType + ", startRow=" + this.startRow + ", limit=" + this.limit + ", attackType=" + this.attackType + ", deviceIpList=" + this.deviceIpList + ", requestTrendType=" + this.requestTrendType + ", attackTypeKey=" + this.attackTypeKey + ", attackTypeValue=" + this.attackTypeValue + ", isServiceGroup=" + this.isServiceGroup + ", serviceIds=" + this.serviceIds + ", botId=" + this.botId + ", botType=" + this.botType + ", souceIp=" + this.souceIp + ", descIp=" + this.descIp + ", domain=" + this.domain + ", schedule=" + this.schedule + ", bizTypeList4App=" + this.bizTypeList4App + ", bizTypeMap4AppDevice=" + this.bizTypeMap4AppDevice + ", topnType=" + this.topnType + ", portalQuery=" + this.portalQuery + ", dropPacket=" + this.dropPacket + ", dropByte=" + this.dropByte + ", showDropPacket=" + this.showDropPacket + ", statisticalDimension=" + this.statisticalDimension + "]";
    }

    public boolean isValid() {
        boolean valid = this.isvalidlcoal();
        if (!valid) {
            LOGGER.error((Object)("isValid is false, this=" + this.toString()));
        }
        return valid;
    }

    private boolean isvalidlcoal() {
        if (!this.isValidLocalString()) {
            return false;
        }
        if (null != this.zoneIdList && this.zoneIdList.size() > 10000) {
            LOGGER.error((Object)"zoneIdList error");
            return false;
        }
        if (!this.isValudBizeTypeList(this.bizTypeList4App)) {
            LOGGER.error((Object)"bizTypeList4App error");
            return false;
        }
        String attackTypeRegex = "^[\\w|\u4e00-\u9fa5|\\-|\\!|\\@|\\#|\\$|\\^|\\.|\\+|\\}|\\{|\\(|\\)|\\,|\\;|\\/|\\:|\\&| ]*$";
        if (!(ParamCheckUtil.isValidStringList(this.attackTypeKey, 10000, 256, attackTypeRegex) && ParamCheckUtil.isValidStringList(this.attackTypeValue, 10000, 256, attackTypeRegex) && ParamCheckUtil.isValidStringList(this.requestTrendType, 10000, 256, attackTypeRegex))) {
            LOGGER.error((Object)"attackTypeKey, attackTypeValue, requestTrendType error");
            return false;
        }
        String regex = "((25[0-5]|2[0-4]\\d|1\\d{2}|0?[1-9]\\d|0?0?\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|0?[1-9]\\d|0?0?\\d)";
        if (!ParamCheckUtil.isValidStringList(this.deviceIpList, 100, 16, regex)) {
            LOGGER.error((Object)"deviceIpList error");
            return false;
        }
        return this.isValidMap();
    }

    private boolean isValidLocalString() {
        if (!CommonUtil.isNull(this.deviceIp) && !IpTransformer.isIpV4(this.deviceIp)) {
            LOGGER.error((Object)"deviceIp error");
            return false;
        }
        if (!(this.isValidIp(this.zoneIp) && this.isValidIp(this.souceIp) && this.isValidIp(this.descIp))) {
            LOGGER.error((Object)"zoneIp, souceIp, descIp error");
            return false;
        }
        if (!ParamCheckUtil.isValidString(this.bisType, 64) || !ParamCheckUtil.isValidString(this.domain, 256)) {
            LOGGER.error((Object)"bisType or domain error");
            return false;
        }
        String regex = "^(day|DAY|week|WEEK|month|MONTH|year|YEAR)$";
        if (!ParamCheckUtil.isValidString(this.schedule, 5, regex)) {
            LOGGER.error((Object)"schedule error");
            return false;
        }
        return true;
    }

    private boolean isValidMap() {
        String type;
        if (null != this.serviceIds) {
            if (this.serviceIds.size() > 10000) {
                LOGGER.error((Object)"serviceIds.size() error");
                return false;
            }
            for (Map.Entry<String, List<Long>> entry : this.serviceIds.entrySet()) {
                type = entry.getKey();
                List<Long> idList = entry.getValue();
                if (ParamCheckUtil.isValidString(type, 100, "^[\\w|\u4e00-\u9fa5|\\-|\\!|\\@|\\#|\\$|\\^|\\.|\\+|\\}|\\{|\\/|\\:| ]*$") && null != idList && idList.size() <= 10000) continue;
                LOGGER.error((Object)"type or idList error");
                return false;
            }
        }
        if (null != this.bizTypeMap4AppDevice) {
            if (this.bizTypeMap4AppDevice.size() > 10000) {
                LOGGER.error((Object)"bizTypeMap4AppDevice.size() error");
                return false;
            }
            for (Map.Entry<String, List<Serializable>> entry : this.bizTypeMap4AppDevice.entrySet()) {
                type = entry.getKey();
                List<Serializable> bizTypeList = entry.getValue();
                if (ParamCheckUtil.isValidString(type, 100) && this.isValudBizeTypeList(bizTypeList)) continue;
                LOGGER.error((Object)("type=" + type + ", or bizTypeList error"));
                return false;
            }
        }
        return true;
    }

    private boolean isValidIp(String ipAddr) {
        if (CommonUtil.isNull(ipAddr)) {
            return true;
        }
        if (IpTransformer.checkIpInvaild(ipAddr)) {
            return true;
        }
        LOGGER.error((Object)("ipAddr is not valid IP, ipAddr=" + ipAddr));
        return false;
    }

    private boolean isValudBizeTypeList(List<BizTypePoJo> bizTypeList) {
        if (null == bizTypeList) {
            return true;
        }
        if (bizTypeList.size() > 10000) {
            LOGGER.error((Object)"bizTypeList size to big.");
            return false;
        }
        for (BizTypePoJo bizType : bizTypeList) {
            if (this.isValidBizType(bizType)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidBizType(BizTypePoJo bizType) {
        if (null == bizType) {
            LOGGER.error((Object)"bizType is null");
            return false;
        }
        if (!ParamCheckUtil.isValidString(bizType.getBizName(), 64) || !ParamCheckUtil.isValidString(bizType.getBizType(), 64)) {
            LOGGER.error((Object)"bizType.getBizName() or bizType.getBizType() error");
            return false;
        }
        return true;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public Long getMinInFlow() {
        return this.minInFlow;
    }

    public void setMinInFlow(Long minInFlow) {
        this.minInFlow = minInFlow;
    }

    public Long getMinAttackFlowPeak() {
        return this.minAttackFlowPeak;
    }

    public void setMinAttackFlowPeak(Long minAttackFlowPeak) {
        this.minAttackFlowPeak = minAttackFlowPeak;
    }

    public Integer getTimeSpanType() {
        return this.timeSpanType;
    }

    public void setTimeSpanType(Integer timeSpanType) {
        this.timeSpanType = timeSpanType;
    }

    public String getStatisticalDimension() {
        return this.statisticalDimension;
    }

    public void setStatisticalDimension(String statisticalDimension) {
        this.statisticalDimension = statisticalDimension;
    }
}

