/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.ProtocolParser;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractProtocolParser
implements ProtocolParser {
    private List<AbstractProtocolParser> nextProtocolParsers;
    private AbstractProtocolParser unknownProtocolParser;

    public List<AbstractProtocolParser> getNextProtocolParsers() {
        return this.nextProtocolParsers;
    }

    public void setNextProtocolParsers(List<AbstractProtocolParser> nextProtocolParsers) {
        this.nextProtocolParsers = nextProtocolParsers;
    }

    public AbstractProtocolParser getUnknownProtocolParser() {
        return this.unknownProtocolParser;
    }

    public void setUnknownProtocolParser(AbstractProtocolParser unknownProtocolParser) {
        this.unknownProtocolParser = unknownProtocolParser;
    }

    public void addNextProtocolParser(AbstractProtocolParser parser) {
        if (null == this.nextProtocolParsers) {
            this.nextProtocolParsers = new ArrayList<AbstractProtocolParser>();
        }
        this.nextProtocolParsers.add(parser);
    }

    protected AbstractProtocolParser getAbstractProtocolParser(SubProtocolType type) {
        if (this.nextProtocolParsers == null) {
            return this.unknownProtocolParser;
        }
        for (AbstractProtocolParser parse : this.nextProtocolParsers) {
            if (!parse.canParse(type)) continue;
            return parse;
        }
        return this.unknownProtocolParser;
    }

    @Override
    public Protocol parseProtocol(byte[] data) {
        Protocol protocol = this.parseHead(data);
        byte[] loadData = protocol.getLoadData();
        AbstractProtocolParser nextProtocolParser = this.getAbstractProtocolParser(protocol.getSubProtocolType());
        while (nextProtocolParser != null) {
            if (!nextProtocolParser.canParse(protocol.getSubProtocolType())) continue;
            Protocol subProtocol = nextProtocolParser.parseProtocol(loadData);
            protocol.setSubProtocol(subProtocol);
            return protocol;
        }
        return protocol;
    }

    protected abstract Protocol parseHead(byte[] var1);
}

