/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import com.hs.atic.collector.entity.pcap.UnresolvedProtocol;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class ArpProtocol
implements Protocol,
Serializable {
    private static final int ARP_REQUEST = 1;
    private static final int ARP_REPLY = 2;
    private static final int RARP_REQUEST = 3;
    private static final int RARP_REPLY = 4;
    private static final long serialVersionUID = -9198455186747778690L;
    private byte[] loadData = new byte[0];
    private byte[] headData;
    private int hardwareType;
    private int embedProtocolType;
    private int hardwareSize;
    private int protocolSize;
    private int opCode;
    private String senderMacAddress;
    private String senderIpAddress;
    private String targetMacAddress;
    private String targetIpAddress;

    public int getHardwareType() {
        return this.hardwareType;
    }

    public int getEmbedProtocolType() {
        return this.embedProtocolType;
    }

    public int getHardwareSize() {
        return this.hardwareSize;
    }

    public int getProtocolSize() {
        return this.protocolSize;
    }

    public int getOpCode() {
        return this.opCode;
    }

    public String getSenderMacAddress() {
        return this.senderMacAddress;
    }

    public String getSenderIpAddress() {
        return this.senderIpAddress;
    }

    public String getTargetMacAddress() {
        return this.targetMacAddress;
    }

    public String getTargetIpAddress() {
        return this.targetIpAddress;
    }

    public void setLoadData(byte[] loadData) {
        this.loadData = (byte[])(loadData != null ? (byte[])loadData.clone() : null);
    }

    public void setHeadData(byte[] headData) {
        this.headData = (byte[])(headData != null ? (byte[])headData.clone() : null);
    }

    public void setHardwareType(int hardwareType) {
        this.hardwareType = hardwareType;
    }

    public void setEmbedProtocolType(int embedProtocolType) {
        this.embedProtocolType = embedProtocolType;
    }

    public void setHardwareSize(int hardwareSize) {
        this.hardwareSize = hardwareSize;
    }

    public void setProtocolSize(int protocolSize) {
        this.protocolSize = protocolSize;
    }

    public void setOpCode(int opCode) {
        this.opCode = opCode;
    }

    public void setSenderMacAddress(String senderMacAddress) {
        this.senderMacAddress = senderMacAddress;
    }

    public void setSenderIpAddress(String senderIpAddress) {
        this.senderIpAddress = senderIpAddress;
    }

    public void setTargetMacAddress(String targetMacAddress) {
        this.targetMacAddress = targetMacAddress;
    }

    public void setTargetIpAddress(String targetIpAddress) {
        this.targetIpAddress = targetIpAddress;
    }

    @Override
    public String getDescription() {
        switch (this.opCode) {
            case 1: {
                return "Who has " + this.targetIpAddress + "? Tell " + this.senderIpAddress;
            }
            case 2: 
            case 4: {
                return this.senderIpAddress + " is at " + this.senderMacAddress;
            }
            case 3: {
                return "Who know " + this.targetMacAddress + "? Tell " + this.senderIpAddress;
            }
        }
        return this.opCode + "";
    }

    @Override
    public Map<String, String> getHeadContent() {
        LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
        content.put("Hardware Type", this.hardwareType == 1 ? "Ethernet" : this.hardwareType + "");
        content.put("Protocol Type", this.embedProtocolType == 2048 ? "IP" : this.embedProtocolType + "");
        content.put("Hardware Size", this.hardwareSize + "");
        content.put("Protocol Size", this.protocolSize + "");
        content.put("OpCode", this.opCode + "");
        content.put("Sender Mac Address", this.senderMacAddress);
        content.put("Sender Ip Address", this.senderIpAddress);
        content.put("Target Mac Address", this.targetMacAddress);
        content.put("Target Ip Address", this.targetIpAddress);
        return content;
    }

    @Override
    public byte[] getHeadData() {
        if (this.headData != null) {
            return (byte[])this.headData.clone();
        }
        return new byte[0];
    }

    @Override
    public byte[] getLoadData() {
        if (this.loadData != null) {
            return (byte[])this.loadData.clone();
        }
        return new byte[0];
    }

    @Override
    public String getProtocolName() {
        if (this.opCode == 3 || this.opCode == 4) {
            return "RARP";
        }
        return "ARP";
    }

    @Override
    public Protocol getSubProtocol() {
        return new UnresolvedProtocol(new byte[0]);
    }

    @Override
    public SubProtocolType getSubProtocolType() {
        return null;
    }

    @Override
    public void setSubProtocol(Protocol subProtocol) {
    }
}

