/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.biz.pcap.PcapIdentifier;
import com.hs.atic.collector.db.Repository;
import com.hs.atic.collector.db.RepositoryFactory;
import com.hs.atic.collector.entity.pcap.PcapEntity;
import com.hs.atic.collector.entity.pcap.PcapFileInfo;
import com.hs.atic.collector.util.LogManager;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;

public abstract class CaptureTask {
    protected static final char PCAP_FILE_SEPRATOR = '_';
    protected static final Logger LOGGER = LogManager.getInstance().getPcapLogger();
    protected PcapIdentifier pcapIdentifier;
    protected String baseFileName;
    protected boolean isFinished;
    protected long taskId;
    private Repository<PcapFileInfo> pcapFileRepository;
    private int requiredCaptureNum;

    public CaptureTask(PcapIdentifier pcapIdentifier, String fileName, long taskId) throws IOException {
        this.taskId = taskId;
        this.pcapIdentifier = pcapIdentifier;
        this.baseFileName = fileName;
        this.pcapFileRepository = RepositoryFactory.getInstance().getRepository(PcapFileInfo.class.getName());
    }

    public abstract void check();

    public boolean equals(Object obj) {
        CaptureTask task;
        return obj instanceof CaptureTask && this.taskId == (task = (CaptureTask)obj).getTaskId() && this.getPcapIdentifier().getDeviceType() == task.getPcapIdentifier().getDeviceType();
    }

    public synchronized void execute(PcapEntity data) throws IOException {
        PcapFileInfo pcapFileInfo;
        if (!this.isIsFinished() && null != (pcapFileInfo = this.getPcapFile(data))) {
            pcapFileInfo.appendEntity(data);
            if (!pcapFileInfo.isSaved()) {
                this.getPcapFileRepository().createObject(pcapFileInfo);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(this.getcleanedMessage(pcapFileInfo.toString()) + " and capture number is " + pcapFileInfo.getCaptureNumber()));
            }
            if (pcapFileInfo.isFull(this.getRequiredCaptureNum())) {
                this.afterFileFull(pcapFileInfo);
            } else {
                this.getPcapFileRepository().updateObject(pcapFileInfo);
            }
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public int getRequiredCaptureNum() {
        return this.requiredCaptureNum;
    }

    public void setRequiredCaptureNum(int requiredCaptureNum) {
        this.requiredCaptureNum = requiredCaptureNum;
    }

    protected abstract PcapFileInfo getPcapFile(PcapEntity var1) throws IOException;

    public abstract void finish();

    public String getBaseFileName() {
        return this.baseFileName;
    }

    public Repository<PcapFileInfo> getPcapFileRepository() {
        return this.pcapFileRepository;
    }

    public PcapIdentifier getPcapIdentifier() {
        return this.pcapIdentifier;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public int getType() {
        return this.pcapIdentifier.getType();
    }

    public int hashCode() {
        return (int)(this.taskId ^ this.taskId >>> 32);
    }

    public boolean isIsFinished() {
        return this.isFinished;
    }

    public boolean isMatch(PcapIdentifier identifier) {
        return this.pcapIdentifier.equals(identifier);
    }

    public abstract void init(List<PcapFileInfo> var1);

    public abstract void afterFileFull(PcapFileInfo var1) throws IOException;

    public void setFileName(String fileName) {
        this.baseFileName = fileName;
    }

    public void setFinished(boolean isFinish) {
        this.isFinished = isFinish;
    }

    public void setPcapFileRepository(Repository<PcapFileInfo> pcapFileRepository) {
        this.pcapFileRepository = pcapFileRepository;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("head", (Object)this.pcapIdentifier).append("pcapTaskId", this.taskId).append("pcapIdentifier", (Object)this.pcapIdentifier).append("isFinished", this.isFinished).append("fileName", (Object)this.baseFileName).toString();
    }
}

