/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.ApplicationProtocol;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DnsProtocol
implements ApplicationProtocol,
Serializable {
    public static final int DNS_NAME_SERVER = 2;
    public static final int DNS_CNAME = 5;
    public static final int DNS_A = 1;
    private static final long serialVersionUID = -8930837108924037685L;
    private Protocol subProtocol;
    private SubProtocolType subProtocolType;
    private byte[] loadData = new byte[0];
    private byte[] headData = new byte[0];
    private boolean queryFlag = false;
    private int transactionId;
    private int flag;
    private List<DnsQuery> queries = new ArrayList<DnsQuery>();
    private List<DnsRr> answers = new ArrayList<DnsRr>();
    private List<DnsRr> authorizeResources = new ArrayList<DnsRr>();
    private List<DnsRr> additionalRecords = new ArrayList<DnsRr>();

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public boolean isQuery() {
        return this.queryFlag;
    }

    public void setQuery(boolean queryFlags) {
        this.queryFlag = queryFlags;
    }

    public void setLoadData(byte[] loadData) {
        this.loadData = (byte[])(loadData != null ? (byte[])loadData.clone() : null);
    }

    public void setHeadData(byte[] headData) {
        this.headData = (byte[])(headData != null ? (byte[])headData.clone() : null);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public String getDescription() {
        String description = "Standard Query ";
        if (this.queryFlag) {
            if (null != this.queries && !this.queries.isEmpty()) {
                return description + ":" + this.queries.get(0).getDescription();
            }
            return description;
        }
        description = description + "Response :";
        if (null == this.answers || this.answers.isEmpty()) {
            if (this.flag == 33154) {
                return description + " Server failure";
            }
            if (this.flag == 33923) {
                return description + " No such name";
            }
            return "";
        }
        return description + this.answers.get(0).getDescription();
    }

    @Override
    public Map<String, String> getHeadContent() {
        LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
        content.put("Transaction ID", "0x" + Integer.toHexString(this.transactionId));
        content.put("Flags", "0x" + Integer.toHexString(this.flag));
        content.put("Questions", this.queries.size() + "");
        content.put("Answer RRS", this.answers.size() + "");
        content.put("Authority RRS", this.authorizeResources.size() + "");
        content.put("Additional RRS", this.additionalRecords.size() + "");
        if (!this.queries.isEmpty()) {
            content.put("Queries", "");
        }
        for (int i = 0; i < this.queries.size(); ++i) {
            DnsQuery query = this.queries.get(i);
            String middle = " " + (i + 1);
            if (this.queries.size() == 1) {
                middle = "";
            }
            content.put("Query " + middle + "  Name", query.getQueryName());
            content.put("Query " + middle + " Type", query.getQueryType() + "");
            content.put("Query " + middle + " Class", query.getQueryClass() + "");
        }
        if (!this.answers.isEmpty()) {
            content.put("Answers", "");
        }
        this.putDnsRrContent("Answer", this.answers, content);
        if (!this.authorizeResources.isEmpty()) {
            content.put("Authoritative NameServers", "");
        }
        this.putDnsRrContent("Authoritative NameServer", this.authorizeResources, content);
        if (!this.additionalRecords.isEmpty()) {
            content.put("Additional Records", "");
        }
        this.putDnsRrContent("Additional Record", this.additionalRecords, content);
        return content;
    }

    private void putDnsRrContent(String prefix, List<DnsRr> dnsRrs, Map<String, String> content) {
        for (int i = 0; i < dnsRrs.size(); ++i) {
            DnsRr rr = dnsRrs.get(i);
            String middle = " " + (i + 1);
            if (dnsRrs.size() == 1) {
                middle = "";
            }
            content.put(prefix + middle + " Name", rr.getDomain());
            content.put(prefix + middle + " Type", rr.getType() + "");
            content.put(prefix + middle + " Class", rr.getClassType() + "");
            content.put(prefix + middle + " Time To Live", rr.getTtl() + "");
            content.put(prefix + middle + " Data Length", rr.getDataLength() + "");
            if (rr.getType() == 1) {
                content.put(prefix + middle + " Addr", rr.getDescription());
            }
            if (rr.getType() == 2) {
                content.put(prefix + middle + " Name Server", rr.getDescription());
            }
            if (rr.getType() != 5) continue;
            content.put(prefix + middle + " Primary Name", rr.getDescription());
        }
    }

    public List<DnsQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<DnsQuery> queries) {
        this.queries = queries;
    }

    public List<DnsRr> getAnswers() {
        return this.answers;
    }

    public void setAnswers(List<DnsRr> answers) {
        this.answers = answers;
    }

    public List<DnsRr> getAuthorizeResources() {
        return this.authorizeResources;
    }

    public void setAuthorizeResources(List<DnsRr> authorizeResources) {
        this.authorizeResources = authorizeResources;
    }

    public List<DnsRr> getAdditionalRecords() {
        return this.additionalRecords;
    }

    public void setAdditionalRecords(List<DnsRr> additionalRecords) {
        this.additionalRecords = additionalRecords;
    }

    public void setSubProtocolType(SubProtocolType subProtocolType) {
        this.subProtocolType = subProtocolType;
    }

    @Override
    public byte[] getHeadData() {
        if (this.headData != null) {
            return (byte[])this.headData.clone();
        }
        return new byte[0];
    }

    @Override
    public byte[] getLoadData() {
        if (this.loadData != null) {
            return (byte[])this.loadData.clone();
        }
        return new byte[0];
    }

    @Override
    public String getProtocolName() {
        return "DNS";
    }

    @Override
    public Protocol getSubProtocol() {
        return this.subProtocol;
    }

    @Override
    public SubProtocolType getSubProtocolType() {
        return this.subProtocolType;
    }

    @Override
    public void setSubProtocol(Protocol subProtocol) {
        this.subProtocol = subProtocol;
    }

    public static class DnsRr
    implements Serializable {
        private static final long serialVersionUID = 2291809908921135823L;
        private String domain;
        private byte[] dataContent;
        private int type;
        private int classType;
        private long ttl;
        private int dataLength;
        private String description;

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public byte[] getDataContent() {
            if (this.dataContent != null) {
                return (byte[])this.dataContent.clone();
            }
            return new byte[0];
        }

        public void setDataContent(byte[] dataContent) {
            this.dataContent = (byte[])(dataContent != null ? (byte[])dataContent.clone() : null);
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getClassType() {
            return this.classType;
        }

        public void setClassType(int classType) {
            this.classType = classType;
        }

        public long getTtl() {
            return this.ttl;
        }

        public void setTtl(long ttl) {
            this.ttl = ttl;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public void setDataLength(int dataLength) {
            this.dataLength = dataLength;
        }
    }

    public static class DnsQuery
    implements Serializable {
        private static final long serialVersionUID = 2200165872122885024L;
        private String queryName;
        private int queryType;
        private int queryClass;

        public String getDescription() {
            return this.queryName;
        }

        public String getQueryName() {
            return this.queryName;
        }

        public void setQueryName(String queryName) {
            this.queryName = queryName;
        }

        public int getQueryType() {
            return this.queryType;
        }

        public void setQueryType(int queryType) {
            this.queryType = queryType;
        }

        public int getQueryClass() {
            return this.queryClass;
        }

        public void setQueryClass(int queryClass) {
            this.queryClass = queryClass;
        }
    }
}

