/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.AbstractProtocolParser;
import com.hs.atic.collector.entity.pcap.EthernetProtocol;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SingleValueProtocolType;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import com.hs.atic.collector.entity.pcap.UnresolvedProtocol;

public class EthernetProtocolParser
extends AbstractProtocolParser {
    @Override
    public boolean canParse(SubProtocolType type) {
        return true;
    }

    @Override
    protected Protocol parseHead(byte[] data) {
        try {
            EthernetProtocol protocol = new EthernetProtocol();
            byte a = data[12];
            byte b = data[13];
            int subTypeFlag = (a & 0xFF) << 8 | b & 0xFF;
            protocol.setSubTypeFlag(new SingleValueProtocolType(subTypeFlag));
            byte[] loadData = new byte[data.length - 14];
            System.arraycopy(data, 14, loadData, 0, loadData.length);
            protocol.setLoadData(loadData);
            return protocol;
        }
        catch (RuntimeException e) {
            return new UnresolvedProtocol(data);
        }
    }
}

