/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.biz.event.process.NotifyPcapTaskFinishedHanlder;
import com.hs.atic.collector.biz.pcap.PcapIdentifier;
import com.hs.atic.collector.entity.pcap.CaptureTask;
import com.hs.atic.collector.entity.pcap.PcapEntity;
import com.hs.atic.collector.entity.pcap.PcapFileInfo;
import java.io.IOException;
import java.util.List;

public class GlobalCaptureTask
extends CaptureTask {
    protected NotifyPcapTaskFinishedHanlder notify = NotifyPcapTaskFinishedHanlder.getInstance();
    private int index = -1;
    private PcapFileInfo file;

    public GlobalCaptureTask(PcapIdentifier pcapIdentifier, String fileName, long taskId) throws IOException {
        super(pcapIdentifier, fileName, taskId);
    }

    @Override
    public void check() {
        if (this.file != null) {
            this.file.checkFileWriter();
        }
    }

    @Override
    public void finish() {
        if (this.file != null) {
            this.file.close();
            this.getPcapFileRepository().updateObject(this.file);
        }
        this.setFinished(true);
    }

    @Override
    protected PcapFileInfo getPcapFile(PcapEntity data) throws IOException {
        if (this.file == null) {
            this.file = new PcapFileInfo(this.getPcapIdentifier(), this.getTaskId(), this.getNewFileName());
        }
        return this.file;
    }

    private String getNewFileName() {
        ++this.index;
        String fileName = this.getBaseFileName() + '_' + this.index;
        return GlobalCaptureTask.getcleanFileName(fileName);
    }

    private static String getcleanFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        fileName = fileName.replaceAll("\\||/|:|\\*|\\?|\"|<|>|\\\\", "");
        return fileName;
    }

    @Override
    public void afterFileFull(PcapFileInfo files) throws IOException {
        files.close();
        this.getPcapFileRepository().updateObject(files);
        this.finish();
        this.notify.refreshNotifyList(this.getTaskId());
    }

    @Override
    public void init(List<PcapFileInfo> files) {
        for (PcapFileInfo each : files) {
            String fileName = each.getFileName();
            try {
                String fileIndex = fileName.substring(fileName.lastIndexOf(95) + 1, fileName.length());
                int inNum = Integer.parseInt(fileIndex);
                if (inNum > this.index) {
                    this.index = inNum;
                }
            }
            catch (RuntimeException e) {
                ++this.index;
            }
            if (each.isIsCompleted()) continue;
            this.file = each;
        }
    }
}

