/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.AbstractProtocolParser;
import com.hs.atic.collector.entity.pcap.IcmpProtocol4IpV6;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SingleValueProtocolType;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class IcmpProtocolParser4IpV6
extends AbstractProtocolParser {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    private static SubProtocolType protocolType = new SingleValueProtocolType(58);
    private static final int DESTINATION_UNREACHABLE = 1;
    private static final int PACKET_TOO_BIG_MESSAGE = 2;
    private static final int TIME_EXCEEDED_MESSAGE = 3;
    private static final int PARAMETER_PROBLEM_MESSAGE = 4;
    private static final int ROUTING_REDIRECT = 137;
    private static final int ECHO_REQUEST_MESSAGE = 128;
    private static final int ECHO_REPLY_MESSAGE = 129;
    private static final int ROUTER_SOLICITATION = 133;
    private static final int ROUTER_ADVERTISEMENT = 134;
    private static final int NEIGHBOR_SOLICITATION = 135;
    private static final int NEIGHBOR_ADVERTISEMENT = 136;
    private static final int GROUP_MEMBER_REFERENCES_REPORT = 131;
    private static final int GROUP_MEMBER_REFERENCES_QUERY = 130;
    private static final int GROUP_MEMBER_REFERENCES_TERMINATE = 132;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Protocol parseHead(byte[] data) {
        IcmpProtocol4IpV6 protocol = new IcmpProtocol4IpV6();
        UnsignedDataInputStream stream = null;
        try {
            stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
            int type = stream.readUnsignedByte();
            protocol.setType(type);
            int code = stream.readUnsignedByte();
            protocol.setCode(code);
            int checkSum = stream.readUnsignedShort();
            protocol.setCheckSum(checkSum);
            switch (type) {
                case 1: {
                    IcmpProtocol4IpV6.IcmpV6UnreachableType icmpV6UnreachableType = protocol.new IcmpProtocol4IpV6.IcmpV6UnreachableType();
                    icmpV6UnreachableType.setDataLength(data.length);
                    protocol.setInnerType(icmpV6UnreachableType);
                    break;
                }
                case 2: {
                    IcmpProtocol4IpV6.IcmpV6ToLargeGroupType icmpV6ToLargeGroupType = protocol.new IcmpProtocol4IpV6.IcmpV6ToLargeGroupType();
                    icmpV6ToLargeGroupType.setDataLength(data.length);
                    protocol.setInnerType(icmpV6ToLargeGroupType);
                    break;
                }
                case 3: {
                    IcmpProtocol4IpV6.IcmpV6TimeOutType icmpV6TimeOutType = protocol.new IcmpProtocol4IpV6.IcmpV6TimeOutType();
                    icmpV6TimeOutType.setDataLength(data.length);
                    protocol.setInnerType(icmpV6TimeOutType);
                    break;
                }
                case 4: {
                    IcmpProtocol4IpV6.IcmpV6ParameterProblemTyle icmpV6ParameterProblemTyle = protocol.new IcmpProtocol4IpV6.IcmpV6ParameterProblemTyle();
                    icmpV6ParameterProblemTyle.setDataLength(data.length);
                    protocol.setInnerType(icmpV6ParameterProblemTyle);
                    break;
                }
                case 137: {
                    IcmpProtocol4IpV6.IcmpIpV6RouteChangeType icmpIpV6RouteChangeType = protocol.new IcmpProtocol4IpV6.IcmpIpV6RouteChangeType();
                    icmpIpV6RouteChangeType.setDataLength(data.length);
                    if (stream.skip(4L) != 4L) {
                        LOGGER.error((Object)"stream read error");
                    }
                    byte[] desRoute = new byte[16];
                    byte[] desSource = new byte[16];
                    if (stream.available() >= 16) {
                        if (stream.read(desRoute) != 16) {
                            LOGGER.error((Object)"stream read error");
                        }
                        icmpIpV6RouteChangeType.setDesRoutingIp(IpTransformer.compressIPv6(IpTransformer.byte2String(desRoute, 6)));
                    }
                    if (stream.available() >= 16) {
                        if (stream.read(desSource) != 16) {
                            LOGGER.error((Object)"stream read error");
                        }
                        icmpIpV6RouteChangeType.setDesIp(IpTransformer.compressIPv6(IpTransformer.byte2String(desSource, 6)));
                    }
                    protocol.setInnerType(icmpIpV6RouteChangeType);
                    break;
                }
                case 128: {
                    IcmpProtocol4IpV6.IcmpIpV6EchoMessageType icmpIpV6EchoMessageType = protocol.new IcmpProtocol4IpV6.IcmpIpV6EchoMessageType();
                    icmpIpV6EchoMessageType.setIsReply(false);
                    icmpIpV6EchoMessageType.setIdentifier(stream.readUnsignedShort());
                    icmpIpV6EchoMessageType.setSequenceNumber(stream.readUnsignedShort());
                    icmpIpV6EchoMessageType.setDataLength(data.length);
                    protocol.setInnerType(icmpIpV6EchoMessageType);
                    break;
                }
                case 129: {
                    IcmpProtocol4IpV6.IcmpIpV6EchoMessageType icmpIpV6EchoMessageType = protocol.new IcmpProtocol4IpV6.IcmpIpV6EchoMessageType();
                    icmpIpV6EchoMessageType.setIsReply(true);
                    icmpIpV6EchoMessageType.setIdentifier(stream.readUnsignedShort());
                    icmpIpV6EchoMessageType.setSequenceNumber(stream.readUnsignedShort());
                    icmpIpV6EchoMessageType.setDataLength(data.length);
                    protocol.setInnerType(icmpIpV6EchoMessageType);
                    break;
                }
                case 133: {
                    IcmpProtocol4IpV6.IcmpIpV6RouterRequestType icmpIpV6RouterRequestType = protocol.new IcmpProtocol4IpV6.IcmpIpV6RouterRequestType();
                    icmpIpV6RouterRequestType.setDataLength(data.length);
                    protocol.setInnerType(icmpIpV6RouterRequestType);
                    break;
                }
                case 134: {
                    IcmpProtocol4IpV6.IcmpIpV6RouterReplyType icmpIpV6RouterReplyType = protocol.new IcmpProtocol4IpV6.IcmpIpV6RouterReplyType();
                    icmpIpV6RouterReplyType.setDataLength(data.length);
                    protocol.setInnerType(icmpIpV6RouterReplyType);
                    break;
                }
                case 135: {
                    IcmpProtocol4IpV6.IcmpIpV6NeighborRequestType icmpIpV6NeighborRequestType = protocol.new IcmpProtocol4IpV6.IcmpIpV6NeighborRequestType();
                    icmpIpV6NeighborRequestType.setDataLength(data.length);
                    protocol.setInnerType(icmpIpV6NeighborRequestType);
                    break;
                }
                case 136: {
                    IcmpProtocol4IpV6.IcmpIpV6NeighborReplyType icmpIpV6NeighborReplyType = protocol.new IcmpProtocol4IpV6.IcmpIpV6NeighborReplyType();
                    icmpIpV6NeighborReplyType.setDataLength(data.length);
                    protocol.setInnerType(icmpIpV6NeighborReplyType);
                    break;
                }
                case 130: 
                case 131: 
                case 132: {
                    IcmpProtocol4IpV6.IcmpIpV6GroupMemberReferencesType icmpIpV6GroupMemberReferencesType = protocol.new IcmpProtocol4IpV6.IcmpIpV6GroupMemberReferencesType();
                    icmpIpV6GroupMemberReferencesType.setDataLength(data.length);
                    protocol.setInnerType(icmpIpV6GroupMemberReferencesType);
                    break;
                }
                default: {
                    IcmpProtocol4IpV6.IcmpIpV6UnresolvedType icmpIpV6UnresolvedType = protocol.new IcmpProtocol4IpV6.IcmpIpV6UnresolvedType();
                    icmpIpV6UnresolvedType.setDataLength(data.length);
                    protocol.setInnerType(icmpIpV6UnresolvedType);
                }
            }
            protocol.setHeadData(data);
            protocol.setLoadData(data);
            IcmpProtocol4IpV6 icmpProtocol4IpV6 = protocol;
            return icmpProtocol4IpV6;
        }
        catch (IOException e) {
            IcmpProtocol4IpV6 icmpProtocol4IpV6 = protocol;
            return icmpProtocol4IpV6;
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    return protocol;
                }
            }
        }
    }

    @Override
    public boolean canParse(SubProtocolType type) {
        return protocolType.equals(type);
    }
}

