/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.AbstractProtocolParser;
import com.hs.atic.collector.entity.pcap.IpProtocol;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SingleValueProtocolType;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import com.hs.atic.collector.util.IPUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class IpProtocolParser
extends AbstractProtocolParser {
    private static final int TIME_STAMP_TYPE = 68;
    private static final int SECURITY_TYPE = 130;
    private static final int NO_OPTION_IP_HEAD_LENGTH = 20;
    private static final int LOOSE_SOURCE_ROUTING_TYPE = 131;
    private static final int STRICT_SOURCE_ROUTING_TYPE = 137;
    private static final int RECORD_ROUTE_TYPE = 7;
    private static final int STREAM_IDENTIFIER_TYPE = 136;
    private static SubProtocolType typeFlag = new SingleValueProtocolType(2048);

    @Override
    public boolean canParse(SubProtocolType type) {
        return typeFlag.equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Protocol parseHead(byte[] data) {
        IpProtocol protocol = new IpProtocol();
        UnsignedDataInputStream stream = null;
        try {
            stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
            int value = stream.readUnsignedByte();
            int version = value >> 4;
            protocol.setVersion(version);
            int headLength = (value & 0xF) * 4;
            byte[] headData = new byte[headLength < data.length ? headLength : data.length];
            System.arraycopy(data, 0, headData, 0, headLength < data.length ? headLength : data.length);
            protocol.setHeadData(headData);
            int differentiatedServiceFiled = stream.readUnsignedByte();
            protocol.setDifferentiatedServiceFiled(differentiatedServiceFiled);
            int totalLength = stream.readUnsignedShort();
            protocol.setTotalLength(totalLength);
            int identification = stream.readUnsignedShort();
            protocol.setIdentification(identification);
            int flagValue = stream.readUnsignedShort();
            int flag = flagValue >> 13;
            protocol.setFlag(flag);
            int fragmentOffset = flagValue & 0x1FFF;
            protocol.setFragmentOffset(fragmentOffset * 8);
            int ttl = stream.readUnsignedByte();
            protocol.setTtl(ttl);
            int subTypeFlag = stream.readUnsignedByte();
            int checkSum = stream.readUnsignedShort();
            protocol.setCheckSum(checkSum);
            long source = stream.readUnsignedInt();
            protocol.setSource(IpTransformer.long2StringFormat(source));
            long destination = stream.readUnsignedInt();
            protocol.setDestination(IpTransformer.long2StringFormat(destination));
            if (headLength > 20) {
                protocol.setOption(true);
                int optionSize = headLength - 20;
                protocol.setOptionSize(optionSize);
                protocol.setOptionContent(this.getOptionContent(stream));
            }
            byte[] loadData = new byte[data.length - headLength];
            System.arraycopy(data, headLength, loadData, 0, loadData.length);
            protocol.setLoadData(loadData);
            if (fragmentOffset == 0) {
                protocol.setSubTypeFlag(new SingleValueProtocolType(subTypeFlag));
            }
            IpProtocol ipProtocol = protocol;
            return ipProtocol;
        }
        catch (IOException e) {
            IpProtocol ipProtocol = protocol;
            return ipProtocol;
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    return protocol;
                }
            }
        }
    }

    private Map<String, String> getOptionContent(UnsignedDataInputStream stream) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        try {
            int type = stream.readUnsignedByte();
            int length = stream.readUnsignedByte();
            switch (type) {
                case 130: {
                    options.put("Type", "Security");
                    int securityLevelValue = stream.readUnsignedShort();
                    String securityLevel = null;
                    switch (securityLevelValue) {
                        case 0: {
                            securityLevel = "Unclassified";
                            break;
                        }
                        case 61749: {
                            securityLevel = "Confidential";
                            break;
                        }
                        case 30874: {
                            securityLevel = "EFTO";
                            break;
                        }
                        case 48205: {
                            securityLevel = "MMMM";
                            break;
                        }
                        case 24102: {
                            securityLevel = "PROG";
                            break;
                        }
                        case 44819: {
                            securityLevel = "Restricted";
                            break;
                        }
                        case 55177: {
                            securityLevel = "Secret";
                            break;
                        }
                        case 27589: {
                            securityLevel = "Top Secret";
                            break;
                        }
                        default: {
                            securityLevel = "Reserved for future use " + null;
                        }
                    }
                    options.put("SecurityLevel", securityLevel);
                    options.put("Compartments", stream.readUnsignedShort() + "");
                    options.put("Handling Restrictions", stream.readUnsignedShort() + "");
                    int tccValueHigh = stream.readUnsignedByte();
                    int tccValueLow = stream.readUnsignedShort();
                    int tccValue = (tccValueHigh << 24) + tccValueLow;
                    options.put("Transmission Control Code", tccValue + "");
                    break;
                }
                case 131: {
                    options.put("Type", "Loose Source Route");
                    this.fillRouteContent(stream, options, length);
                    break;
                }
                case 137: {
                    options.put("Type", "Strict Source Route");
                    this.fillRouteContent(stream, options, length);
                    break;
                }
                case 7: {
                    options.put("Type", "Route Record");
                    this.fillRouteContent(stream, options, length);
                    break;
                }
                case 68: {
                    options.put("Type", "Time Stamp");
                    int pointer = stream.readUnsignedByte();
                    options.put("Pointer", pointer + "");
                    options.put("OverFlow", stream.readUnsignedByte() + "");
                    for (int i = 0; i < (length - 4) / 8; ++i) {
                        long ipValue = stream.readUnsignedInt();
                        String ip = IpTransformer.long2StringFormat(ipValue);
                        if (IPUtil.isIpv4(ip) && ipValue != 0L) {
                            options.put("Address" + i, ip);
                        } else {
                            options.put("Address" + i, " - ");
                        }
                        options.put("Time Stamp" + i, stream.readUnsignedInt() + "");
                    }
                    break;
                }
                case 136: {
                    options.put("Type", "StreamID");
                    options.put("StreamID", stream.readUnsignedShort() + "");
                    break;
                }
            }
            return options;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void fillRouteContent(UnsignedDataInputStream stream, Map<String, String> options, int length) throws IOException {
        int pointer = stream.readUnsignedByte();
        options.put("Pointer", pointer + "");
        for (int i = 0; i < (length - 3) / 4; ++i) {
            long ipValue = stream.readUnsignedInt();
            String ip = IpTransformer.long2StringFormat(ipValue);
            if (IPUtil.isIpv4(ip) && ipValue != 0L) {
                options.put("Address" + i, ip);
                continue;
            }
            options.put("Address" + i, " - ");
        }
        stream.readUnsignedByte();
    }
}

