/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.AttackerCount;
import com.hs.atic.collector.entity.pcap.DefaultProtocolParseFactory;
import com.hs.atic.collector.entity.pcap.IcmpProtocol;
import com.hs.atic.collector.entity.pcap.IcmpProtocol4IpV6;
import com.hs.atic.collector.entity.pcap.NetProtocol;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.ProtocolItem;
import com.hs.atic.collector.entity.pcap.ProtocolParser;
import com.hs.atic.collector.entity.pcap.TcpProtocol;
import com.hs.atic.collector.entity.pcap.TransforProtocol;
import com.hs.atic.collector.entity.pcap.UdpProtocol;
import com.hs.atic.collector.entity.pcap.UnresolvedProtocol;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.PcapUtil;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PcapFileReader {
    private static final int PCAP_FILE_HEAD_LENGTH = 24;
    private static final int ATTACK_TYPE_56_DNS_NO_SUCH_NAME = 56;
    private static final Logger LOGGER = LogManager.getInstance().getPcapLogger();
    private String fileName;
    private int unitNumbers;

    public PcapFileReader(String fileName) {
        this.fileName = fileName;
        this.unitNumbers = this.getPacketSize();
    }

    public List<AttackerCount> getAttackerInfo(Integer attackType) {
        ArrayList<AttackerCount> result = new ArrayList<AttackerCount>();
        try {
            List<ProtocolItem> items = this.getAllProtocolList();
            for (ProtocolItem item : items) {
                Protocol subProtocol = item.getProtocol();
                String attackIp = null;
                int port = -1;
                String protocolName = "OTHER";
                while (!(subProtocol.getSubProtocol() instanceof UnresolvedProtocol)) {
                    if ((subProtocol = subProtocol.getSubProtocol()) instanceof NetProtocol) {
                        attackIp = 56 == attackType ? ((NetProtocol)subProtocol).getDestination() : ((NetProtocol)subProtocol).getSource();
                        protocolName = "OTHER";
                    }
                    if (subProtocol instanceof TransforProtocol) {
                        port = 56 == attackType ? ((TransforProtocol)subProtocol).getSourcePort() : ((TransforProtocol)subProtocol).getDestinationPort();
                        if (subProtocol instanceof TcpProtocol) {
                            protocolName = "TCP";
                        }
                        if (subProtocol instanceof UdpProtocol) {
                            protocolName = "UDP";
                        }
                    }
                    if (subProtocol instanceof IcmpProtocol) {
                        protocolName = "ICMP";
                    }
                    if (!(subProtocol instanceof IcmpProtocol4IpV6)) continue;
                    protocolName = "ICMPV6";
                }
                if (attackIp == null) continue;
                AttackerCount attackerCount = new AttackerCount(attackIp);
                attackerCount.setProtocolName(protocolName);
                attackerCount.setDestinationPort(port);
                this.add2Result(result, attackerCount);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"When getAttackerInfo  ,error happend:", (Throwable)e);
        }
        return result;
    }

    private void add2Result(List<AttackerCount> result, AttackerCount attackerCount) {
        if (result.contains(attackerCount)) {
            for (AttackerCount each : result) {
                if (!each.equals(attackerCount)) continue;
                each.addCount();
            }
        } else {
            result.add(attackerCount);
        }
    }

    public List<ProtocolItem> getAllProtocolList() throws IOException {
        return this.readPcapData(0L, this.unitNumbers);
    }

    public List<ProtocolItem> getProtocolList(int offset, int size) throws IOException {
        if (offset < 0 || offset + size > this.unitNumbers) {
            throw new IndexOutOfBoundsException("Offset is : " + offset + " size is " + size + "Real Size: " + this.unitNumbers);
        }
        return this.readPcapData(offset, size);
    }

    public int getSize() throws IOException {
        return this.unitNumbers;
    }

    private void closeFile(FileInputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"When close pcap file ,error happend:", (Throwable)e);
            }
        }
    }

    private void closeStream(DataInputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"When close DataInputStream ,error happend:", (Throwable)e);
            }
        }
    }

    private int getItemLength(DataInputStream stream) throws IOException {
        byte c1 = stream.readByte();
        byte c2 = stream.readByte();
        byte c3 = stream.readByte();
        byte c4 = stream.readByte();
        int length1 = c4 << 24 & 0xFF000000 | c3 << 16 & 0xFF0000;
        int length2 = c2 << 8 & 0xFF00 | c1 << 0 & 0xFF;
        int length = length1 | length2;
        stream.readInt();
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPacketSize() {
        int size = 0;
        FileInputStream in = null;
        DataInputStream stream = null;
        try {
            in = new FileInputStream(this.fileName);
            stream = new DataInputStream(in);
            if (stream.skip(24L) != 24L) {
                LOGGER.error((Object)"stream read error");
            }
            while (true) {
                this.skipAUnit(stream);
                ++size;
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.info((Object)("Pcap file  has " + size + " line."));
            int n = size;
            this.closeStream(stream);
            this.closeFile(in);
            return n;
        }
        catch (IOException e) {
            try {
                LOGGER.info((Object)("Pcap file  has " + size + " line."));
                int n = size;
                this.closeStream(stream);
                this.closeFile(in);
                return n;
            }
            catch (Throwable throwable) {
                this.closeStream(stream);
                this.closeFile(in);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<ProtocolItem> readPcapData(long offset, long size) {
        ArrayList<ProtocolItem> list = new ArrayList<ProtocolItem>();
        FileInputStream in = null;
        UnsignedDataInputStream stream = null;
        try {
            in = new FileInputStream(this.fileName);
            stream = new UnsignedDataInputStream(in);
            if (stream.skip(24L) != 24L) {
                LOGGER.error((Object)"stream read error");
            }
            this.skipUnits(stream, offset);
            DefaultProtocolParseFactory factory = new DefaultProtocolParseFactory();
            ProtocolParser parser = factory.getRootProtocolParser();
            for (long i = 0L; i < size; ++i) {
                long majorTime = PcapUtil.transformInt2LittleEnd(stream.readInt());
                PcapUtil.transformInt2LittleEnd(stream.readInt());
                long currentTime = majorTime;
                byte[] content = this.readPcapUnit(stream);
                ProtocolItem item = new ProtocolItem();
                Protocol protocol = parser.parseProtocol(content);
                item.setProtocol(protocol);
                item.setTime(currentTime);
                list.add(item);
            }
            ArrayList<ProtocolItem> arrayList = list;
            this.closeStream(stream);
            this.closeFile(in);
            return arrayList;
        }
        catch (FileNotFoundException e) {
            ArrayList<ProtocolItem> arrayList = list;
            return arrayList;
        }
        catch (IOException e2) {
            ArrayList<ProtocolItem> arrayList = list;
            return arrayList;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.closeStream(stream);
            this.closeFile(in);
        }
    }

    private byte[] readPcapUnit(DataInputStream stream) throws IOException {
        int length = this.getItemLength(stream);
        byte[] data = new byte[length];
        int realLength = stream.read(data);
        if (realLength < length) {
            byte[] realData = new byte[realLength];
            System.arraycopy(data, 0, realData, 0, realLength);
            return realData;
        }
        return data;
    }

    private void skipAUnit(DataInputStream stream) throws IOException {
        stream.readLong();
        int length = this.getItemLength(stream);
        if (stream.skip(length) != (long)length) {
            LOGGER.error((Object)"stream read error");
        }
    }

    private void skipUnits(DataInputStream stream, long size) throws IOException {
        for (long i = 0L; i < size; ++i) {
            this.skipAUnit(stream);
        }
    }
}

