/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.PcapEntity;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.PcapUtil;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class PcapFileWriter {
    private static final int MAGIC = -1582119980;
    private static final short MAJOR_VERSION = 2;
    private static final short MINOR_VERSION = 4;
    private static final int THIS_ZONE = 0;
    private static final int TIME_STAMP = 0;
    private static final long THREE_MINITES = 180000L;
    private static long openFileLimit;
    private transient Logger logger = LogManager.getInstance().getPcapLogger();
    private DataOutputStream stream;
    private int linkType = 1;
    private int maxSnapLenght = 65535;
    private long previousWriteTime;
    private String absolutePath;
    private boolean fileIsWritten = false;

    public PcapFileWriter(String absolutePath) throws IOException {
        this.absolutePath = absolutePath;
        this.previousWriteTime = System.currentTimeMillis();
        this.fileIsWritten = new File(absolutePath).length() != 0L;
    }

    public static long getOpenFileLimit() {
        return openFileLimit;
    }

    public void appendEntity(PcapEntity data) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("now file append data " + data));
        }
        this.entureFileOpen();
        this.entureFileHead();
        this.previousWriteTime = System.currentTimeMillis();
        try {
            int second = (int)(System.currentTimeMillis() / 1000L);
            int macroSecond = (int)(System.currentTimeMillis() % 1000L * 1000L);
            this.stream.writeInt(PcapUtil.transformInt2LittleEnd(second));
            this.stream.writeInt(PcapUtil.transformInt2LittleEnd(macroSecond));
            this.stream.writeInt(PcapUtil.transformInt2LittleEnd(data.getPackageLength()));
            this.stream.writeInt(PcapUtil.transformInt2LittleEnd(data.getRealLength()));
            this.stream.write(data.getData());
        }
        catch (IOException e) {
            this.stream.close();
            this.stream = null;
            throw e;
        }
    }

    public boolean checkFileWriter() {
        if (System.currentTimeMillis() - this.previousWriteTime >= openFileLimit) {
            if (this.stream != null) {
                this.logger.info((Object)"this file was not accessed for a long time,so I close it");
                this.closeFile();
            }
            return true;
        }
        return false;
    }

    public void close() {
        this.closeFile();
    }

    public long getPreviousWriteTime() {
        return this.previousWriteTime;
    }

    public DataOutputStream getStream() {
        return this.stream;
    }

    public void setPreviousWriteTime(long previousWriteTime) {
        this.previousWriteTime = previousWriteTime;
    }

    private void closeFile() {
        if (this.stream != null) {
            this.logger.info((Object)("Now close file " + this.stream));
            try {
                this.stream.close();
                this.logger.info((Object)"file closed secceed");
            }
            catch (IOException e) {
                this.logger.error((Object)"file closed failed", (Throwable)e);
            }
            this.stream = null;
        }
    }

    private void entureFileHead() throws IOException {
        if (!this.fileIsWritten) {
            this.fileIsWritten = true;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Create a new file header.");
            }
            this.stream.writeInt(PcapUtil.transformInt2LittleEnd(-1582119980));
            this.stream.writeShort(PcapUtil.transfromShort2LittleEnd(2));
            this.stream.writeShort(PcapUtil.transfromShort2LittleEnd(4));
            this.stream.writeInt(PcapUtil.transformInt2LittleEnd(0));
            this.stream.writeInt(PcapUtil.transformInt2LittleEnd(0));
            this.stream.writeInt(PcapUtil.transformInt2LittleEnd(this.maxSnapLenght));
            this.stream.writeInt(PcapUtil.transformInt2LittleEnd(this.linkType));
        }
    }

    private void entureFileOpen() throws FileNotFoundException {
        if (this.stream == null) {
            this.stream = new DataOutputStream(new FileOutputStream(this.absolutePath, true));
        }
    }

    static {
        try {
            openFileLimit = Long.parseLong(PcapUtil.getPcapConfigProperty("OpenFileLimit"));
        }
        catch (Exception e) {
            openFileLimit = 180000L;
        }
    }
}

