/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.AbstractProtocolParser;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SnmpProtocol;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import com.hs.atic.collector.entity.pcap.TransformProtocolType;
import com.hs.atic.collector.util.EventUtil;
import com.sun.jmx.snmp.SnmpMessage;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpPduRequest;
import com.sun.jmx.snmp.SnmpPduTrap;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;

public class SnmpProtocolParser
extends AbstractProtocolParser {
    private int managerProtocolFlag = 161;
    private int agentProtocolFlag = 162;

    @Override
    protected Protocol parseHead(byte[] data) {
        SnmpProtocol protocol = new SnmpProtocol();
        try {
            protocol.setLoadData(data);
            SnmpMessage message = new SnmpMessage();
            message.decodeMessage(data, data.length);
            SnmpPdu pdu = message.decodeSnmpPdu();
            protocol.setVersion(message.version);
            protocol.setCommunity(new String(message.community, "utf-8"));
            protocol.setPduTypeDescription(SnmpPdu.pduTypeToString((int)pdu.type));
            protocol.setPduContent(this.getPduContent(pdu));
            return protocol;
        }
        catch (SnmpStatusException e) {
            return protocol;
        }
        catch (UnsupportedEncodingException e) {
            return protocol;
        }
    }

    private Map<String, String> getPduContent(SnmpPdu pdu) {
        LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
        if (pdu instanceof SnmpPduTrap) {
            SnmpPduTrap trap = (SnmpPduTrap)pdu;
            content.put("Enterprise", trap.enterprise.toString());
            content.put("Agent", trap.agentAddr.toString());
            content.put("SpecificTrap", trap.specificTrap + "");
            content.put("TimeStamp", EventUtil.getTimeStamp(trap.timeStamp));
        } else if (pdu instanceof SnmpPduRequest) {
            SnmpPduRequest request = (SnmpPduRequest)pdu;
            content.put("RequestId", request.requestId + "");
            content.put("ErrorStatus", request.errorStatus + "");
            content.put("ErrorIndex", request.errorIndex + "");
        }
        for (SnmpVarBind var : pdu.varBindList) {
            content.put("Object Identifier", var.getOid().toString());
            content.put("Value", var.getSnmpValue().toString());
        }
        return content;
    }

    @Override
    public boolean canParse(SubProtocolType type) {
        TransformProtocolType transType;
        return type instanceof TransformProtocolType && (this.fit((transType = (TransformProtocolType)type).getSource()) || this.fit(transType.getTarget()));
    }

    private boolean fit(int port) {
        return port == this.managerProtocolFlag || port == this.agentProtocolFlag;
    }
}

