/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.AbstractProtocolParser;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SingleValueProtocolType;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import com.hs.atic.collector.entity.pcap.TransformProtocolType;
import com.hs.atic.collector.entity.pcap.UdpProtocol;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class UdpProtocolParser
extends AbstractProtocolParser {
    private static SubProtocolType protocolType = new SingleValueProtocolType(17);
    private static final int HEAD_LENGTH = 8;

    @Override
    public boolean canParse(SubProtocolType type) {
        return protocolType.equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Protocol parseHead(byte[] data) {
        UdpProtocol protocol = new UdpProtocol();
        UnsignedDataInputStream stream = null;
        try {
            stream = new UnsignedDataInputStream(new ByteArrayInputStream(data));
            int sourcePort = stream.readUnsignedShort();
            protocol.setSourcePort(sourcePort);
            int destinationPort = stream.readUnsignedShort();
            protocol.setDestinationPort(destinationPort);
            int length = stream.readUnsignedShort();
            protocol.setLength(length);
            int checkSum = stream.readUnsignedShort();
            protocol.setCheckSum(checkSum);
            byte[] headData = new byte[8];
            System.arraycopy(data, 0, headData, 0, 8);
            protocol.setHeadData(headData);
            byte[] loadData = new byte[data.length - 8];
            System.arraycopy(data, 8, loadData, 0, loadData.length);
            protocol.setLoadData(loadData);
            TransformProtocolType subProtocolType = new TransformProtocolType(sourcePort, destinationPort);
            protocol.setProtocolTypeFlag(subProtocolType);
            UdpProtocol udpProtocol = protocol;
            return udpProtocol;
        }
        catch (IOException e) {
            UdpProtocol udpProtocol = protocol;
            return udpProtocol;
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    return protocol;
                }
            }
        }
    }
}

