/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.protal;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.IpAttackEvent;
import com.hs.atic.collector.util.CommonUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.protal.IpLocationTransUtil;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ProtalAttackEvent
extends Event {
    private boolean isCreate;
    private long eventId;
    private String startTimeAlert = "";
    private String startTimeClean = "";
    private String endTime = "";
    private String attakcType = "";
    private long dropByptes;
    private long dropPackets;
    private String srcIp = "";

    public ProtalAttackEvent(EventIdentifier identifer) {
        super(identifer);
    }

    public ProtalAttackEvent(IpAttackEvent event) {
        super(event.getIdentifierCopy());
        long ip = IpTransformer.string2LongFormat(this.getZoneIp());
        long locationId = IpLocationTransUtil.getLocationIdByIpAddr(ip, 2).getLocationId();
        this.getIdentifier().setIpLocationId(locationId);
        this.eventId = event.getAbnormalPkId();
        this.startTimeAlert = CommonUtil.transferlong2String(event.getAlertStartTime());
        this.startTimeClean = CommonUtil.transferlong2String(event.getAttackStartTime());
        if (event.isNormal()) {
            long endTimeLong = event.getAlertEndTime() > event.getAttackEndTime() ? event.getAlertEndTime() : event.getAttackEndTime();
            this.endTime = CommonUtil.transferlong2String(endTimeLong);
        }
        this.dropByptes = event.getDropKbits();
        this.dropPackets = event.getDropPkgs();
        this.srcIp = CommonUtil.getIpString(event.getAttackers(), 5000);
    }

    public long getEventId() {
        return this.eventId;
    }

    public void setEventId(long eventId2) {
        this.eventId = eventId2;
    }

    public boolean isIsCreate() {
        return this.isCreate;
    }

    public void setCreate(boolean isCreate2) {
        this.isCreate = isCreate2;
    }

    public String getStartTimeAlert() {
        return this.startTimeAlert;
    }

    public void setStartTimeAlert(String startTimeAlert2) {
        this.startTimeAlert = startTimeAlert2;
    }

    public String getStartTimeClean() {
        return this.startTimeClean;
    }

    public void setStartTimeClean(String startTimeClean2) {
        this.startTimeClean = startTimeClean2;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime2) {
        this.endTime = endTime2;
    }

    public String getAttakcType() {
        return this.attakcType;
    }

    public void setAttakcType(String attakcType2) {
        if (null != attakcType2 && !"".equals(attakcType2.trim())) {
            this.attakcType = attakcType2;
        }
    }

    public long getDropByptes() {
        return this.dropByptes;
    }

    public void setDropByptes(long dropByptes2) {
        this.dropByptes = dropByptes2;
    }

    public long getDropPackets() {
        return this.dropPackets;
    }

    public void setDropPackets(long dropPackets2) {
        this.dropPackets = dropPackets2;
    }

    public String getSrcIp() {
        return this.srcIp;
    }

    public void setSrcIp(String srcIp2) {
        this.srcIp = srcIp2;
    }

    @Override
    public void average(int number) {
    }

    @Override
    public void merge(List<? extends Event> events) {
    }

    public Object getIpLocation() {
        return this.getIdentifier().getIpLocationId();
    }

    @Override
    public String toString() {
        String protalAttack = "ProtalAttackEvent [isCreate=" + this.isCreate + ", eventId=" + this.eventId + ", startTimeAlert=" + this.startTimeAlert + ", startTimeClean=" + this.startTimeClean + ", endTime=" + this.endTime + ", attakcType=" + this.attakcType + ", dropByptes=" + this.dropByptes + ", dropPackets=" + this.dropPackets + ", srcIp=" + this.srcIp + "]";
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("ProtalAttackEvent", (Object)protalAttack).toString();
    }
}

