/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.protal;

import com.hs.atic.collector.entity.event.Event;
import com.hs.atic.collector.entity.event.EventIdentifier;
import com.hs.atic.collector.entity.event.FlowEvent;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.protal.IpLocationTransUtil;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ProtalFlowEvent
extends FlowEvent {
    private long forwardPps;
    private long forwardKbps;
    private long dnsUdpPps;
    private long dnsUdpKbps;

    public ProtalFlowEvent(EventIdentifier identifer) {
        super(identifer);
    }

    @Override
    public void average(int size) {
        super.average(size);
        this.setForwardPps(this.devideUp(this.forwardPps, size));
        this.setForwardKbps(this.devideUp(this.forwardKbps, size));
        this.setDnsUdpPps(this.devideUp(this.dnsUdpPps, size));
        this.setDnsUdpKbps(this.devideUp(this.dnsUdpKbps, size));
    }

    @Override
    public void merge(Event event) {
        if (null != event && event instanceof ProtalFlowEvent) {
            ProtalFlowEvent protalEvent = (ProtalFlowEvent)event;
            super.merge(protalEvent);
            this.setForwardPps(this.forwardPps + protalEvent.getForwardPps());
            this.setForwardKbps(this.forwardKbps + protalEvent.getForwardKbps());
            this.setDnsUdpPps(this.dnsUdpPps + protalEvent.getDnsUdpPps());
            this.setDnsUdpKbps(this.dnsUdpKbps + protalEvent.getDnsUdpKbps());
        }
    }

    public void mergeFlowEvent(FlowEvent event) {
        super.merge(event);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("forwardPps", this.forwardPps).append("forwardKbps", this.forwardKbps).append("dnsUdpPps", this.dnsUdpPps).append("dnsUdpKbps", this.dnsUdpKbps).toString();
    }

    public long getForwardPps() {
        return this.forwardPps;
    }

    public void setForwardPps(long forwardPps2) {
        this.forwardPps = forwardPps2;
    }

    public long getForwardKbps() {
        return this.forwardKbps;
    }

    public void setForwardKbps(long forwardKbps2) {
        this.forwardKbps = forwardKbps2;
    }

    public long getDnsUdpPps() {
        return this.dnsUdpPps;
    }

    public void setDnsUdpPps(long dnsUdpPps2) {
        this.dnsUdpPps = dnsUdpPps2;
    }

    public long getDnsUdpKbps() {
        return this.dnsUdpKbps;
    }

    public void setDnsUdpKbps(long dnsUdpKbps2) {
        this.dnsUdpKbps = dnsUdpKbps2;
    }

    public void setDnsUdpFlow() {
        this.dnsUdpPps = this.getDnsRequestPps() + this.getDnsReplyPps();
        this.dnsUdpKbps = this.getDnsRequestKbps() + this.getDnsRequestKbps();
    }

    public void setLocaionId() {
        long ip = IpTransformer.string2LongFormat(this.getZoneIp());
        long locationId = IpLocationTransUtil.getLocationIdByIpAddr(ip, 2).getLocationId();
        this.getIdentifier().setIpLocationId(locationId);
    }

    public Object getIpLocation() {
        return this.getIdentifier().getIpLocationId();
    }
}

