/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.init;

import com.hs.atic.collector.db.DBConnPool;
import com.hs.atic.collector.util.AticInstallUtil;
import com.hs.atic.collector.util.LogManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class IpChangeTool {
    private static final Logger LOGGER = LogManager.getInstance().getSystemLog();
    private static final String TABLE_NAME = "atic_system_conf";
    private static final String UPDATE_SQL = "UPDATE atic_system_conf set SYS_VALUE =? where SYS_VAR = ?";

    public static void initCheckCollectorIp() {
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        if (1 == version) {
            LOGGER.info((Object)"to ip change check begin.");
            String aticConfigPath = AticInstallUtil.getInstance().getCollectorInstallPath() + File.separator + "conf" + File.separator;
            String sticOldIpPath = aticConfigPath + "collector_service_ip_old";
            String oldIp = IpChangeTool.readToString(sticOldIpPath);
            String currentIp = IpChangeTool.readToString(aticConfigPath + "collector_service_ip");
            LOGGER.info((Object)("begin to ip change,oldIp=" + oldIp + ",currentIp=" + currentIp));
            if (!oldIp.equals(currentIp)) {
                IpChangeTool.saveInDatabase(currentIp);
                LOGGER.info((Object)"modify file content.");
                IpChangeTool.modifyContent(sticOldIpPath, oldIp, currentIp);
            }
            LOGGER.info((Object)"to ip change check leave.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveInDatabase(String currentIp) {
        Connection conn = DBConnPool.getConnection();
        PreparedStatement ps = null;
        if (conn == null) {
            LOGGER.error((Object)"DBConnPool.getConnection() retrun null.");
            return false;
        }
        try {
            conn.setAutoCommit(false);
            LOGGER.info((Object)("update colletor ip: " + currentIp));
            ps = conn.prepareStatement(UPDATE_SQL);
            ps.setString(1, currentIp);
            ps.setString(2, "server_ip");
            ps.addBatch();
            ps.executeBatch();
            conn.commit();
            LOGGER.info((Object)"update collector ip sucessfully.");
            IpChangeTool.closePreparedStatement(ps);
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException e2) {
                LOGGER.error((Object)"rollback error", (Throwable)e2);
            }
            LOGGER.error((Object)"update collector ip error", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            IpChangeTool.closePreparedStatement(ps);
            IpChangeTool.closeConnection(conn);
        }
        IpChangeTool.closeConnection(conn);
        return true;
    }

    private static void closeConnection(Connection conn) {
        try {
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"db connection close faile");
        }
    }

    private static void closePreparedStatement(PreparedStatement ps) {
        try {
            if (null != ps) {
                ps.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"db statement close faile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readToString(String fileName) {
        String content = null;
        String encoding = "UTF-8";
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            Long filelength = file.length();
            byte[] filecontent = new byte[filelength.intValue()];
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                while (-1 != in.read(filecontent)) {
                    content = new String(filecontent, 0, filecontent.length, encoding);
                }
                String string = content;
                return string;
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)"no file.", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error((Object)"read error", (Throwable)e);
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"close error.", (Throwable)e);
                    }
                }
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean modifyContent(String filePath, String key, String value) {
        FileInputStream fiStream = null;
        InputStreamReader inReader = null;
        BufferedReader br = null;
        FileOutputStream foStream = null;
        OutputStreamWriter outReader = null;
        BufferedWriter bw = null;
        StringBuffer sbf = new StringBuffer();
        try {
            fiStream = new FileInputStream(filePath);
            inReader = new InputStreamReader((InputStream)fiStream, "gbk");
            br = new BufferedReader(inReader);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.contains(key)) {
                    line = line.replace(key, value);
                }
                sbf.append(line);
            }
            foStream = new FileOutputStream(filePath, false);
            outReader = new OutputStreamWriter((OutputStream)foStream, "gbk");
            bw = new BufferedWriter(outReader);
            bw.write(sbf.toString());
        }
        catch (IOException e) {
            boolean bl;
            try {
                LOGGER.error((Object)"write error");
                bl = false;
            }
            catch (Throwable throwable) {
                IpChangeTool.closeBufferedReader(br);
                IpChangeTool.closeInputStreamReader(inReader);
                IpChangeTool.closeFileInputStream(fiStream);
                IpChangeTool.closeBufferedWriter(bw);
                IpChangeTool.closeOutputStreamWriter(outReader);
                IpChangeTool.closeFileOutputStream(foStream);
                throw throwable;
            }
            IpChangeTool.closeBufferedReader(br);
            IpChangeTool.closeInputStreamReader(inReader);
            IpChangeTool.closeFileInputStream(fiStream);
            IpChangeTool.closeBufferedWriter(bw);
            IpChangeTool.closeOutputStreamWriter(outReader);
            IpChangeTool.closeFileOutputStream(foStream);
            return bl;
        }
        IpChangeTool.closeBufferedReader(br);
        IpChangeTool.closeInputStreamReader(inReader);
        IpChangeTool.closeFileInputStream(fiStream);
        IpChangeTool.closeBufferedWriter(bw);
        IpChangeTool.closeOutputStreamWriter(outReader);
        IpChangeTool.closeFileOutputStream(foStream);
        return true;
    }

    private static void closeBufferedReader(BufferedReader br) {
        if (null != br) {
            try {
                br.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"when close br error happen.I can do nothing");
            }
        }
    }

    private static void closeInputStreamReader(InputStreamReader inReader) {
        if (null != inReader) {
            try {
                inReader.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"when close inReader error happen.I can do nothing");
            }
        }
    }

    private static void closeFileInputStream(FileInputStream fiStream) {
        if (null != fiStream) {
            try {
                fiStream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"when close fileReader error happen.I can do nothing");
            }
        }
    }

    private static void closeBufferedWriter(BufferedWriter bw) {
        if (null != bw) {
            try {
                bw.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"when close bw error happen.I can do nothing");
            }
        }
    }

    private static void closeOutputStreamWriter(OutputStreamWriter outReader) {
        if (null != outReader) {
            try {
                outReader.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"when close outReader error happen.I can do nothing");
            }
        }
    }

    private static void closeFileOutputStream(FileOutputStream foStream) {
        if (null != foStream) {
            try {
                foStream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"when close foStream error happen.I can do nothing");
            }
        }
    }
}

