/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.manager.agent;

import com.hs.atic.collector.manager.agent.resource.MBeanResourceFactory;
import com.hs.atic.collector.util.LogManager;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class CollectorJmxAgent {
    private static final Logger LOGGER = LogManager.getInstance().getJmxLog();
    MBeanServer server;
    List<ObjectName> objectName = new ArrayList<ObjectName>();

    public void start(int port) {
        this.server = MBeanServerFactory.createMBeanServer("Collector");
        ObjectName jvmInfoName = null;
        ObjectName unresolvedBinaryPacketName = null;
        ObjectName flowMessage70secName = null;
        ObjectName flowMessage5minName = null;
        ObjectName flowMessage1hourName = null;
        ObjectName abnormalFlowName = null;
        ObjectName blacklistFlowName = null;
        ObjectName packetCaptureName = null;
        ObjectName baselineInfoName = null;
        ObjectName serviceLearningInfoName = null;
        ObjectName srcAndContentTopNFlowName = null;
        Object botnetTrojanhorsesWormsName = null;
        ObjectName dnsDefendFlowName = null;
        ObjectName dashboardInfoName = null;
        ObjectName alarmMessageName = null;
        try {
            jvmInfoName = new ObjectName("Collector:name=JVMInfo");
            this.server.registerMBean(MBeanResourceFactory.JVM_INFO, jvmInfoName);
            this.objectName.add(jvmInfoName);
            unresolvedBinaryPacketName = new ObjectName("Collector:name=UnresolvedBinaryPacket");
            this.server.registerMBean(MBeanResourceFactory.UNRESOLVED_BINARY_PACKET, unresolvedBinaryPacketName);
            this.objectName.add(unresolvedBinaryPacketName);
            flowMessage70secName = new ObjectName("Collector:name=FlowMessage70sec");
            this.server.registerMBean(MBeanResourceFactory.FLOW_MESSAGE_70SEC, flowMessage70secName);
            this.objectName.add(flowMessage70secName);
            flowMessage5minName = new ObjectName("Collector:name=FlowMessage5min");
            this.server.registerMBean(MBeanResourceFactory.FLOW_MESSAGE_5MIN, flowMessage5minName);
            this.objectName.add(flowMessage5minName);
            flowMessage1hourName = new ObjectName("Collector:name=FlowMessage1hour");
            this.server.registerMBean(MBeanResourceFactory.FLOW_MESSAGE_1HOUR, flowMessage1hourName);
            this.objectName.add(flowMessage1hourName);
            abnormalFlowName = new ObjectName("Collector:name=AbnormalFlow");
            this.server.registerMBean(MBeanResourceFactory.ABNORMAL_FLOW, abnormalFlowName);
            this.objectName.add(abnormalFlowName);
            blacklistFlowName = new ObjectName("Collector:name=BlacklistFlow");
            this.server.registerMBean(MBeanResourceFactory.BLACKLIST_FLOW, blacklistFlowName);
            this.objectName.add(blacklistFlowName);
            packetCaptureName = new ObjectName("Collector:name=PacketCapture");
            this.server.registerMBean(MBeanResourceFactory.PACKET_CAPTURE, packetCaptureName);
            this.objectName.add(packetCaptureName);
            baselineInfoName = new ObjectName("Collector:name=BaselineInfo");
            this.server.registerMBean(MBeanResourceFactory.BASELINE_INFO, baselineInfoName);
            this.objectName.add(baselineInfoName);
            serviceLearningInfoName = new ObjectName("Collector:name=ServiceLearningInfo");
            this.server.registerMBean(MBeanResourceFactory.SERVICE_LEARNING_INFO, serviceLearningInfoName);
            this.objectName.add(serviceLearningInfoName);
            srcAndContentTopNFlowName = new ObjectName("Collector:name=SrcAndContentTopNFlow");
            this.server.registerMBean(MBeanResourceFactory.SRC_AND_CONTENT_TOPN_FLOW, srcAndContentTopNFlowName);
            this.objectName.add(srcAndContentTopNFlowName);
            dnsDefendFlowName = new ObjectName("Collector:name=DnsDefendFlow");
            this.server.registerMBean(MBeanResourceFactory.DNS_DEFEND_FLOW, dnsDefendFlowName);
            this.objectName.add(dnsDefendFlowName);
            dashboardInfoName = new ObjectName("Collector:name=DashboardInfo");
            this.server.registerMBean(MBeanResourceFactory.DASHBOARD_INFO, dashboardInfoName);
            this.objectName.add(dashboardInfoName);
            alarmMessageName = new ObjectName("Collector:name=AlarmMessage");
            this.server.registerMBean(MBeanResourceFactory.ALARM_MESSAGE, alarmMessageName);
            this.objectName.add(alarmMessageName);
        }
        catch (MalformedObjectNameException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void shutdown() {
        for (ObjectName name : this.objectName) {
            try {
                if (null == this.server) continue;
                this.server.unregisterMBean(name);
            }
            catch (MBeanRegistrationException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InstanceNotFoundException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.objectName = new ArrayList<ObjectName>();
    }
}

