/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.manager.control;

import com.hs.atic.collector.biz.alarm.AlarmThread;
import com.hs.atic.collector.biz.event.process.EventPacketParser;
import com.hs.atic.collector.biz.pcap.PcapBuilder;
import com.hs.atic.collector.entity.alarm.DropLogAlarmEntity;
import com.hs.atic.collector.entity.alarm.MemoryAlarmEntity;
import com.hs.atic.collector.manager.agent.resource.MBeanResourceFactory;
import com.hs.atic.collector.util.EventUtil;
import com.hs.atic.collector.util.LogManager;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import org.apache.log4j.Logger;

public class MemoryControl
implements Runnable {
    public static final Logger LOGGER = LogManager.getInstance().getJmxLog();
    private static boolean isAlarmEnable;
    private static final int LOG_SLEEP_TIME = 60000;
    private static final int LOG_TYPE_SINGLE = 0;
    private static final int LOG_TYPE_GLOBAL = 1;
    private static final int LOG_LEVEL_0 = 0;
    private static final int LOG_LEVEL_1 = 1;
    private static final int LOG_LEVEL_2 = 2;
    private static final int LOG_LEVEL_3 = 3;
    private static final int LOG_LEVEL_4 = 4;
    private static final int LOG_LEVEL_5 = 5;
    private static final int UP_LEVEL_SEG = 300000;
    private static final int DOWN_LEVEL_SEG = 180000;
    private static final int MEMORY_OVER_MAX_LEVEL = 5;
    private static MemoryControl instance;
    private int warnLevel;
    private long curTime;
    private long lastTime;
    private long warnUpOutTime;
    private long warnDownOutTime;
    private boolean memoryWarn;
    private boolean serviceLearningOverThreshold;
    private List<EventPacketParser> parser;
    private boolean captureOverLevel;
    private boolean captureOverThreshold;
    private boolean flowOverLevel;
    private boolean flowOverThreshold;
    private boolean abnormalOverLevel;
    private boolean abnormalOverThreshold;
    private boolean srcAndContentOverLevel;
    private boolean srcAndContentOverThreshold;
    private boolean blacklistOverLevel;
    private boolean blacklistOverThreshold;

    public static MemoryControl getInstance() {
        if (null == instance) {
            instance = new MemoryControl();
        }
        return instance;
    }

    public void setParser(List<EventPacketParser> parser) {
        this.parser = parser;
    }

    private static void initMemoryLimitAlarmSwitch() {
        try {
            isAlarmEnable = Boolean.valueOf(EventUtil.getEventConfigProperty("memoryLimitAlarmSwitch"));
        }
        catch (Exception e) {
            isAlarmEnable = false;
            LOGGER.error((Object)"getMemoryLimitAlarmSwitch error", (Throwable)e);
        }
    }

    protected void controlFlow() {
        if (!(this.flowOverThreshold || MBeanResourceFactory.FLOW_MESSAGE_70SEC.getAllEventCount() <= MBeanResourceFactory.getMaxFlowCount() && MBeanResourceFactory.FLOW_MESSAGE_5MIN.getAllEventCount() <= MBeanResourceFactory.getMaxFlowCount() * 2)) {
            this.log("start flow control----->");
            this.log(MBeanResourceFactory.FLOW_MESSAGE_70SEC);
            this.log(MBeanResourceFactory.FLOW_MESSAGE_5MIN);
            this.log(MBeanResourceFactory.FLOW_MESSAGE_1HOUR);
            this.flowOverThreshold = true;
            for (EventPacketParser e : this.parser) {
                e.setFlowOverThreshold(this.flowOverThreshold);
            }
            this.sendWarnLog(true, 4, MBeanResourceFactory.getMaxFlowCount(), MBeanResourceFactory.FLOW_MESSAGE_70SEC.getAllEventCount(), 0);
            this.sendDropLogWarnLog(0, 4, true, MBeanResourceFactory.getMaxFlowCount(), MBeanResourceFactory.FLOW_MESSAGE_70SEC.getAllEventCount(), 0);
        }
        if (this.flowOverThreshold && MBeanResourceFactory.FLOW_MESSAGE_70SEC.getAllEventCount() < MBeanResourceFactory.getMinFlowCount() && MBeanResourceFactory.FLOW_MESSAGE_5MIN.getAllEventCount() < MBeanResourceFactory.getMinFlowCount() * 2) {
            this.log("end flow control----->");
            this.log(MBeanResourceFactory.FLOW_MESSAGE_70SEC);
            this.log(MBeanResourceFactory.FLOW_MESSAGE_5MIN);
            this.log(MBeanResourceFactory.FLOW_MESSAGE_1HOUR);
            this.flowOverThreshold = false;
            for (EventPacketParser e : this.parser) {
                e.setFlowOverThreshold(this.flowOverThreshold);
            }
            this.sendWarnLog(false, 4, MBeanResourceFactory.getMaxFlowCount(), MBeanResourceFactory.FLOW_MESSAGE_70SEC.getAllEventCount(), 0);
            this.sendDropLogWarnLog(0, 4, false, MBeanResourceFactory.getMaxFlowCount(), MBeanResourceFactory.FLOW_MESSAGE_70SEC.getAllEventCount(), 0);
        }
    }

    protected void controlServiceLearning() {
        int count = MBeanResourceFactory.SERVICE_LEARNING_INFO.getServiceLearningResultRecord();
        if (count > MBeanResourceFactory.getMaxServiceLearingCount() && !this.serviceLearningOverThreshold) {
            this.serviceLearningOverThreshold = true;
            for (EventPacketParser e : this.parser) {
                e.setBizOverThreshold(this.serviceLearningOverThreshold);
            }
            this.log("start service learning control----->");
            this.log(MBeanResourceFactory.SERVICE_LEARNING_INFO);
        }
        if (count < MBeanResourceFactory.getMaxServiceLearingCount() && this.serviceLearningOverThreshold) {
            this.serviceLearningOverThreshold = false;
            for (EventPacketParser e : this.parser) {
                e.setBizOverThreshold(this.serviceLearningOverThreshold);
            }
            this.log("end service learning control----->");
            this.log(MBeanResourceFactory.SERVICE_LEARNING_INFO);
        }
    }

    protected void controlAbnormal() {
        int count = MBeanResourceFactory.ABNORMAL_FLOW.getIpAndTypeAbnormalNum();
        int min5Count = MBeanResourceFactory.ABNORMAL_FLOW.getIpAttackFlow5minNum();
        if (!(this.abnormalOverThreshold || count <= MBeanResourceFactory.getMaxAbnormalCount() && min5Count <= MBeanResourceFactory.getMaxAbnormalCount())) {
            this.abnormalOverThreshold = true;
            for (EventPacketParser e : this.parser) {
                e.setAbnormalOverThreshold(this.abnormalOverThreshold);
            }
            this.log("start abnormal control----->");
            this.log(MBeanResourceFactory.ABNORMAL_FLOW);
            this.sendWarnLog(true, 5, MBeanResourceFactory.getMaxAbnormalCount(), count, 0);
            this.sendDropLogWarnLog(0, 5, true, MBeanResourceFactory.getMaxAbnormalCount(), count, 0);
        }
        if (this.abnormalOverThreshold && count < MBeanResourceFactory.getMinAbnormalCount() && min5Count < MBeanResourceFactory.getMinAbnormalCount()) {
            this.abnormalOverThreshold = false;
            for (EventPacketParser e : this.parser) {
                e.setAbnormalOverThreshold(this.abnormalOverThreshold);
            }
            this.log("end abnormal control----->");
            this.log(MBeanResourceFactory.ABNORMAL_FLOW);
            this.sendWarnLog(false, 5, MBeanResourceFactory.getMaxAbnormalCount(), count, 0);
            this.sendDropLogWarnLog(0, 5, false, MBeanResourceFactory.getMaxAbnormalCount(), count, 0);
        }
    }

    protected void controlSrcAndContent() {
        int count = MBeanResourceFactory.SRC_AND_CONTENT_TOPN_FLOW.getAllEventCount();
        if (count > MBeanResourceFactory.getMaxSrcandcontentTopnCount() && !this.srcAndContentOverThreshold) {
            this.srcAndContentOverThreshold = true;
            for (EventPacketParser e : this.parser) {
                e.setSrcAndContentOverThreshold(this.srcAndContentOverThreshold);
            }
            this.log("start src and content control----->");
            this.log(MBeanResourceFactory.SRC_AND_CONTENT_TOPN_FLOW);
            this.sendWarnLog(true, 3, MBeanResourceFactory.getMaxSrcandcontentTopnCount(), count, 0);
            this.sendDropLogWarnLog(0, 3, true, MBeanResourceFactory.getMaxSrcandcontentTopnCount(), count, 0);
        }
        if (count < MBeanResourceFactory.getMinSrcandcontentTopnCount() && this.srcAndContentOverThreshold) {
            this.srcAndContentOverThreshold = false;
            for (EventPacketParser e : this.parser) {
                e.setSrcAndContentOverThreshold(this.srcAndContentOverThreshold);
            }
            this.log("end src and content control----->");
            this.log(MBeanResourceFactory.SRC_AND_CONTENT_TOPN_FLOW);
            this.sendWarnLog(false, 3, MBeanResourceFactory.getMaxSrcandcontentTopnCount(), count, 0);
            this.sendDropLogWarnLog(0, 3, false, MBeanResourceFactory.getMaxSrcandcontentTopnCount(), count, 0);
        }
    }

    protected void controlCapture() {
        int count = MBeanResourceFactory.PACKET_CAPTURE.getAllCaptureFileSize();
        if (count > MBeanResourceFactory.getMaxCpatureCount() && !this.captureOverThreshold) {
            this.captureOverThreshold = true;
            PcapBuilder.getInstance().setCaptureOverThreshold(this.captureOverThreshold);
            this.log("start capture control----->");
            this.log(MBeanResourceFactory.PACKET_CAPTURE);
            this.sendWarnLog(true, 2, MBeanResourceFactory.getMaxCpatureCount(), count, 0);
            this.sendDropLogWarnLog(0, 2, true, MBeanResourceFactory.getMaxCpatureCount(), count, 0);
        }
        if (count < MBeanResourceFactory.getMaxCpatureCount() && this.captureOverThreshold) {
            this.captureOverThreshold = false;
            PcapBuilder.getInstance().setCaptureOverThreshold(this.captureOverThreshold);
            this.log("end capture control----->");
            this.log(MBeanResourceFactory.PACKET_CAPTURE);
            this.sendWarnLog(false, 2, MBeanResourceFactory.getMaxCpatureCount(), count, 0);
            this.sendDropLogWarnLog(0, 2, false, MBeanResourceFactory.getMaxCpatureCount(), count, 0);
        }
    }

    private void controlBlacklist() {
        int cacheCount = MBeanResourceFactory.BLACKLIST_FLOW.getBlackListIpsNum();
        int parseCount = MBeanResourceFactory.BLACKLIST_FLOW.getParseBlackListNum();
        int maxNum = MBeanResourceFactory.getMaxBlackListCount();
        int minNum = MBeanResourceFactory.getMinBlackListFlowCount();
        if (!(this.blacklistOverThreshold || cacheCount <= maxNum && parseCount <= maxNum)) {
            this.blacklistOverThreshold = true;
            for (EventPacketParser e : this.parser) {
                e.setZoneBlackListOverThreshold(true);
            }
            this.log("start zone blacklist control----->maxBlackListCount=" + maxNum + ", and now blacklist cacheCount=" + cacheCount + ", parseCount=" + parseCount);
            this.sendWarnLog(true, 1, maxNum, cacheCount, parseCount);
            this.sendDropLogWarnLog(0, 1, true, maxNum, cacheCount, parseCount);
        }
        if (this.blacklistOverThreshold && cacheCount <= minNum && parseCount <= minNum) {
            this.blacklistOverThreshold = false;
            for (EventPacketParser e : this.parser) {
                e.setZoneBlackListOverThreshold(false);
            }
            this.log("end zone blacklist control----->minBlackListCount=" + minNum + ", and now blacklist cacheCount=" + cacheCount + ", parseCount=" + parseCount);
            this.sendWarnLog(false, 1, maxNum, cacheCount, parseCount);
            this.sendDropLogWarnLog(0, 1, false, maxNum, cacheCount, parseCount);
        }
    }

    protected void control() {
        if (null != this.parser) {
            this.controlFlow();
            this.controlServiceLearning();
            this.controlAbnormal();
            this.controlSrcAndContent();
            this.controlCapture();
            this.controlBlacklist();
        }
    }

    protected void sendWarnLog(boolean flag, int level, int param1, int param2, int param3) {
        MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = bean.getHeapMemoryUsage();
        MemoryAlarmEntity memoryEntity = null;
        boolean condOne = false;
        boolean condTwo = false;
        if (this.memoryWarn || this.captureOverThreshold || this.flowOverThreshold) {
            condOne = true;
        }
        if (this.abnormalOverThreshold || this.srcAndContentOverThreshold || this.blacklistOverThreshold) {
            condTwo = true;
        }
        if (!flag && (condOne || condTwo)) {
            return;
        }
        long usedMemory = memoryUsage.getUsed() / 0x100000L;
        long maxMemory = MBeanResourceFactory.CAN_USED_MAX_JVMMEMORY * 85 / 100;
        int usedFlow = MBeanResourceFactory.FLOW_MESSAGE_70SEC.getAllEventCount();
        int maxFlow = MBeanResourceFactory.getMaxFlowCount();
        int usedAbnormal = MBeanResourceFactory.ABNORMAL_FLOW.getIpAndTypeAbnormalNum();
        int maxAbnormal = MBeanResourceFactory.getMaxAbnormalCount();
        int usedSrcAndContent = MBeanResourceFactory.SRC_AND_CONTENT_TOPN_FLOW.getAllEventCount();
        int maxSrcAndContent = MBeanResourceFactory.getMaxSrcandcontentTopnCount();
        int usedCapture = MBeanResourceFactory.PACKET_CAPTURE.getAllCaptureFileSize();
        int maxCapture = MBeanResourceFactory.getMaxCpatureCount();
        int usedCacheBlack = MBeanResourceFactory.BLACKLIST_FLOW.getBlackListIpsNum();
        int usedParseBlack = MBeanResourceFactory.BLACKLIST_FLOW.getParseBlackListNum();
        int maxBlacklist = MBeanResourceFactory.getMaxBlackListCount();
        if (level == 0) {
            maxMemory = param1;
            usedMemory = param2;
        } else if (level == 1) {
            maxBlacklist = param1;
            usedCacheBlack = param2;
            usedParseBlack = param3;
        } else if (level == 2) {
            maxCapture = param1;
            usedCapture = param2;
        } else if (level == 3) {
            maxSrcAndContent = param1;
            usedSrcAndContent = param2;
        } else if (level == 4) {
            maxFlow = param1;
            usedFlow = param2;
        } else if (level == 5) {
            maxAbnormal = param1;
            usedAbnormal = param2;
        }
        memoryEntity = new MemoryAlarmEntity();
        memoryEntity.setAlarm(flag);
        memoryEntity.setUsedMemory(String.valueOf(usedMemory));
        memoryEntity.setMaxMemory(String.valueOf(maxMemory));
        memoryEntity.setUsedFlow(String.valueOf(usedFlow));
        memoryEntity.setMaxFlow(String.valueOf(maxFlow));
        memoryEntity.setUsedAbnormal(String.valueOf(usedAbnormal));
        memoryEntity.setMaxAbnormal(String.valueOf(maxAbnormal));
        memoryEntity.setUsedSrcAndContent(String.valueOf(usedSrcAndContent));
        memoryEntity.setMaxSrcAndContent(String.valueOf(maxSrcAndContent));
        memoryEntity.setUsedCapture(String.valueOf(usedCapture));
        memoryEntity.setMaxCapture(String.valueOf(maxCapture));
        memoryEntity.setUsedCacheBlack(String.valueOf(usedCacheBlack));
        memoryEntity.setUsedParseBlack(String.valueOf(usedParseBlack));
        memoryEntity.setMaxBlacklist(String.valueOf(maxBlacklist));
        memoryEntity.setSeverity(3);
        if (isAlarmEnable) {
            AlarmThread.getInstance().addMemoryAlarm(memoryEntity);
        }
        this.log("memory warn usedMemory:" + usedMemory + " maxMemory:" + maxMemory + " usedFlow:" + usedFlow + " maxFlow:" + maxFlow + " usedAbnormal:" + usedAbnormal + " maxAbnormal:" + maxAbnormal + " usedSrcAndContent:" + usedSrcAndContent + " maxSrcAndContent:" + maxSrcAndContent + " usedCapture:" + usedCapture + " maxCapture:" + maxCapture + " usedCacheBlack:" + usedCacheBlack + " usedParseBlack:" + usedParseBlack + " maxBlacklist:" + maxBlacklist);
    }

    protected void sendDropLogWarnLog(int logType, int logLevel, boolean flag, int param1, int param2, int param3) {
        MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = bean.getHeapMemoryUsage();
        DropLogAlarmEntity dropLogEntity = null;
        int maxCount = 0;
        int usedCount = 0;
        switch (logLevel) {
            case 1: {
                int maxBlacklist = 0;
                int cacheCount = 0;
                int parseCount = 0;
                if (logType == 1) {
                    maxBlacklist = MBeanResourceFactory.getMaxBlackListCount();
                    cacheCount = MBeanResourceFactory.BLACKLIST_FLOW.getBlackListIpsNum();
                    parseCount = MBeanResourceFactory.BLACKLIST_FLOW.getParseBlackListNum();
                } else {
                    maxBlacklist = param1;
                    cacheCount = param2;
                    parseCount = param3;
                }
                maxCount = maxBlacklist;
                if (cacheCount > parseCount) {
                    usedCount = cacheCount;
                    break;
                }
                usedCount = parseCount;
                break;
            }
            case 2: {
                int maxCapture = 0;
                int usedCapture = 0;
                if (logType == 1) {
                    maxCapture = MBeanResourceFactory.getMaxCpatureCount();
                    usedCapture = MBeanResourceFactory.PACKET_CAPTURE.getAllCaptureFileSize();
                } else {
                    maxCapture = param1;
                    usedCapture = param2;
                }
                maxCount = maxCapture;
                usedCount = usedCapture;
                break;
            }
            case 3: {
                int maxSrcAndContent = 0;
                int usedSrcAndContent = 0;
                if (logType == 1) {
                    maxSrcAndContent = MBeanResourceFactory.getMaxSrcandcontentTopnCount();
                    usedSrcAndContent = MBeanResourceFactory.SRC_AND_CONTENT_TOPN_FLOW.getAllEventCount();
                } else {
                    maxSrcAndContent = param1;
                    usedSrcAndContent = param2;
                }
                maxCount = maxSrcAndContent;
                usedCount = usedSrcAndContent;
                break;
            }
            case 4: {
                int maxFlow = 0;
                int usedFlow = 0;
                if (logType == 1) {
                    maxFlow = MBeanResourceFactory.getMaxFlowCount();
                    usedFlow = MBeanResourceFactory.FLOW_MESSAGE_70SEC.getAllEventCount();
                } else {
                    maxFlow = param1;
                    usedFlow = param2;
                }
                maxCount = maxFlow;
                usedCount = usedFlow;
                break;
            }
            case 5: {
                int maxFlow = 0;
                int usedFlow = 0;
                if (logType == 1) {
                    maxFlow = MBeanResourceFactory.getMaxAbnormalCount();
                    usedFlow = MBeanResourceFactory.ABNORMAL_FLOW.getIpAndTypeAbnormalNum();
                } else {
                    maxFlow = param1;
                    usedFlow = param2;
                }
                maxCount = maxFlow;
                usedCount = usedFlow;
                break;
            }
        }
        long usedMemory = memoryUsage.getUsed() / 0x100000L;
        long maxMemory = MBeanResourceFactory.CAN_USED_MAX_JVMMEMORY * 85 / 100;
        if (logType == 1) {
            maxMemory = param1;
            usedMemory = param2;
        }
        dropLogEntity = new DropLogAlarmEntity();
        dropLogEntity.setAlarm(flag);
        dropLogEntity.setLogType(logType);
        dropLogEntity.setLogLevel(logLevel);
        dropLogEntity.setUsedMemory(String.valueOf(usedMemory));
        dropLogEntity.setMaxMemory(String.valueOf(maxMemory));
        dropLogEntity.setUsedCount(String.valueOf(usedCount));
        dropLogEntity.setMaxCount(String.valueOf(maxCount));
        dropLogEntity.setSeverity(3);
        if (isAlarmEnable) {
            AlarmThread.getInstance().addDropLogAlarm(dropLogEntity);
        }
        this.log("drop log warn logType:" + logType + " logLevel:" + logLevel + " usedMemory:" + usedMemory + " maxMemory:" + maxMemory + " usedCount:" + usedCount + " maxCount:" + maxCount);
    }

    protected void memoryCheck() {
        long nowTime = 0L;
        long curInter = 0L;
        long internal = 0L;
        int logLevel = 0;
        int maxMemory = MBeanResourceFactory.CAN_USED_MAX_JVMMEMORY * 85 / 100;
        int minMemory = MBeanResourceFactory.CAN_USED_MAX_JVMMEMORY * 70 / 100;
        MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = bean.getHeapMemoryUsage();
        int usedMemory = (int)memoryUsage.getUsed() / 0x100000;
        nowTime = System.currentTimeMillis();
        curInter = nowTime - this.lastTime;
        if (curInter < (internal = this.memoryWarn ? 6000L : 1000L)) {
            return;
        }
        if (!this.memoryWarn && usedMemory > maxMemory) {
            this.log("start memory warn ----->");
            this.log(memoryUsage);
            this.log(maxMemory);
            this.memoryWarn = true;
            this.sendWarnLog(true, logLevel, maxMemory, usedMemory, 0);
        }
        if (this.memoryWarn && usedMemory < minMemory) {
            this.log("end memory warn----->");
            this.log(usedMemory);
            this.log(minMemory);
            this.memoryWarn = false;
            this.sendWarnLog(false, logLevel, maxMemory, usedMemory, 0);
        }
    }

    protected void warnLevelStatusSet(int level, boolean value) {
        switch (level) {
            case 1: {
                this.blacklistOverLevel = value;
                for (EventPacketParser e : this.parser) {
                    e.setZoneBlackListOverLevel(this.blacklistOverLevel);
                }
                break;
            }
            case 2: {
                this.captureOverLevel = value;
                PcapBuilder.getInstance().setCaptureOverLevel(this.captureOverLevel);
                break;
            }
            case 3: {
                this.srcAndContentOverLevel = value;
                for (EventPacketParser e : this.parser) {
                    e.setSrcAndContentOverLevel(this.srcAndContentOverLevel);
                }
                break;
            }
            case 4: {
                this.flowOverLevel = value;
                for (EventPacketParser e : this.parser) {
                    e.setFlowOverLevel(this.flowOverLevel);
                }
                break;
            }
            case 5: {
                this.abnormalOverLevel = value;
                for (EventPacketParser e : this.parser) {
                    e.setAbnormalOverLevel(this.abnormalOverLevel);
                }
                break;
            }
            default: {
                LOGGER.error((Object)("warnLevelStatusSet error default [level:" + level + " value:" + value + "]."));
            }
        }
    }

    protected void logSpecificationLimit() {
        int level = 0;
        int param3 = 0;
        long nowTime = System.currentTimeMillis();
        int maxMemory = MBeanResourceFactory.CAN_USED_MAX_JVMMEMORY * 85 / 100;
        int minMemory = MBeanResourceFactory.CAN_USED_MAX_JVMMEMORY * 70 / 100;
        MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = bean.getHeapMemoryUsage();
        int usedMemory = (int)(memoryUsage.getUsed() / 0x100000L);
        if (usedMemory > maxMemory) {
            if (this.warnLevel != 0) {
                if (nowTime > this.warnUpOutTime) {
                    level = this.warnLevel;
                    this.warnUpOutTime = nowTime + 300000L;
                    this.sendDropLogWarnLog(1, level, true, maxMemory, usedMemory, param3);
                    if (level >= 5) {
                        return;
                    }
                    this.warnLevelStatusSet(level, true);
                    if (this.warnLevel < 5) {
                        ++this.warnLevel;
                    }
                }
            } else {
                this.warnLevel = 1;
                this.warnUpOutTime = System.currentTimeMillis();
            }
        } else if (usedMemory < minMemory) {
            if (this.warnLevel > 0) {
                if (nowTime > this.warnDownOutTime) {
                    --this.warnLevel;
                    level = this.warnLevel;
                    this.warnDownOutTime = nowTime + 180000L;
                    this.warnLevelStatusSet(level, false);
                    if (level > 0) {
                        this.sendDropLogWarnLog(1, level, true, maxMemory, usedMemory, param3);
                    } else {
                        this.sendDropLogWarnLog(1, 1, false, maxMemory, usedMemory, param3);
                    }
                    this.warnUpOutTime = nowTime + 300000L;
                }
            } else {
                this.warnDownOutTime = System.currentTimeMillis();
            }
        }
    }

    protected void log(Object o) {
        LOGGER.info(o);
    }

    protected void debugLog(Object o) {
        LOGGER.debug(o);
    }

    protected void printLog() {
        if (System.currentTimeMillis() - this.curTime > 60000L) {
            if (LOGGER.isDebugEnabled()) {
                this.debugLog("START PRINT LOG ------>");
                this.debugLog(MBeanResourceFactory.JVM_INFO);
                this.debugLog(MBeanResourceFactory.UNRESOLVED_BINARY_PACKET);
                this.debugLog(MBeanResourceFactory.FLOW_MESSAGE_70SEC);
                this.debugLog(MBeanResourceFactory.FLOW_MESSAGE_5MIN);
                this.debugLog(MBeanResourceFactory.FLOW_MESSAGE_1HOUR);
                this.debugLog(MBeanResourceFactory.SERVICE_LEARNING_INFO);
                this.debugLog(MBeanResourceFactory.ABNORMAL_FLOW);
                this.debugLog(MBeanResourceFactory.SRC_AND_CONTENT_TOPN_FLOW);
                this.debugLog(MBeanResourceFactory.PACKET_CAPTURE);
                this.debugLog("END PRINT LOG ------>");
            }
            this.curTime = System.currentTimeMillis();
        }
    }

    @Override
    public void run() {
        this.lastTime = this.curTime = System.currentTimeMillis();
        MemoryControl.initMemoryLimitAlarmSwitch();
        while (true) {
            try {
                while (true) {
                    this.control();
                    this.printLog();
                    this.memoryCheck();
                    this.logSpecificationLimit();
                    Thread.sleep(5L);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"JmxControl check memery error!", (Throwable)e);
                continue;
            }
            break;
        }
    }

    static {
        instance = new MemoryControl();
    }
}

