/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.manager.mbean;

import com.hs.atic.collector.biz.event.process.SumCycEvent;
import com.hs.atic.collector.biz.event.process.Type;
import com.hs.atic.collector.entity.event.AttackTypeEvent;
import com.hs.atic.collector.entity.event.ExceptionEvent;
import com.hs.atic.collector.entity.event.IpAttackEvent;
import com.hs.atic.collector.manager.mbean.AbnormalFlowMBean;
import com.hs.atic.rmi.IpStateData;
import java.util.List;
import java.util.Map;

public class AbnormalFlow
implements AbnormalFlowMBean {
    private static final int ZERO = 0;
    private Map<Type, ExceptionEvent> cleanExceptionRecords;
    private Map<Type, ExceptionEvent> detectExceptionRecords;
    private Map<Type, IpAttackEvent> cleanIpAttackRecords;
    private Map<Type, IpAttackEvent> detectIpAttackRecords;
    private Map<Type, SumCycEvent<AttackTypeEvent>> ipEventMaps;
    private Map<Type, AttackTypeEvent> attackTypeEventCache;
    private List<IpStateData> startData;
    private Map<IpStateData, Long> endData;

    public Map<Type, ExceptionEvent> getCleanExceptionRecords() {
        return this.cleanExceptionRecords;
    }

    public void setCleanExceptionRecords(Map<Type, ExceptionEvent> cleanExceptionRecords) {
        this.cleanExceptionRecords = cleanExceptionRecords;
    }

    public Map<Type, ExceptionEvent> getDetectExceptionRecords() {
        return this.detectExceptionRecords;
    }

    public void setDetectExceptionRecords(Map<Type, ExceptionEvent> detectExceptionRecords) {
        this.detectExceptionRecords = detectExceptionRecords;
    }

    public Map<Type, IpAttackEvent> getCleanIpAttackRecords() {
        return this.cleanIpAttackRecords;
    }

    public void setCleanIpAttackRecords(Map<Type, IpAttackEvent> cleanIpAttackRecords) {
        this.cleanIpAttackRecords = cleanIpAttackRecords;
    }

    public Map<Type, IpAttackEvent> getDetectIpAttackRecords() {
        return this.detectIpAttackRecords;
    }

    public void setDetectIpAttackRecords(Map<Type, IpAttackEvent> detectIpAttackRecords) {
        this.detectIpAttackRecords = detectIpAttackRecords;
    }

    public Map<Type, SumCycEvent<AttackTypeEvent>> getIpEventMaps() {
        return this.ipEventMaps;
    }

    public void setIpEventMaps(Map<Type, SumCycEvent<AttackTypeEvent>> ipEventMaps) {
        this.ipEventMaps = ipEventMaps;
    }

    public Map<Type, AttackTypeEvent> getAttackTypeEventCache() {
        return this.attackTypeEventCache;
    }

    public void setAttackTypeEventCache(Map<Type, AttackTypeEvent> attackTypeEventCache) {
        this.attackTypeEventCache = attackTypeEventCache;
    }

    public List<IpStateData> getStartData() {
        return this.startData;
    }

    public void setStartData(List<IpStateData> startData) {
        this.startData = startData;
    }

    public Map<IpStateData, Long> getEndData() {
        return this.endData;
    }

    public void setEndData(Map<IpStateData, Long> endData) {
        this.endData = endData;
    }

    @Override
    public int getIpAndTypeAbnormalNum() {
        if (null != this.cleanExceptionRecords && null != this.detectExceptionRecords) {
            return this.cleanExceptionRecords.size() + this.detectExceptionRecords.size();
        }
        if (null == this.cleanExceptionRecords && null != this.detectExceptionRecords) {
            return this.detectExceptionRecords.size();
        }
        if (null != this.cleanExceptionRecords && null == this.detectExceptionRecords) {
            return this.cleanExceptionRecords.size();
        }
        return 0;
    }

    @Override
    public int getIpAbnormalNum() {
        if (null != this.cleanIpAttackRecords && null != this.detectIpAttackRecords) {
            return this.cleanIpAttackRecords.size() + this.detectIpAttackRecords.size();
        }
        if (null == this.cleanIpAttackRecords && null != this.detectIpAttackRecords) {
            return this.detectIpAttackRecords.size();
        }
        if (null != this.cleanIpAttackRecords && null == this.detectIpAttackRecords) {
            return this.cleanIpAttackRecords.size();
        }
        return 0;
    }

    @Override
    public int getIpAttackFlow5minNum() {
        if (null != this.ipEventMaps) {
            return this.ipEventMaps.size();
        }
        return 0;
    }

    @Override
    public int getIpAttackFlow1hourNum() {
        if (null != this.attackTypeEventCache) {
            return this.attackTypeEventCache.size();
        }
        return 0;
    }

    @Override
    public int getWaitStartDivertIpNum() {
        if (null == this.startData) {
            return 0;
        }
        return this.startData.size();
    }

    @Override
    public int getWaitStopDivertIpNum() {
        if (null == this.endData) {
            return 0;
        }
        return this.endData.size();
    }

    @Override
    public String getMemorySpace() {
        return this.getMemorySpaceMillis() + "KB";
    }

    public int getMemorySpaceMillis() {
        int exceptionEventSpace = 1550 * this.getIpAndTypeAbnormalNum();
        int exceptionEventTypeSpace = 288 * this.getIpAndTypeAbnormalNum();
        int ipAttackEventSpace = 2000 * this.getIpAbnormalNum();
        int ipAttackEventTypeSpace = 184 * this.getIpAbnormalNum();
        int srcIpSpace = (this.getIpAndTypeAbnormalNum() + this.getIpAbnormalNum()) * 15 * 8 * 16;
        int ipAttack5minSpace = 528 * this.getIpAttackFlow5minNum() * 2 + 288 * this.getIpAttackFlow5minNum() + 100 * this.getIpAttackFlow5minNum();
        int ipAttack1hourSpace = 528 * this.getIpAttackFlow1hourNum() + 184 * this.getIpAttackFlow1hourNum();
        int divertSpace = 184 * (this.getWaitStartDivertIpNum() + this.getWaitStopDivertIpNum()) + 24 * this.getWaitStopDivertIpNum();
        int totalSpace = exceptionEventSpace + exceptionEventTypeSpace + ipAttackEventSpace + ipAttackEventTypeSpace + srcIpSpace + ipAttack5minSpace + ipAttack1hourSpace + divertSpace;
        return totalSpace / 1024;
    }

    public int getEventCount() {
        return this.getIpAndTypeAbnormalNum() * 3 + this.getIpAbnormalNum() * 4 + this.getIpAttackFlow1hourNum() + this.getIpAttackFlow5minNum();
    }

    public String toString() {
        return "AbnormalFlow [getIpAbnormalNum()=" + this.getIpAbnormalNum() + ", getIpAndTypeAbnormalNum()=" + this.getIpAndTypeAbnormalNum() + ", getIpAttackFlow1hourNum()=" + this.getIpAttackFlow1hourNum() + ", getIpAttackFlow5minNum()=" + this.getIpAttackFlow5minNum() + "]";
    }
}

