/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.manager.mbean;

import com.hs.atic.collector.entity.pcap.CaptureTask;
import com.hs.atic.collector.entity.pcap.ZoneCaptureTask;
import com.hs.atic.collector.manager.mbean.PacketCaptureMBean;
import java.util.ArrayList;
import java.util.List;

public class PacketCapture
implements PacketCaptureMBean {
    private List<CaptureTask> zoneCaptureTask = new ArrayList<CaptureTask>();
    private List<CaptureTask> globalCaptureTask = new ArrayList<CaptureTask>();

    public synchronized void addCaptureTask(CaptureTask task) {
        if (task instanceof ZoneCaptureTask) {
            this.zoneCaptureTask.add(task);
        } else {
            this.globalCaptureTask.add(task);
        }
    }

    public synchronized void removeCaptureTask(CaptureTask task) {
        if (task instanceof ZoneCaptureTask) {
            this.zoneCaptureTask.remove(task);
        } else {
            this.globalCaptureTask.remove(task);
        }
    }

    public synchronized List<CaptureTask> getZoneCaptureClone() {
        ArrayList<CaptureTask> clone = new ArrayList<CaptureTask>();
        clone.addAll(this.zoneCaptureTask);
        return clone;
    }

    @Override
    public String getMemorySpace() {
        return this.getMemorySpaceMillis() + "KB";
    }

    public int getMemorySpaceMillis() {
        int globalSpace = 1024 * this.getUnFinishedGlobalCaptureFileNum();
        int zoneUnFinishedFileSpace = 1272 * this.getUnFinishedzoneCaptureFileNum();
        int zoneUnFinishedFileIndexSpace = 192 * this.getZoneCaptureFileIndexNum();
        return (globalSpace + zoneUnFinishedFileSpace + zoneUnFinishedFileIndexSpace) / 1024;
    }

    @Override
    public synchronized int getGlobalCaptureTaskNum() {
        return this.globalCaptureTask.size();
    }

    @Override
    public int getUnFinishedGlobalCaptureFileNum() {
        return this.getGlobalCaptureTaskNum();
    }

    @Override
    public int getUnFinishedzoneCaptureFileNum() {
        List<CaptureTask> list = this.getZoneCaptureClone();
        int count = 0;
        for (CaptureTask task : list) {
            count += ((ZoneCaptureTask)task).getFiles().size();
        }
        return count;
    }

    @Override
    public synchronized int getZoneCaptureTaskNum() {
        return this.zoneCaptureTask.size();
    }

    @Override
    public int getZoneCaptureFileIndexNum() {
        List<CaptureTask> list = this.getZoneCaptureClone();
        int count = 0;
        for (CaptureTask task : list) {
            count += ((ZoneCaptureTask)task).getFileIndexs().size();
        }
        return count;
    }

    public int getAllCaptureFileSize() {
        return this.getUnFinishedzoneCaptureFileNum() + this.getUnFinishedGlobalCaptureFileNum();
    }

    public String toString() {
        return "PacketCapture [getAllCaptureFileSize()=" + this.getAllCaptureFileSize() + ", getGlobalCaptureTaskNum()=" + this.getGlobalCaptureTaskNum() + ", getUnFinishedGlobalCaptureFileNum()=" + this.getUnFinishedGlobalCaptureFileNum() + ", getUnFinishedzoneCaptureFileNum()=" + this.getUnFinishedzoneCaptureFileNum() + ", getZoneCaptureFileIndexNum()=" + this.getZoneCaptureFileIndexNum() + ", getZoneCaptureTaskNum()=" + this.getZoneCaptureTaskNum() + "]";
    }
}

