/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.transponder;

import com.hs.atic.collector.db.monitor.DBSysConf;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class PacketsTransponder {
    private static final String QUERY_IP_KEY = "transmit_ip";
    private static final String QUERY_PORT_KEY = "transmit_port";
    private static final int DEFAULT_RECEIVE_PORT = 9112;
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();
    DatagramSocket sendSocket;
    private String clientIp;
    private int clientPort;
    private boolean shoudSend = false;

    public PacketsTransponder() {
        String port;
        DBSysConf db = new DBSysConf();
        this.clientIp = db.querySysValue(QUERY_IP_KEY);
        if (null != this.clientIp && !"".equals(this.clientIp)) {
            this.shoudSend = true;
        }
        if (null != (port = db.querySysValue(QUERY_PORT_KEY)) && !"".equals(port)) {
            this.clientPort = Integer.parseInt(port);
        }
        if (this.clientPort < 1) {
            this.clientPort = 9112;
        }
        try {
            if (this.shoudSend) {
                this.sendSocket = new DatagramSocket();
            }
        }
        catch (SocketException e) {
            LOGGER.error((Object)"init transponder socket failure", (Throwable)e);
        }
    }

    public void transmit(DatagramPacket packet) {
        if (this.shoudSend) {
            try {
                byte[] b = this.addDeviceIp(packet);
                DatagramPacket p = new DatagramPacket(b, b.length, InetAddress.getByName(this.clientIp), this.clientPort);
                this.sendSocket.send(p);
            }
            catch (UnknownHostException e) {
                LOGGER.error((Object)"transponder transmit packet failure", (Throwable)e);
                try {
                    if (null != this.sendSocket) {
                        this.sendSocket.close();
                    }
                    this.sendSocket = new DatagramSocket();
                }
                catch (SocketException e1) {
                    LOGGER.error((Object)"init transponder socket failure", (Throwable)e1);
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"transponder transmit packet failure", (Throwable)e);
                try {
                    if (null != this.sendSocket) {
                        this.sendSocket.close();
                    }
                    this.sendSocket = new DatagramSocket();
                }
                catch (SocketException e1) {
                    LOGGER.error((Object)"init transponder socket failure", (Throwable)e1);
                }
            }
        }
    }

    public byte[] addDeviceIp(DatagramPacket packet) {
        String ip = packet.getAddress().getHostName();
        byte[] b = new byte[packet.getData().length + 4 + 16];
        byte[] t = new byte[4];
        t[0] = IpTransformer.isIpv6(ip) ? 6 : 4;
        System.arraycopy(IpTransformer.string2Bytes(ip), 0, b, 0, 16);
        System.arraycopy(t, 0, b, 16, 4);
        System.arraycopy(packet.getData(), 0, b, 20, packet.getData().length);
        return b;
    }
}

