/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.util;

import com.hs.atic.collector.entity.event.OriginalExceptionEvent;
import com.hs.atic.collector.util.IPUtil;
import com.hs.atic.collector.util.IpTransformer;
import com.hs.atic.collector.util.LogManager;
import com.hs.atic.collector.util.UnsignedDataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class AttackEventUtil {
    private static final Logger LOGGER = LogManager.getInstance().getReceiveLog();

    private AttackEventUtil() {
    }

    public static void readIpv4AddrAndPort(UnsignedDataInputStream stream, OriginalExceptionEvent event, long count) throws IOException {
        int i;
        int ipv4Count = Integer.parseInt(String.valueOf(count));
        String[] ipv4Addrs = new String[ipv4Count];
        int[] dstPorts = new int[ipv4Count];
        int[] srcPorts = new int[ipv4Count];
        ArrayList<Integer> errorIps = new ArrayList<Integer>();
        for (i = 0; i < ipv4Count; ++i) {
            long ip = stream.readUnsignedInt();
            String ipStr = IpTransformer.long2StringFormat(ip);
            if (IPUtil.isIpv4(ipStr)) {
                ipv4Addrs[i] = ipStr;
                continue;
            }
            LOGGER.error((Object)("drop source ip cause not ipv4:" + ipStr));
            errorIps.add(i);
        }
        for (i = 0; i < ipv4Count; ++i) {
            int dstPort;
            dstPorts[i] = dstPort = stream.readUnsignedShort();
        }
        for (i = 0; i < ipv4Count; ++i) {
            int srcPort;
            srcPorts[i] = srcPort = stream.readUnsignedShort();
        }
        StringBuffer buffer = null;
        for (int i2 = 0; i2 < ipv4Count; ++i2) {
            if (errorIps.contains(i2)) continue;
            buffer = new StringBuffer();
            buffer.append(ipv4Addrs[i2]).append('(');
            buffer.append(srcPorts[i2]).append("->");
            buffer.append(dstPorts[i2]).append(')');
            event.addAttacker(buffer.toString());
        }
    }

    public static void readIpv6AddrAndPort(UnsignedDataInputStream stream, OriginalExceptionEvent event, long count) throws IOException {
        int i;
        int ipv6Count = Integer.parseInt(String.valueOf(count));
        String[] ipv6Addrs = new String[ipv6Count];
        int[] dstPorts = new int[ipv6Count];
        int[] srcPorts = new int[ipv6Count];
        for (i = 0; i < ipv6Count; ++i) {
            byte[] b = new byte[16];
            if (stream.read(b) != 16) {
                LOGGER.error((Object)"stream read error");
            }
            ipv6Addrs[i] = IpTransformer.byte2String(b, 6);
        }
        for (i = 0; i < ipv6Count; ++i) {
            int dstPort;
            dstPorts[i] = dstPort = stream.readUnsignedShort();
        }
        for (i = 0; i < ipv6Count; ++i) {
            int srcPort;
            srcPorts[i] = srcPort = stream.readUnsignedShort();
        }
        StringBuffer buffer = null;
        for (int i2 = 0; i2 < ipv6Count; ++i2) {
            buffer = new StringBuffer();
            buffer.append(ipv6Addrs[i2]).append('(');
            buffer.append(srcPorts[i2]).append("->");
            buffer.append(dstPorts[i2]).append(')');
            event.addAttacker(buffer.toString());
        }
    }

    public static void setExceptionEventType(OriginalExceptionEvent event, int state) {
        switch (state) {
            case 1: {
                event.setCurrentState(1);
                break;
            }
            case 2: {
                event.setCurrentState(0);
                break;
            }
            case 3: {
                event.setCurrentState(2);
                long currentTimeMillis = event.getLogTime();
                event.setAttackStartTime(currentTimeMillis);
                event.setAttackEndTime(currentTimeMillis);
                break;
            }
            default: {
                event.setCurrentState(1);
            }
        }
    }
}

